<?php if(!defined('PLX_ROOT')) exit; ?>
<?php
/**
 * Plugin plxSuperContact
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Initialised by Mathieu Ribot @ MontrezVous.net
 * Licence GNU_GPL
 **/

# récuperation d'une instance de plxShow
$plxShow = plxShow::getInstance();
$plxShow->plxMotor->plxCapcha = new plxCapcha();
$plxPlugin = $plxShow->plxMotor->plxPlugins->getInstance('plxSuperContact');

$error=false;
$success=false;
$captcha = $plxPlugin->getParam('captcha')=='' ? '1' : $plxPlugin->getParam('captcha');

if(!empty($_POST)) {
        //On récupère les informations données par le visiteur
		$name = plxUtils::unSlash($_POST['name']);
		$prenom = $plxPlugin->getParam('prenom')  > 0 ? plxUtils::unSlash($_POST['prenom']) : '';
		$mail = plxUtils::unSlash($_POST['mail']);
		$content = plxUtils::unSlash($_POST['content']);
		$entreprise = $plxPlugin->getParam('entreprise')  > 0 ? plxUtils::unSlash($_POST['entreprise']) : '';
		$telephone = $plxPlugin->getParam('telephone') > 0 ? plxUtils::unSlash($_POST['telephone']) : '';
		if ($plxPlugin->getParam('adresse') > 0) {
			$rue = plxUtils::unSlash($_POST['rue']);
			$cp = plxUtils::unSlash($_POST['cp']);
			$ville = plxUtils::unSlash($_POST['ville']);
		}
		$fax = $plxPlugin->getParam('fax')  > 0 ? plxUtils::unSlash($_POST['fax']) : '';
		$reponse = $plxPlugin->getParam('quest')  > 0 ? plxUtils::unSlash($_POST['reponse']) : '';		
		$reponse_x = $plxPlugin->getParam('quest_x')  > 0 ? plxUtils::unSlash($_POST['reponse_x']) : '';
		$reponse_y = $plxPlugin->getParam('quest_y')  > 0 ? plxUtils::unSlash($_POST['reponse_y']) : '';
		$reponse_z = $plxPlugin->getParam('quest_z')  > 0 ? plxUtils::unSlash($_POST['reponse_z']) : '';		
		$motif = $plxPlugin->getParam('motif')  > 0 ? plxUtils::unSlash($_POST['motif']) : '';
		$sexe = $plxPlugin->getParam('sexe')  > 0 ? plxUtils::unSlash($_POST['sexe']) : '';
		$site = $plxPlugin->getParam('site')  > 0 ? plxUtils::unSlash($_POST['site']) : '';
		$skype = $plxPlugin->getParam('skype')  > 0 ? plxUtils::unSlash($_POST['skype']) : '';
        
		# pour compatibilité avec le plugin plxMyCapchaImage
		if(strlen($_SESSION['capcha'])<=10)
			$_SESSION['capcha']=sha1($_SESSION['capcha']);
		
        //On vérifie que les champs nécéssaires sont bien remplis sinon on affiche un message d'érreur
        if(trim($name)=='')
			$error = $plxPlugin->getLang('L_SC_ERR_NAME');
		elseif(!plxUtils::checkMail($mail))
			$error = $plxPlugin->getLang('L_SC_ERR_EMAIL');
		elseif(trim($content)=='')
			$error = $plxPlugin->getLang('L_SC_ERR_CONTENT');
		elseif($captcha != 0 AND $_SESSION['capcha'] != sha1($_POST['rep']))
			$error = $plxPlugin->getLang('L_SC_ERR_ANTISPAM');
        
        if(trim($entreprise)=='' and $plxPlugin->getParam('entp_obligatoire') and $plxPlugin->getParam('entreprise'))
			$error = $plxPlugin->getLang('L_SC_ERR_ENTREPRISE');
        if(trim($prenom)=='' and $plxPlugin->getParam('prenom_obligatoire') and $plxPlugin->getParam('prenom'))
			$error = $plxPlugin->getLang('L_SC_ERR_PRENOM');
        if(trim($telephone)=='' and $plxPlugin->getParam('tel_obligatoire') and $plxPlugin->getParam('telephone'))
			$error = $plxPlugin->getLang('L_SC_ERR_TELEPHONE');
		if ($plxPlugin->getParam('adresse') > 0) {
			if(trim($rue)=='' and $plxPlugin->getParam('adrs_obligatoire') and $plxPlugin->getParam('adresse'))
				$error = $plxPlugin->getLang('L_SC_ERR_RUE');
			if(trim($cp)=='' and $plxPlugin->getParam('adrs_obligatoire') and $plxPlugin->getParam('adresse'))
				$error = $plxPlugin->getLang('L_SC_ERR_CP');
			if(trim($ville)=='' and $plxPlugin->getParam('adrs_obligatoire') and $plxPlugin->getParam('adresse'))
				$error = $plxPlugin->getLang('L_SC_ERR_VILLE');
		}
        if(trim($telephone)=='' and $plxPlugin->getParam('tel_obligatoire') and $plxPlugin->getParam('telephone'))
			$error = $plxPlugin->getLang('L_SC_ERR_TEL');
        if(trim($fax)=='' and $plxPlugin->getParam('fax_obligatoire') and $plxPlugin->getParam('fax'))
			$error = $plxPlugin->getLang('L_SC_ERR_FAX');
        if(trim($reponse)=='' and $plxPlugin->getParam('question_obligatoire') and $plxPlugin->getParam('quest'))
			$error = $plxPlugin->getLang('L_SC_ERR_REPONSE').' : '.$plxPlugin->getParam($plxPlugin->getLang('L_SC_INTITULE_QUESTION'));
        if(trim($reponse_x)=='' and $plxPlugin->getParam('question_obligatoire_x') and $plxPlugin->getParam('quest_x'))
			$error = $plxPlugin->getLang('L_SC_ERR_REPONSE').' : '.$plxPlugin->getParam($plxPlugin->getLang('L_SC_INTITULE_QUESTION_X'));
        if(trim($reponse_y)=='' and $plxPlugin->getParam('question_obligatoire_y') and $plxPlugin->getParam('quest_y'))
			$error = $plxPlugin->getLang('L_SC_ERR_REPONSE').' : '.$plxPlugin->getParam($plxPlugin->getLang('L_SC_INTITULE_QUESTION_Y'));
		if(trim($reponse_z)=='' and $plxPlugin->getParam('question_obligatoire_z') and $plxPlugin->getParam('quest_z'))
			$error = $plxPlugin->getLang('L_SC_ERR_REPONSE').' : '.$plxPlugin->getParam($plxPlugin->getLang('L_SC_INTITULE_QUESTION_Z'));		
        if(trim($motif)=='' and $plxPlugin->getParam('motif_obligatoire') and $plxPlugin->getParam('motif'))
			$error = $plxPlugin->getLang('L_SC_ERR_MOTIF');
        if(trim($sexe)=='' and $plxPlugin->getParam('sexe_obligatoire') and $plxPlugin->getParam('sexe'))
			$error = $plxPlugin->getLang('L_SC_ERR_SEXE');
        if(trim($site)=='' and $plxPlugin->getParam('site_obligatoire') and $plxPlugin->getParam('site'))
			$error = $plxPlugin->getLang('L_SC_ERR_SITE');
        if(trim($skype)=='' and $plxPlugin->getParam('skype_obligatoire') and $plxPlugin->getParam('skype'))
			$error = $plxPlugin->getLang('L_SC_ERR_SKYPE');
        
        //On construit le contenu du mail
        $rajout='';
        $nom_expediteur='';
        if($plxPlugin->getParam('sexe')){
            if($sexe){$rajout.=$plxPlugin->getLang('L_SC_NAME').' '.$plxPlugin->getLang('L_SC_MR');}else{$rajout.=$plxPlugin->getLang('L_SC_NAME').' '.$plxPlugin->getLang('L_SC_MM');}
        }else{
            $rajout.=$plxPlugin->getLang('L_SC_NAME');
        }
        $rajout.=' '.ucfirst($name);
        if($plxPlugin->getParam('prenom')){$rajout.=' '.@ucfirst($prenom);$nom_expediteur.=@ucfirst($prenom).' '.ucfirst($name);}
        if($plxPlugin->getParam('date')){
            $format_date=$plxPlugin->getParam('format_date');
			include(dirname(__FILE__).'/lang/dates_'.$plxPlugin->default_lang.'.php');
            if($plxPlugin->default_lang=="fr"){
                switch($format_date) {
                    case 1:
                        $ladate = 'Le '.date("d/m/Y").' - '.date("H").'h'.date("i");
                    break;
                    case 0:
                        $ladate = 'Le '.$dates[date("N")-1].' '.date("d").' '.$dates[date("m")+6].' '.date("Y").' - '.date("H").'h'.date("i");
                    break;
                }
            }else{
                switch($format_date) {
                    case 1:
                        $ladate= 'On '.date("m/d/Y").' at '.date("H:i").' '.date("a");
                    break;
                    case 0:
                        if(date("d")==1){$suffixe="st";}else{if(date("d")==2){$suffixe="nd";}else{if(date("d")==3){$suffixe="rd";}else{$suffixe="th";}}}
                        $ladate= $plxPlugin->getLang('L_SC_ON').' '.$dates[date("N")-1].' '.$dates[date("m")+6].' '. $plxPlugin->getLang('L_SC_THE').' '.date("d").$suffixe.' '. $plxPlugin->getLang('L_SC_AT').' '.date("H:i").' '.date("a");
                    break;
                }
            }
            $rajout.="\n".$ladate;
        }
        if($plxPlugin->getParam('motif')){$rajout .= "\n".$plxPlugin->getLang('L_SC_MOTIF3').': '.@ucfirst($motif);}
        if($plxPlugin->getParam('entreprise')){$rajout .= "\n".$plxPlugin->getLang('L_SC_ENTREPRISE3').': '.@ucfirst($entreprise); $nom_expediteur.=' ('.@ucfirst($entreprise).')';}
        if($plxPlugin->getParam('telephone')){$rajout .= "\n".$plxPlugin->getLang('L_SC_TELEPHONE3').': '.@$telephone;}
        if($plxPlugin->getParam('fax')){$rajout .= "\n".$plxPlugin->getLang('L_SC_FAX3').': '.@$fax;}
        if($plxPlugin->getParam('skype')){$rajout .= "\n".$plxPlugin->getLang('L_SC_SKYPE3').': '.$skype;}
        if($plxPlugin->getParam('site')){$rajout.= "\n".$plxPlugin->getLang('L_SC_SITE3').': '.$site;}
        if($plxPlugin->getParam('adresse')){
            $ville=ucfirst($ville);
            $rajout .= "\n".$plxPlugin->getLang('L_SC_ADRS').': '.@$rue.' '.@$ville.' '.@$cp;
            if(strlen($rue)>=7 and strlen($ville)>=2){
                $url_plan='http://www.google.com/maps/preview#!q='.$rue.'%2C+'.$ville.'%2C+'.$cp;
                $url_plan=str_replace(" ","+",$url_plan);
                $rajout .= "\n".' => '.$url_plan;
            }
        }
        if($plxPlugin->getParam('quest')){$demande=$plxPlugin->getParam('question_'.$plxPlugin->default_lang);
            $rajout.= "\n".$demande.' '.$reponse;
        }
        if($plxPlugin->getParam('quest_x')){$demande_x=$plxPlugin->getParam('question_x_'.$plxPlugin->default_lang);
            $rajout .= "\n".$demande_x.' '.$reponse_x;
        }
        if($plxPlugin->getParam('quest_y')){$demande_y=$plxPlugin->getParam('question_y_'.$plxPlugin->default_lang);
            $rajout .= "\n".$demande_y.' '.$reponse_y;
        }
        if($plxPlugin->getParam('quest_z')){$demande_z=$plxPlugin->getParam('question_z_'.$plxPlugin->default_lang);
            $rajout .= "\n".$demande_z.' '.$reponse_z;
        }		
        if($plxPlugin->getParam('nom_site')){
            $rajout .= "\n".$plxPlugin->getLang('L_SC_NOM_SITE3').': '.$_SERVER['HTTP_HOST'];
        }
        if($plxPlugin->getParam('url_site')){
            $url='http://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
            $rajout .= "\n".$plxPlugin->getLang('L_SC_URL_SITE3').': '.$url;
        }
        if($plxPlugin->getParam('ip')){
            if (isset($_SERVER["HTTP_CLIENT_IP"])){$ip_visiteur=$_SERVER["HTTP_CLIENT_IP"];}
            elseif (isset($_SERVER["HTTP_X_FORWARDED_FOR"])){$ip_visiteur=$_SERVER["HTTP_X_FORWARDED_FOR"];}
            elseif (isset($_SERVER["HTTP_X_FORWARDED"])){$ip_visiteur=$_SERVER["HTTP_X_FORWARDED"];}
            elseif (isset($_SERVER["HTTP_FORWARDED_FOR"])){$ip_visiteur=$_SERVER["HTTP_FORWARDED_FOR"];}
            elseif (isset($_SERVER["HTTP_FORWARDED"])){$ip_visiteur=$_SERVER["HTTP_FORWARDED"];}
            else{$ip_visiteur=$_SERVER["REMOTE_ADDR"];}
            $rajout .= "\n".$plxPlugin->getLang('L_SC_IP3').' : '.$ip_visiteur;
        }
        
        $rajout .= "\n".'Message:'."\n".ucfirst($content);
        
        //On envoit le mail
        if(!$error) {
                
                if(plxUtils::sendMail($nom_expediteur,$mail,$plxPlugin->getParam('email'),$plxPlugin->getParam('subject_'.$plxPlugin->default_lang),$rajout,'text',$plxPlugin->getParam('email_cc'),$plxPlugin->getParam('email_bcc')))
			$success = $plxPlugin->getParam('thankyou_'.$plxPlugin->default_lang);
		else
			$error = $plxPlugin->getLang('L_SC_ERR_SENDMAIL');
	}
        //echo $rajout;
}  else {
	$name = '';
	$prenom = '';
	$mail = '';
	$label =  '';
	$placeholder = '';
	$content = '';
	$skype = '';
	$telephone = '';
	$adresse = '';
	$entreprise = '';
	$fax = '';
	$site = '';
	$rue = '';
	$cp = '';
	$ville = '';
	$reponse = '';
	$reponse_x = '';
	$reponse_y = '';
	$reponse_z = '';	
	$motif = '';

}?>


<!-- Formulaire de contact public -->
<div id="form_contact">
	<?php if($error): ?>
	<p class="contact_error"><?php echo $error ?></p>
	<?php endif; ?>
	<?php if($success): ?>
        
	<p class="contact_success"><?php echo plxUtils::strCheck($success) ?></p>
	<?php else: ?>
		<?php if($plxPlugin->getParam('mnuText_'.$plxPlugin->default_lang)): ?>
			<p class="text_contact">
			<?php echo $plxPlugin->getParam('mnuText_'.$plxPlugin->default_lang) ?>
			</p>
		<?php endif; ?>
        <form action="#form" method="post" class="contact-form">
		<fieldset>
        <?php if($plxPlugin->getParam('sexe')){?>
            <select class="select" name="sexe">
                <option value="1"><?php $plxPlugin->lang('L_SC_MR') ?></option>
                <option value="0"><?php $plxPlugin->lang('L_SC_MM') ?></option>
            </select>
        <?php }?>
		<p>
			<?php if($plxPlugin->getParam('label')) : ?>
			<label for="name"><?php $plxPlugin->lang('L_SC_FORM_NAME') ?>&nbsp;:&nbsp;*</label>
			<?php endif; ?>
			<?php if (!$plxPlugin->getParam('label')) { $oblig = ' *'; } else { $oblig =  ''; }
			$placeholder = ($plxPlugin->getParam('placeholder') ? 'placeholder="'.plxUtils::strCheck($plxPlugin->getLang('L_SC_FORM_NAME')).$oblig.'" ' : '') ?>
            <input <?php echo $placeholder ?> class="input" id="name" name="name" tabindex="1" type="text" size="30" value="<?php echo plxUtils::strCheck($name) ?>" maxlength="30"  required />
		</p>		
		<?php if($plxPlugin->getParam('prenom')==1){?>
			<p>
				<?php if($plxPlugin->getParam('label')) : ?>
				<label for="prenom"><?php $plxPlugin->lang('L_SC_PRENOM2') ?>&nbsp;:<?php if($plxPlugin->getParam('prenom_obligatoire')){echo' *';}?></label>
				<?php endif; ?>
				<?php if ($plxPlugin->getParam('prenom_obligatoire') AND !$plxPlugin->getParam('label')) { $oblig = ' *'; } else { $oblig =  ''; }
				$placeholder = ($plxPlugin->getParam('placeholder') ? 'placeholder="'.plxUtils::strCheck($plxPlugin->getLang('L_SC_PRENOM2')).$oblig.'" ' : '') ?>
				<input <?php echo $placeholder ?> class="input" id="prenom" name="prenom" tabindex="2" type="text" size="30" <?php if($plxPlugin->getParam('prenom_obligatoire')){echo'required';}?> value="<?php echo plxUtils::strCheck($prenom) ?>" />
			</p>	
        <?php }?>
        <p>
			<?php if($plxPlugin->getParam('label')) : ?>
			<label for="mail"><?php $plxPlugin->lang('L_SC_FORM_MAIL') ?>&nbsp;:&nbsp;*</label>
			<?php endif; ?>
			<?php if (!$plxPlugin->getParam('label')) { $oblig = ' *'; } else { $oblig =  ''; }
			$placeholder = ($plxPlugin->getParam('placeholder') ? 'placeholder="'.plxUtils::strCheck($plxPlugin->getLang('L_SC_FORM_MAIL')).$oblig.'" ' : '') ?>
			<input <?php echo $placeholder ?> class="input" id="mail" name="mail" tabindex="3" type="email" size="30" value="<?php echo plxUtils::strCheck($mail) ?>" required />
		</p>
		<?php if($plxPlugin->getParam('skype')){?>
		    <p>
				<?php if($plxPlugin->getParam('label')) : ?>
				<label for="skype"><?php $plxPlugin->lang('L_SC_SKYPE2') ?>&nbsp;:<?php if($plxPlugin->getParam('skype_obligatoire')){echo' *';}?></label>
				<?php endif; ?>
				<?php if ($plxPlugin->getParam('skype_obligatoire') AND !$plxPlugin->getParam('label')) { $oblig = ' *'; } else { $oblig =  ''; }
				$placeholder = ($plxPlugin->getParam('placeholder') ? 'placeholder="'.plxUtils::strCheck($plxPlugin->getLang('L_SC_SKYPE2')).$oblig.'" ' : '') ?>
				<input <?php echo $placeholder ?> class="input" id="skype" name="skype" tabindex="7" type="text" size="30" <?php if($plxPlugin->getParam('skype_obligatoire')){echo'required';}?> value="<?php echo plxUtils::strCheck($skype) ?>" />
			</p>
        <?php }
        if($plxPlugin->getParam('entreprise')==1){?>
            <p>
				<?php if($plxPlugin->getParam('label')) : ?>
				<label for="entreprise"><?php $plxPlugin->lang('L_SC_ENTREPRISE2') ?>&nbsp;:<?php if($plxPlugin->getParam('entp_obligatoire')){echo' *';}?></label>
				<?php endif; ?>
				<?php if ($plxPlugin->getParam('entp_obligatoire') AND !$plxPlugin->getParam('label')) { $oblig = ' *'; } else { $oblig =  ''; }
				$placeholder = ($plxPlugin->getParam('placeholder') ? 'placeholder="'.plxUtils::strCheck($plxPlugin->getLang('L_SC_ENTREPRISE2')).$oblig.'" ' : '') ?>
                <input <?php echo $placeholder ?> class="input" id="entreprise" name="entreprise" tabindex="4" type="text" size="30" <?php if($plxPlugin->getParam('entp_obligatoire')){echo'required';}?> value="<?php echo plxUtils::strCheck($entreprise) ?>" />
			</p>
        <?php }
        if($plxPlugin->getParam('telephone')){?>
            <p>
				<?php if($plxPlugin->getParam('label')) : ?>
				<label for="telephone"><?php $plxPlugin->lang('L_SC_TELEPHONE2') ?>&nbsp;:<?php if($plxPlugin->getParam('tel_obligatoire')){echo' *';}?></label>
				<?php endif; ?>
				<?php if ($plxPlugin->getParam('tel_obligatoire') AND !$plxPlugin->getParam('label')) { $oblig = ' *'; } else { $oblig =  ''; }
				$placeholder = ($plxPlugin->getParam('placeholder') ? 'placeholder="'.plxUtils::strCheck($plxPlugin->getLang('L_SC_TELEPHONE2')).$oblig.'" ' : '') ?>
				<input <?php echo $placeholder ?> class="input" id="telephone" name="telephone" tabindex="5" type="tel" size="30"  <?php if($plxPlugin->getParam('tel_obligatoire')){echo'required';}?> value="<?php echo plxUtils::strCheck($telephone) ?>" />
			</p>		
        <?php }
        if($plxPlugin->getParam('fax')){?>
            <p>
				<?php if($plxPlugin->getParam('label')) : ?>
				<label for="fax"><?php $plxPlugin->lang('L_SC_FAX2') ?>&nbsp;:<?php if($plxPlugin->getParam('fax_obligatoire')){echo' *';}?></label>
				<?php endif; ?>
				<?php if ($plxPlugin->getParam('fax_obligatoire') AND !$plxPlugin->getParam('label')) { $oblig = ' *'; } else { $oblig =  ''; }
				$placeholder = ($plxPlugin->getParam('placeholder') ? 'placeholder="'.plxUtils::strCheck($plxPlugin->getLang('L_SC_FAX2')).$oblig.'" ' : '') ?>
                <input <?php echo $placeholder ?> class="input" id="fax" name="fax" tabindex="6" type="tel" size="30" <?php if($plxPlugin->getParam('fax_obligatoire')){echo'required';}?> value="<?php echo plxUtils::strCheck($fax) ?>" />
			</p>		
        <?php }
        if($plxPlugin->getParam('site')){?>
            <p>
				<?php if($plxPlugin->getParam('label')) : ?>
				<label for="site"><?php $plxPlugin->lang('L_SC_SITE2') ?>&nbsp;:<?php if($plxPlugin->getParam('site_obligatoire')){echo' *';}?></label>
				<?php endif; ?>
				<?php if ($plxPlugin->getParam('site_obligatoire') AND !$plxPlugin->getParam('label')) { $oblig = ' *'; } else { $oblig =  ''; }
				$placeholder = ($plxPlugin->getParam('placeholder') ? 'placeholder="'.plxUtils::strCheck($plxPlugin->getLang('L_SC_SITE2')).$oblig.'" ' : '') ?>
                <input <?php echo $placeholder ?> class="input" id="site" name="site" tabindex="7" type="url" size="30" <?php if($plxPlugin->getParam('site_obligatoire')){echo'required';}?> value="<?php echo plxUtils::strCheck($site) ?>" />
			</p>
        <?php }
        if($plxPlugin->getParam('adresse')){?>
            <p>
				<?php if($plxPlugin->getParam('label')) : ?>
				<label for="rue"><?php $plxPlugin->lang('L_SC_RUE') ?>&nbsp;:<?php if($plxPlugin->getParam('adrs_obligatoire')){echo' *';}?></label>
				<?php endif; ?>
				<?php if ($plxPlugin->getParam('adrs_obligatoire') AND !$plxPlugin->getParam('label')) { $oblig = ' *'; } else { $oblig =  ''; }
				$placeholder = ($plxPlugin->getParam('placeholder') ? 'placeholder="'.plxUtils::strCheck($plxPlugin->getLang('L_SC_RUE')).$oblig.'" ' : '') ?>
                <input <?php echo $placeholder ?> class="input" id="rue" name="rue" tabindex="8" type="text" size="50" <?php if($plxPlugin->getParam('adrs_obligatoire')){echo'required';}?> value="<?php echo plxUtils::strCheck($rue) ?>" />
			</p>	
            <p>
				<?php if($plxPlugin->getParam('label')) : ?>
				<label for="cp"><?php $plxPlugin->lang('L_SC_CP') ?>&nbsp;:<?php if($plxPlugin->getParam('adrs_obligatoire')){echo' *';}?></label>
				<?php endif; ?>
				<?php if ($plxPlugin->getParam('adrs_obligatoire') AND !$plxPlugin->getParam('label')) { $oblig = ' *'; } else { $oblig =  ''; }
				$placeholder = ($plxPlugin->getParam('placeholder') ? 'placeholder="'.plxUtils::strCheck($plxPlugin->getLang('L_SC_CP')).$oblig.'" ' : '') ?>
                <input <?php echo $placeholder ?> class="input" id="cp" name="cp" tabindex="9" type="text" size="50" <?php if($plxPlugin->getParam('adrs_obligatoire')){echo'required';}?> value="<?php echo plxUtils::strCheck($cp) ?>" />
			</p>	
            <p>
				<?php if($plxPlugin->getParam('label')) : ?>
				<label for="ville"><?php $plxPlugin->lang('L_SC_VILLE') ?>&nbsp;:<?php if($plxPlugin->getParam('adrs_obligatoire')){echo' *';}?></label>
				<?php endif; ?>
				<?php if ($plxPlugin->getParam('adrs_obligatoire') AND !$plxPlugin->getParam('label')) { $oblig = ' *'; } else { $oblig =  ''; }
				$placeholder = ($plxPlugin->getParam('placeholder') ? 'placeholder="'.plxUtils::strCheck($plxPlugin->getLang('L_SC_VILLE')).$oblig.'" ' : '') ?>
                <input <?php echo $placeholder ?> class="input" id="ville" name="ville" tabindex="10" type="text" size="30" <?php if($plxPlugin->getParam('adrs_obligatoire')){echo'required';}?> value="<?php echo plxUtils::strCheck($ville) ?>" />
			</p>	
        <?php }
        if($plxPlugin->getParam('quest')){ //question 1 ?> 
            <p>
				<?php if($plxPlugin->getParam('label')) : ?>
				<label for="reponse"><?php echo $plxPlugin->getParam('question_'.$plxPlugin->default_lang); ?><?php if($plxPlugin->getParam('question_obligatoire')){echo' *';}?></label>
				<?php endif; ?>
				<?php if ($plxPlugin->getParam('question_obligatoire') AND !$plxPlugin->getParam('label')) { $oblig = ' *'; } else { $oblig =  ''; }
				$placeholder = ($plxPlugin->getParam('placeholder') ? 'placeholder="'.plxUtils::strCheck($plxPlugin->getParam('question_'.$plxPlugin->default_lang)).$oblig.'" ' : '') ?>
				<?php if (!$plxPlugin->getParam('repons')) { ?>
                <input <?php echo $placeholder ?> class="input" id="reponse" name="reponse" tabindex="11" type="text" size="30" <?php if($plxPlugin->getParam('question_obligatoire')){echo'required';}?> value="<?php echo plxUtils::strCheck($reponse) ?>" />
				<?php } else {
				$placeholder = ($plxPlugin->getParam('placeholder') ? plxUtils::strCheck($plxPlugin->getParam('question_'.$plxPlugin->default_lang)).$oblig : '');
				$plxPlugin->supercontact->selectInput('reponse', $reponse, $plxPlugin->getParam('reponse_'.$plxPlugin->default_lang), $plxPlugin->getParam('question_obligatoire'), $placeholder);
				} ?>
			</p>		
        <?php }
        if($plxPlugin->getParam('quest_x')){ //question 2 ?>
            <p>
				<?php if($plxPlugin->getParam('label')) : ?>
				<label for="reponse_x"><?php echo $plxPlugin->getParam('question_x_'.$plxPlugin->default_lang); ?><?php if($plxPlugin->getParam('question_obligatoire_x')){echo' *';}?></label>
				<?php endif; ?>
				<?php if ($plxPlugin->getParam('question_obligatoire_x') AND !$plxPlugin->getParam('label')) { $oblig = ' *'; } else { $oblig =  ''; }
				$placeholder = ($plxPlugin->getParam('placeholder') ? 'placeholder="'.plxUtils::strCheck($plxPlugin->getParam('question_x_'.$plxPlugin->default_lang)).$oblig.'" ' : '') ?>
				<?php if (!$plxPlugin->getParam('repons_x')) { ?>
                <input <?php echo $placeholder ?> class="input" id="reponse_x" name="reponse_x" tabindex="12" type="text" size="30" <?php if($plxPlugin->getParam('question_obligatoire_x')){echo'required';}?> value="<?php echo plxUtils::strCheck($reponse_x) ?>" />
				<?php } else {
				$placeholder = ($plxPlugin->getParam('placeholder') ? plxUtils::strCheck($plxPlugin->getParam('question_x_'.$plxPlugin->default_lang)).$oblig : '');
				$plxPlugin->supercontact->selectInput('reponse_x', $reponse_x, $plxPlugin->getParam('reponse_x_'.$plxPlugin->default_lang), $plxPlugin->getParam('question_obligatoire_x'), $placeholder);
				} ?>				
			</p>	
        <?php }
        if($plxPlugin->getParam('quest_y')){ //question 3 ?>
            <p>
				<?php if($plxPlugin->getParam('label')) : ?>
				<label for="reponse_y"><?php echo $plxPlugin->getParam('question_y_'.$plxPlugin->default_lang); ?><?php if($plxPlugin->getParam('question_obligatoire_y')){echo' *';}?></label>
				<?php endif; ?>
				<?php if ($plxPlugin->getParam('question_obligatoire_y') AND !$plxPlugin->getParam('label')) { $oblig = ' *'; } else { $oblig =  ''; }
				$placeholder = ($plxPlugin->getParam('placeholder') ? 'placeholder="'.plxUtils::strCheck($plxPlugin->getParam('question_y_'.$plxPlugin->default_lang)).$oblig.'" ' : '') ?>
				<?php if (!$plxPlugin->getParam('repons_y')) { ?>				
                <input <?php echo $placeholder ?> class="input" id="reponse_y" name="reponse_y" tabindex="13" type="text" size="30" <?php if($plxPlugin->getParam('question_obligatoire_y')){echo'required';}?> value="<?php echo plxUtils::strCheck($reponse_y) ?>" />
				<?php } else {
				$placeholder = ($plxPlugin->getParam('placeholder') ? plxUtils::strCheck($plxPlugin->getParam('question_y_'.$plxPlugin->default_lang)).$oblig : '');
				$plxPlugin->supercontact->selectInput('reponse_y', $reponse_y, $plxPlugin->getParam('reponse_y_'.$plxPlugin->default_lang), $plxPlugin->getParam('question_obligatoire_y'),$placeholder);
				} ?>				
			</p>	
        <?php }
        if($plxPlugin->getParam('quest_z')){ //question 4 ?>
            <p>
				<?php if($plxPlugin->getParam('label')) : ?>
				<label for="reponse_z"><?php echo $plxPlugin->getParam('question_z_'.$plxPlugin->default_lang); ?><?php if($plxPlugin->getParam('question_obligatoire_z')){echo' *';}?></label>
				<?php endif; ?>
				<?php if ($plxPlugin->getParam('question_obligatoire_z') AND !$plxPlugin->getParam('label')) { $oblig = ' *'; } else { $oblig =  ''; }
				$placeholder = ($plxPlugin->getParam('placeholder') ? 'placeholder="'.plxUtils::strCheck($plxPlugin->getParam('question_z_'.$plxPlugin->default_lang)).$oblig.'" ' : '') ?>
				<?php if (!$plxPlugin->getParam('repons_z')) { ?>				
                <input <?php echo $placeholder ?> class="input" id="reponse_z" name="reponse_z" tabindex="13" type="text" size="30" <?php if($plxPlugin->getParam('question_obligatoire_z')){echo'required';}?> value="<?php echo plxUtils::strCheck($reponse_z) ?>" />
				<?php } else {
				$placeholder = ($plxPlugin->getParam('placeholder') ? plxUtils::strCheck($plxPlugin->getParam('question_z_'.$plxPlugin->default_lang)).$oblig : '');
				$plxPlugin->supercontact->selectInput('reponse_z', $reponse_z, $plxPlugin->getParam('reponse_z_'.$plxPlugin->default_lang), $plxPlugin->getParam('question_obligatoire_z'),$placeholder);
				} ?>				
			</p>	
        <?php }		
        if($plxPlugin->getParam('motif')){?>
            <p>
				<?php if($plxPlugin->getParam('label')) : ?>
				<label for="motif"><?php $plxPlugin->lang('L_SC_MOTIF2') ?>&nbsp;:<?php if($plxPlugin->getParam('motif_obligatoire')){echo' *';}?></label>
				<?php endif; ?>
				<?php if ($plxPlugin->getParam('motif_obligatoire') AND !$plxPlugin->getParam('label')) { $oblig = ' *'; } else { $oblig =  ''; }
				$placeholder = ($plxPlugin->getParam('placeholder') ? 'placeholder="'.plxUtils::strCheck($plxPlugin->getLang('L_SC_MOTIF2')).$oblig.'" ' : '') ?>
                <input <?php echo $placeholder ?> class="input" id="motif" name="motif" tabindex="14" type="text" size="30" <?php if($plxPlugin->getParam('motif_obligatoire')){echo'required';}?> value="<?php echo plxUtils::strCheck($motif) ?>" />
			</p>	
        <?php } ?>
        <p>
			<?php if($plxPlugin->getParam('label')) : ?>
			<label for="message"><?php $plxPlugin->lang('L_SC_FORM_CONTENT') ?>&nbsp;:&nbsp;*</label>
			<?php endif; ?>
			<?php if (!$plxPlugin->getParam('label')) { $oblig = ' *'; } else { $oblig =  ''; }
			$placeholder = ($plxPlugin->getParam('placeholder') ? 'placeholder="'.plxUtils::strCheck($plxPlugin->getLang('L_SC_FORM_CONTENT')).$oblig.'" ' : '') ?>
			<textarea <?php echo $placeholder ?> class="input comment-fileld" id="message" name="content" tabindex="15" cols="60" rows="12" required ><?php echo plxUtils::strCheck($content) ?></textarea>
        </p>
		<?php if($captcha): ?>
		<p>
		<label for="id_rep"><strong><?php $plxPlugin->lang('L_SC_FORM_ANTISPAM') ?></strong></label>
		<?php $plxShow->capchaQ(); ?>
		<input id="id_rep" name="rep" type="text" size="2" maxlength="1" style="width: auto; display: inline;" autocomplete="off" />
		</p>
		<?php endif; ?>
		<p>
			<input type="submit" class="btn-creature classic submit" name="submit" tabindex="17" value="<?php $plxPlugin->lang('L_SC_FORM_BTN_SEND') ?>" />
			<input type="reset" class="btn-creature classic submit" name="reset" tabindex="18" value="<?php $plxPlugin->lang('L_SC_FORM_BTN_RESET') ?>" />
		</p>
		<span><?php $plxPlugin->lang('L_SC_CHAMPS_OBLIGATOIRES') ?>.</span>
		</fieldset>
	</form>
	<?php endif; ?>
</div>