<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/
include(dirname(__FILE__).'/lib/class.plx.sondage.php');
 
class plxSondage extends plxPlugin {

	# param	default_lang	langue par défaut utilisée par PluXml
	public function __construct($default_lang) {

		# appel du constructeur de la classe plxPlugin (obligatoire)
		parent::__construct($default_lang);

  		# droits pour accéder à la page config.php du plugin
  		$this->setConfigProfil(PROFIL_ADMIN);
		
		# Vérification des versions du plugin
		$this->sondage = new sondage();
		  
  		# Ajouts des hooks
		$this->addHook('Index', 'Index');		
  		$this->addHook('ThemeEndHead', 'ThemeEndHead');		
  		$this->addHook('plxShowSondage', 'plxShowSondage');
	}

	public function ThemeEndHead() {
		echo "\n\t".'<link rel="stylesheet" href="'.PLX_PLUGINS.'plxSondage/css/plxsondage.css" type="text/css" media="screen" />'."\n";	
	}	

	public function Index() {

		$nb_max_votes = plxPlugin::getParam('sTotal_votes'); // 0 si illimité
		$nb_votes = 0;
		$un_vote_ip = plxPlugin::getParam('sUnvoteip');
		$voter = false;
		$ips = array();
		$nb = plxPlugin::getParam('sNbq'); // nombre de questions
		$reponses = array();
		$resultats = array();
		
		$reponses = $this->getReponses($nb);

		$choix = count($reponses)-1;
		
		if (isset($_POST['vote'])) {
			
		if (plxPlugin::getParam('sUnvoteip')== 1) {
			if (plxPlugin::getParam('ip_visiteur') != '') {
				$ips = unserialize(plxPlugin::getParam('ip_visiteur')); // load ip array
				if(in_array($_SERVER['REMOTE_ADDR'],$ips)){ // submit vote
					$voter = true;
				}
			}
		}
			$resultats = $this->getResultats($nb);

			$vote = $_POST['vote'];
			for ($numero = 0; $numero <= $choix; $numero ++) {
				$ligne[$numero] = $resultats[$numero];
				if ($numero == $vote) {
					$ligne[$numero] ++;
				}
				$nb_votes += $ligne[$numero];
			}

		if(($nb_votes <= $nb_max_votes OR $nb_max_votes == 0) AND !$voter) {
			setcookie('PLXSONDAGE', 'dejavote', time()+30*24*60*60) ; //Mise en place d'un cookie valide 1 mois			
			if($un_vote_ip == 1){
				$ips[] = $_SERVER['REMOTE_ADDR']; // ajouter nouvelle ip
				plxPlugin::setParam('ip_visiteur', serialize($ips), 'cdata'); // sauve ip
			}
			
			
			plxPlugin::setParam('sNote_'.$vote, $resultats[$vote]+1, 'numeric');
			plxPlugin::setParam('nb_votes', 0, 'numeric');
			
			$this->saveSondage();
        }		
			header('Location: '.plxUtils::strCheck($_SERVER['REQUEST_URI']));
			exit;
		}

	}	
	
	public function plxShowSondage() {

		// Lecture du sondage
		$reponses = array();
		$resultats = array();
		$voter = false;
		$ips = array();
		$nb = plxPlugin::getParam('sNbq');
		$fin = false;
		
		$reponses = $this->getReponses($nb);
		$resultats = $this->getResultats($nb);

		$msg = '';
		$choix = count($resultats)-1;
		
		$datenow = date('YmdHi');

		if(plxPlugin::getParam('sDuree') == 1 AND $datenow > plxPlugin::getParam('date_fin')) {
			$fin = TRUE;
		}
		
		if (isset($_COOKIE['PLXSONDAGE'])) $voter = false;
		if (plxPlugin::getParam('sUnvoteip')== 1) {
			if (plxPlugin::getParam('ip_visiteur') != '') {
				$ips = unserialize(plxPlugin::getParam('ip_visiteur')); // load ip array
				if(in_array($_SERVER['REMOTE_ADDR'],$ips)){ // submit vote
					$voter = false;
				}
			}
		}
		
		$total_votes = 0; // calcul du total des votes
		foreach($resultats as $nb_resultat) $total_votes += $nb_resultat;
		if ($total_votes == 0) {// éviter la division par 0
			$msg = '1';
			$total_votes = 1;
		}
		$numero = 0;
		while ($numero <= $choix) {// transformation du nombre de vote en pourcentages
		     
			$pourcentage[] = $resultats[$numero] / $total_votes * 100;
			$numero ++;
		}

		$long_max_bloc = plxPlugin::getParam('sWidth_barre'); // longueur maximale du curseur pour un vote en pixels
		# récupérer la racine du site http//.... et du repertoire plugins
		$baseDirPlugins = plxUtils::getRacine().substr(PLX_PLUGINS,2);
		
		// affichage des barres et du nombre de votes
		$numero = 0;
		echo "\t".'<style type="text/css">'."\n";
		echo "\t".'#sondage .barfull {'."\n";
		echo "\t".'background-image:url('.$baseDirPlugins.'plxSondage/img/'.plxUtils::strCheck(plxPlugin::getParam('sIcone_img')).');'."\n";
		echo "\t".'}'."\n";	
		echo "\t".'#sondage {'."\n";
		echo "\t".'max-width: '.plxUtils::strCheck(plxPlugin::getParam('sWidth_barre')).'px'."\n";
		echo "\t".'}'."\n";
		echo "\t".'</style>'."\n";
		
		echo '<div id="sondage">';
		echo '<div class="titresondage" >'. plxPlugin::getParam('sQuestion') . '</div>';
		if (plxPlugin::getParam('sDuree') == 1) {
			echo '<div class="_date">Sondage ouvert jusqu\'au '. plxDate::formatDate(plxPlugin::getParam('date_fin'), $format='#num_day/#num_month/#num_year(4)').'</div>';
		}
		echo '<form method="post" action="'.plxUtils::strCheck($_SERVER['REQUEST_URI']).'">';
		while ($numero <= $choix) {
			echo '<label class="inline"><input type="radio" name="vote" value="' . $numero . '" />&nbsp;&nbsp;'. $reponses[$numero] .' ('. $resultats[$numero].')</label><div class="barempty"><div class="barfull" style="width:'.substr($pourcentage[$numero],0,4).'%"><div class="percent">'.substr($pourcentage[$numero],0,4).'%</div></div></div>';
			$numero ++;
		}
		echo '<div class="centre">';
		if ($voter) {	
		    if (!$fin) {
				echo '<input type="submit" class="submit" value="'.plxUtils::strCheck(plxPlugin::getLang('L_S_DEJAVOTER')).'" disabled />';
			} else {
				$msg = plxPlugin::getLang('L_S_FINVOTE');
			}
		} else {
			if ($fin) {
				$msg = plxPlugin::getLang('L_S_FINVOTE');
			} else {
				echo '<input type="submit" class="submit" value="'.plxUtils::strCheck(plxPlugin::getLang('L_S_VOTER')).'" />';
			}
		}
		echo '</div>';
		echo '</form>';
		
		if (!$fin) {
		if ($total_votes >= plxPlugin::getParam('sTotal_votes') AND plxPlugin::getParam('sTotal_votes') != 0) {
			$msg = 'Nb de votes atteint';
		} elseif (plxPlugin::getParam('sTotal_votes') != 0) {
			$msg =  'Total votes : '.$total_votes.'/'.plxPlugin::getParam('sTotal_votes');
	
		} else {
			if ($msg != '1') {
				$msg = plxPlugin::getLang('L_S_TOTALVOTES').' : '.$total_votes;
			} else {
				$msg = '';
			}
		}
		} 
		
		echo '<div class="msg">'.$msg.'</div>';
		echo '</div>';
	}
	
	public function saveSondage() {

		# Début du fichier XML
		$xml = "<?xml version='1.0' encoding='".PLX_CHARSET."'?>\n";
		$xml .= "<document>\n";
		foreach($this->aParams as $k=>$v) {
			switch($v['type']) {
				case 'numeric':
					$xml .= "\t<parameter name=\"$k\" type=\"".$v['type']."\">".intval($v['value'])."</parameter>\n";
					break;
				case 'string':
					$xml .= "\t<parameter name=\"$k\" type=\"".$v['type']."\">".plxUtils::cdataCheck(plxUtils::strCheck($v['value']))."</parameter>\n";
					break;
				case 'cdata':
					$xml .= "\t<parameter name=\"$k\" type=\"".$v['type']."\"><![CDATA[".plxUtils::cdataCheck($v['value'])."]]></parameter>\n";
					break;
			}
		}
		$xml .= "</document>";

		# On écrit le fichier
		plxUtils::write($xml,$this->plug['parameters.xml']);
	}	
	
	public function getReponses($nb) {
		for ($i=0; $i<$nb; $i++) {
			$reponses[] = plxPlugin::getParam('sReponse_'.$i);
		}
		return $reponses;
	}
	
	public function getResultats($nb) {
		for ($i=0; $i<$nb; $i++) {
			$resultats[] = plxPlugin::getParam('sNote_'.$i);
		}
		return $resultats;
	}	
}
?>
