<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 * Le dvloppement  t commenc par Gari (plnStatistiques)
 * et a t repris par Jormun (SimpleStat).
 **/
class simplestat {
	
	// Class constants - not modified anywhere. Change value directly here only if you know what you do  
    public $OnlineTime = 900; // nb second max since last page display to be considered "online" default time 900
    public $Fileprefix = 'logv1_';
    public $SPAMDelay = 3; // Nb of second under comment is considered as done by bot. Synchronized with ModerationList if installed
    
    // Class variables - modified in pluxml plugin setting interface
    public $RegexRobot="bot|fetcher|netvibes|rss|yahoo|spider|grub|slurp|openfind|nutch|crawl|search|scooter|fluffy|archiver|google|msn|aol|ask|fast|yandex|picsearch|rambler|accoona|seek|synapse|feed|flipboard";
    public $BlacklistIP = array();
	public $SpamRef;
    
    // Class variables - Filled by constructor
	public $StartTime;	
    public $Date;
    public $Hour;

	public function __construct() {
		
		$this->pathname = PLX_ROOT.PLX_CONFIG_PATH.'plugins/simplestat/'; # emplacement des fichiers statistiques
		$this->FileprefixLength = strlen($this->Fileprefix);
	}	

	public function scan_files($files, $year, $daystat, $hourstat, $navstat, $urlstat, $refstat, $online, $calculate){
		
		$plxMotor = class_exists('plxAdmin') ? plxAdmin::getInstance() : plxMotor::getInstance();
		
		//$plxMotor = plxMotor::getInstance();
		if (isset($plxMotor->plxPlugins->aPlugins["ModerationList"]) && $plxMotor->plxPlugins->aPlugins["ModerationList"]->autoBLTimer > 0) $this->SPAMDelay = $plxMotor->plxPlugins->aPlugins["ModerationList"]->autoBLTimer;

		$racine = trim($plxMotor->racine,'/');
		if (substr($racine,0,5)=='https') $racine = 'http' . substr($racine,5); //to avoid duplicates with http/https, remove the "s"
		$racine_length = strlen($racine);
		foreach($files as $filename){
		if (substr($filename,$this->FileprefixLength,4)!=$year) continue; // ignore log of other year

		$fileday = substr($filename,$this->FileprefixLength,10);
		$filemonth = substr($filename,$this->FileprefixLength+5,2);
    
		if (isset($daystat[$fileday]["ok"]) && $daystat[$fileday]["ok"]) continue; // If day already completely processed, skip it
    
		if (!file_exists($this->pathname . $filename)) continue;
		$handle = fopen($this->pathname . $filename,"r");
		if ($handle===false) continue;

		// stats of the file
		// 1st step : build bot IP list
		$bot=array();
		$file_content=array();
		$spamref = $this->SpamRef;
		while ((list(,$time,$ip,$url,$ua,$ref) = fgetcsv($handle, 0, ';', '"')) !== FALSE) {
			if (in_array($ip,$this->BlacklistIP)) continue; // Skip blacklisted IPs
			if ($ua=="spambot"){ // Flag blacklisted from ModerationList as SPAM and ignore this line (generated by ModerationList)
			$bot[$ip] = 1;
			continue;
        }
		$url = rtrim($url, "/");
		if($url=="robots.txt") $bot[$ip] = 1; // only bots ask for robot.txt file
		if( substr($url,0,12)=="wp-login.php" || strpos($url,"wp-admin")!==false) $bot[$ip] = 1; // only bots ask for wordpress admin on a pluxml blog !
		if ($ua=='') $bot[$ip] = 1; // only bots dont have user agent
		if ($ua == "Mozilla/4.0 (compatible;)") $bot[$ip] = 1; // probably only bots use this too simple user agent
		if (!empty($ref) && substr($ref,0,4)!= 'http') $bot[$ip] = 1; // bad syntax referer is probably from bot
		// detect spam referer as bot
		if (!empty($ref) && !isset($bot[$ip])){
			$ref_short = explode('/',str_replace(array("http://","https://","www."),"",$ref));
			if(!empty($spamref) && strpos($spamref,$ref_short)!==false) $bot[$ip] = 1;
			if(!isset($bot[$ip]) && !empty($this->RegexSpamRef) && preg_match("/".$this->RegexSpamRef."/i",$ref_short)) $bot[$ip] = 1; // Known bots user agent regex
		}
		if(!isset($bot[$ip]) && preg_match("/".$this->RegexRobot."/i",$ua)) $bot[$ip] = 1; // Known bots user agent regex
      
		// Fast Parse of user agent to find browser family
		if(strpos($ua, 'MSIE') !== FALSE)
			$nav = 'Internet explorer';
		elseif(strpos($ua, 'Trident') !== FALSE) //For Supporting IE 11
			$nav = 'Internet explorer';
		elseif(strpos($ua, 'Firefox') !== FALSE)
			$nav = 'Mozilla/Firefox';
		elseif(strpos($ua, 'Chrome') !== FALSE)
			$nav = 'Google Chrome';
		elseif(strpos($ua, 'Opera Mini') !== FALSE)
			$nav = "Opera"; // Opera Mini
		elseif(strpos($ua, 'Opera') !== FALSE)
			$nav = "Opera";
		elseif(strpos($ua, 'Safari') !== FALSE)
			$nav = "Safari";
		elseif( strpos($ua,"Mozilla/5.0")!==false && strpos($ua,"Gecko")!==false )
			$nav = 'Mozilla/Firefox'; //Divers Mozilla
		else
			$nav = 'Autre';
      
		if (!empty($ref)){
			$ref = trim($ref,'/');
			if (substr($ref,0,5)=='https') $ref = 'http' . substr($ref,5); //to avoid duplucates http/https, remove the "s"
			if (substr($ref,0,$racine_length)==$racine) $ref = ''; // keep ref only if external
		}
      
		// Search for SPAMDelay
		if (!isset($bot[$ip]) && $this->SPAMDelay > 0 && strpos($url,"#com")!==false){
			$url_short = rtrim(substr($url,0,strpos($url,"#com")), "/");
			$time_last = mktime ( substr($time,0,2), substr($time,3,2), substr($time,6,2), 1, 1, 1970);
			for($i=count($file_content)-1;$i>=0;$i--){
				if ($file_content[$i][1]!=$ip || $file_content[$i][2]!=$url_short) continue;
				$time_first = mktime ( substr($file_content[$i][0],0,2), substr($file_content[$i][0],3,2), substr($file_content[$i][0],6,2), 1, 1, 1970);
				if ($time_last - $time_first <= $this->SPAMDelay){
				$bot[$ip] = 1; // SPAMDelay is not respected => SPAM Bot
//           	 echo "SPAM $fileday : $ip \n"; //for debug purpose
        }
        }
        if ($i==-1 && substr($time,0,2)>0) $bot[$ip] = 1; // only bot submit form without going on the page ! (not sure before 1am, opening of the page could be done yesterday)
		}
		$file_content[]=array($time,$ip,$url,$nav,$ref); // Save info in memory for a further process
		}
		fclose($handle);
    
		// Reset daily stats before begin of process
		$daystat[$fileday] = array("vue"=>0,"vis"=>0,"bvue"=>0, //number of Views , visitors, bot views 
                               "visitor"=>array(), // IP list of visitors
                               "bvis" => count($bot), // Bot visitors
                               "ok" => !($this->Date == $fileday)); // To flag a completely processed day
    
		if ($calculate && !isset($hourstat[$filemonth])){
			$hourstat[$filemonth]=array(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0); // 24 hours
		}
  
		foreach($file_content as $line){
			list($time,$ip,$url,$nav,$ref) = $line;
			//online stat
			if ($fileday>$online["date"] || ($fileday==$online["date"] && $time >= $online["time"]))
				$online["where"][$ip] = array("bot"=>isset($bot[$ip]),
                                      "url"=>$url,
                                      "since"=>$online["timestamp"] - mktime( substr($time,0,2), substr($time,3,2), substr($time,6,2), substr($fileday,5,2), substr($fileday,8,2), substr($fileday,0,4)));        
      
		if (isset($bot[$ip])){
			$daystat[$fileday]["bvue"]++;
			continue;
		}
		$daystat[$fileday]["vue"]++;
		$daystat[$fileday]["visitor"][$ip]=1;
		if ($calculate && $daystat[$fileday]["ok"]){ // urlstat, hourstat, refstat et navstat seulement sur jours passs
			isset($urlstat[$url][$filemonth])?$urlstat[$url][$filemonth]++:$urlstat[$url][$filemonth]=1;
			if (!empty($ref)) isset($refstat[$ref][$filemonth])?$refstat[$ref][$filemonth]++:$refstat[$ref][$filemonth]=1;
			isset($navstat[$filemonth][$nav])?$navstat[$filemonth][$nav]++:$navstat[$filemonth][$nav]=1;
			$hourstat[$filemonth][(int) substr($time,0,2)]++;
		}
		}
		$daystat[$fileday]["vis"] = count($daystat[$fileday]["visitor"]); // number of visitors
		unset($daystat[$fileday]["visitor"]); // free memory
	} //foreach($files as $filename) (2nd loop)
    
	// Count of online humans/bots
	foreach ($online["where"] as $line)
		if ($line["bot"]){
		$online["bot"]++;
		}else{
		$online["human"]++;
		}
	ksort($daystat);
	return(array($daystat, $hourstat, $navstat, $urlstat, $refstat, $online));
	} //function scan_file
	
	public function Online() {
		$online = array("human"=>0,"bot"=>0,"where"=>array());
		list($online["date"],$online["time"]) = explode(" ",date('Y-m-d H:i:s',time()-$this->OnlineTime));
		#$online["timestamp"]=mktime( substr($this->Hour,0,2), substr($this->Hour,3,2), substr($this->Hour,6,2), substr($this->Date,5,2), substr($this->Date,8,2), substr($this->Date,0,4));
		$online["timestamp"]=$this->StartTime;
		$stats = array();
		if ($online["date"]!=$this->Date){
			$stats[] = $this->Fileprefix.$online["date"].'.csv';
			if (substr($online["date"],0,4)!=substr($this->Date,0,4)){ // different year
				list( , , , , , $online) = $this->scan_files($stats,substr($online["date"],0,4),array(),array(),array(),array(),array(),$online,false);
				//$files = array();
			}
		} 
	return $online;
	}
	
	public function Calculate($files){
		// Get list of years to process
		foreach($files as $filename){
			if (substr($filename,0,$this->FileprefixLength)!=$this->Fileprefix) continue;
			$yearlist[substr($filename,$this->FileprefixLength,4)] = 1;
		} //foreach($files as $filename) (1st loop)
	return $yearlist;	
	}
		
	public function Calculate_All($yearlist) {
		// Check each year to process. If stat for 31/12 is completely processed, assume that there is no need to reprocess
		// Except in case of forced calculation
		foreach($yearlist as $year=>$v){
			if ($year == substr($this->Date,0,4)) continue; // Always keep current year
			$file_content = file_exists($this->pathname . $year . "-daystat.json")?file_get_contents($this->pathname . $year . "-daystat.json"):false;
			if (!$file_content) continue;
			$daystat = json_decode($file_content,true);
			if (!isset($daystat[$year."-12-31"]) || !$daystat[$year."-12-31"]["ok"]) continue;
			// completely processed year => delete it from year list to process
			unset($yearlist[$year]);
		} //foreach($yearlist as $year=>$v) (1st loop)
	}

	/**
	 * Verification des version des plugins
	 *
	 * @param	plugin				le nom du plugin
	 * @return	array()
	 * @author	DPFPIC
	 **/
	public function UpdatePlugin($plugin) {
	    $array = array();
		$url = 'http://dpfpic.com/plugins.rep';
		$filename = PLX_PLUGINS.$plugin.'/infos.xml';
		
		# Mise en place du parseur XML
		$data = implode('',file($filename));
		$parser = xml_parser_create('UTF-8');
		xml_parser_set_option($parser,XML_OPTION_CASE_FOLDING,0);
		xml_parser_set_option($parser,XML_OPTION_SKIP_WHITE,0);
		xml_parse_into_struct($parser,$data,$strings,$iTags);
		xml_parser_free($parser);
		# Rcupration des donnes xml
		$array['actualversion'] = plxUtils::getValue($strings[$iTags['version'][0]]['value']);
		$array['actualdate'] = plxUtils::getValue($strings[$iTags['date'][0]]['value']);


		if (ini_get('allow_url_fopen')) {
			$handleplugin = @file($url);
		}
		elseif ($curl = @curl_init()){
			$timeout = 5; // set to zero for no timeout
			curl_setopt ($curl, CURLOPT_URL, $url);
			curl_setopt ($curl, CURLOPT_CONNECTTIMEOUT, $timeout);
			curl_setopt ($curl, CURLOPT_RETURNTRANSFER, 1);
			$version_content = curl_exec($curl);
			curl_close($curl);
			if ($version_content != false) {
				$handleplugin = explode("\n", $version_content);
			}
		}	
		if ($handleplugin) {
			$nb = sizeof($handleplugin);
			for($i=0;$i<$nb;$i++) {
				$seach = strstr($handleplugin[$i], '||', true);
				if ($seach == $plugin) {
				    $value = explode('||', $handleplugin[$i]);
					$array['newplugin'] = $value[0];
					$array['newversion'] = $value[1];
					$array['newdate'] = $value[2];
					$array['newurl'] = $value[3];
					$array['active'] = $value[4];
				}
			}
		} else {
			$array ['status'] = 0;
			return $array;
		}
		
		$adate = explode("/", $array['actualdate']); 
		$ndate = explode("/", $array['newdate']);
		$actualdate = $adate[2].$adate[1].$adate[0];
		$newdate = $ndate[2].$ndate[1].$ndate[0];
		
		if (isset($array['actualversion']) AND ($array['actualversion'] == $array['newversion']  AND  $actualdate == $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 1;
			return $array;
		} elseif (isset($array['actualversion']) AND ($array['actualversion'] != $array['newversion'] OR  $actualdate != $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 2;
			return $array;
		} elseif (isset($array['active']) AND $array['active'] == 0) {
			$array ['status'] = 3;
			return $array;
		} else {
		    $array ['status'] = 0;
			return $array;
		}
	}		
}
?>