// Par défaut mettre visites par jour en double :
// <option value="1.5">Visites par jour</option>

var dashToLoad = [];
var today = new Date();
var dashLoad ={};

var xmlhttp;
if (window.XMLHttpRequest) {
  xmlhttp = new XMLHttpRequest();
} else { // code for IE6, IE5
  xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
}
xmlhttp.onreadystatechange = function() {
  if (xmlhttp.readyState == 4 ) {
    if(xmlhttp.status == 200){
      objet = eval('(' + xmlhttp.responseText + ')');
      load_data(objet);
    }else{ //if(xmlhttp.status == 400) {
      alert(langue[0]+":"+xmlhttp.status);
    }
  }
}  //function xmlhttp.onreadystatechange

function getWeekNumber(d) {
  d = new Date(parseInt(d.substr(0,4)),parseInt(d.substr(5,2)-1),parseInt(d.substr(8,2)),0,0,0,0);
  d.setDate(d.getDate() + 3 - (d.getDay() + 6) % 7);
  var week1 = new Date(d.getFullYear(), 0, 4);
  return [d.getFullYear(), 1 + Math.round(((d.getTime() - week1.getTime()) / 86400000 - 3 + (week1.getDay() + 6) % 7) / 7)];
} // function getWeekNumber

function del_dash(obj){
  obj.parentNode.removeChild(obj);
  saveConfig();
} //function del_dash

function toggle_dash(obj){
  obj.className = (obj.className=='dash')?'dash double' : 'dash';
  index = obj.id.substr(7);
  if (dashLoad["dash"+index] && dashLoad["dash"+index].chart) dashLoad["dash"+index].chart.reflow();
  saveConfig()
} //function toggle_dash

function toggle_top(){
  dashLoad.dash4.top = (dashLoad.dash4.top)? false : true;
  if (dashLoad.dash4.top && dashLoad.dash4.tsort.prevCol!=1) //sort on count if not already done 
    dashLoad.dash4.tsort.sort({target:dashLoad.dash4.tsort.ths[1]});//tri sur vues
//display/hide unwanted nodes
  if (dashLoad.dash4.tsort.ths[1].className=='ascend'){
    for(i=toggleTop;i<dashLoad.dash4.tsort.trs.length;i++) dashLoad.dash4.tsort.trs[i].style.display= (dashLoad.dash4.top)?"none":"";
  }else{
    for(i=dashLoad.dash4.tsort.trs.length-toggleTop-1;i>=0;i--) dashLoad.dash4.tsort.trs[i].style.display= (dashLoad.dash4.top)?"none":"";
  }
} //toggle_top

function add_dash(index){
if(index=='')return;
double=false;
if(typeof(index) == 'string' && index.indexOf('.')>-1){
    index=index.substr(0,index.indexOf('.'));
    double=true;
}

document.getElementById('dashselector').selectedIndex=0;

divid = "dashdiv"+index;
if (document.getElementById(divid)) return; // le widget est dÃ©ja affichÃ©

var node = document.createElement("DIV");
node.id = divid;
node.className = (double)?'dash double':'dash';
var content = [];
content.push('<div class="dash-head">');
var selector = document.getElementById('dashselector');
for (i=0;i<selector.length;i++)
  if (parseInt(selector[i].value) == index)
    content.push(selector[i].text);
content.push('</div><div id="');
content.push(divid);
content.push('-content"></div>');
content.push('<div class="dash-foot">');
if (index!=5){
if(index==1 || index==7 || index==8){
content.push('<img title="'+langue[1]+'" alt="<<" src="');
content.push(pluginDir);
content.push('img/btn_prev.png" onclick="dashdataprevnext('+index+',-1)">');
}else{
content.push('<img title="'+langue[3]+'" alt="<<" src="');
content.push(pluginDir);
content.push('img/btn_prev.png" onclick="dashdataprevnext('+index+',-1)">');
}
content.push('<span id="dash'+index+'-period"></span>');
if(index==1 || index==7 || index==8){
content.push('<img title="'+langue[2]+'" alt=">>" src="');
content.push(pluginDir);
content.push('img/btn_next.png" onclick="dashdataprevnext('+index+',1)">');
}else{
content.push('<img title="'+langue[4]+'" alt=">>" src="');
content.push(pluginDir);
content.push('img/btn_next.png" onclick="dashdataprevnext('+index+',1)">');
}
}
content.push('<img title="'+langue[5]+'" alt="'+langue[5]+'" src="');
content.push(pluginDir);
content.push('img/btn_refresh.png" onclick="dashdataprevnext('+index+',0)">');
if(index==4) {
content.push('<img title="'+langue[6]+'" alt="TOP'+toggleTop+'" src="');
content.push(pluginDir);
content.push('img/rosette.png" onclick="toggle_top();">');
}
content.push('<img title="'+langue[7]+'" alt="oO" src="');
content.push(pluginDir);
content.push('img/fullscreen.png" onclick="toggle_dash(this.parentNode.parentNode)">');
content.push('<img class="dashdel" title="'+langue[8]+'" alt="X" src="');
content.push(pluginDir);
content.push('img/ko.png" onclick="del_dash(this.parentNode.parentNode)">');
content.push('</div>');
node.innerHTML= content.join('');
document.getElementById(pluginID).appendChild(node);

if (index==1 || index==7 || index==8){
  init_visite(index);
}else if (index==2){
  init_hour();
}else if (index==3){
  init_nav();
}else if (index==4){
  init_url();
}else if (index==5){
  init_online();
}else if (index==6){
  init_ref();
}

// si pas en train de charger la page, on sauvegarde la config
if (dashToLoad.length==0)
  saveConfig();
} //function add_dash

function avcalc(obj){
  var sum1 = 0;
  var sum2 = 0;
  var cnt = 0;
  for (i=0;i<obj.target.chart.series[0].data.length;i++)
    if (!obj.min || (obj.target.chart.series[0].data[i].x >= obj.min && obj.target.chart.series[0].data[i].x <= obj.max )){
      sum1 += obj.target.chart.series[0].data[i].y;
      sum2 += obj.target.chart.series[1].data[i].y;
      cnt++;
    }
  obj.target.chart.yAxis[0].plotLinesAndBands[0].options.value = (cnt==0)?0:sum1/cnt;
  obj.target.chart.yAxis[0].plotLinesAndBands[1].options.value = (cnt==0)?0:sum2/cnt;
}

function init_visite(dash){
  if (!dashLoad["dash"+dash]) dashLoad["dash"+dash] = {};
  dashLoad["dash"+dash].chart = new Highcharts.Chart({
    chart: {
      renderTo: 'dashdiv'+dash+'-content',
      zoomType: 'x'
    },
    title: { text: '' },
    subtitle: { text: document.ontouchstart === undefined ? langue[9] : langue[10] },
    xAxis: { 
      type: ((dash==1)?'datetime':'category'),
      events: { setExtremes: avcalc }
    },
    yAxis: { 
      title: { text: '' },
      plotLines: [{
        color: '#0044AA',
        width: 2,
        dashStyle:"dash",
        zIndex:5,
        label:{
          text:langue[35]+" "+langue[12],
          style:{color:"#0044AA"}
        }
      },{
        color: '#FF0000',
        width: 2,
        dashStyle:"dash",
        zIndex:5,
        label:{
          text:langue[35]+" "+langue[14],
          style:{color:"#F00"}
        }
      }]
    },
    legend: { enabled: true },
    plotOptions: { series: { fillOpacity: 0.5 } },
    tooltip:{ 
      shared:true,
      xDateFormat: '%A %d %B %Y'
    },
    colors:['#7cb5ec', '#f7a35c', '#434348','#8085e9','#f15c80','#90ed7d', '#e4d354', '#2b908f', '#f45b5b', '#91e8e1'],
    series: [{
      type: 'area',
      name: langue[11],
      zIndex:2,
      tooltip:{pointFormat:'<span style="color:{point.color}">\u25CF</span> '+langue[12]+' : <b>{point.y}</b><br/>'},
      data: []
    },{
      type: 'area',
      name: langue[13],
      zIndex:3,
      tooltip:{pointFormat:'<span style="color:{point.color}">\u25CF</span> '+langue[14]+' : <b>{point.y}</b><br/>'},
      data: []
    },{
      type: 'area',
      name: langue[15],
      zIndex:1,
      tooltip:{pointFormat:'<span style="color:{point.color}">\u25CF</span> '+langue[16]+' : <b>{point.y}</b><br/>'},
      visible: false,
      data: []
    },{
      type: 'area',
      name: langue[17],
      zIndex:4,
      tooltip:{pointFormat:'<span style="color:{point.color}">\u25CF</span> '+langue[18]+' : <b>{point.y}</b><br/>'},
      visible: false,
      data: []
    }]
  });
  get_data(dash,today.getFullYear());
} //function init_visite

function init_hour(){
  if (!dashLoad.dash2) dashLoad.dash2 = {};
  dashLoad.dash2.chart = new Highcharts.Chart({
    chart: { renderTo: 'dashdiv2-content', },
    title: { text: '' },
    subtitle: { text: langue[19] },
  xAxis: {
    type: 'datetime',
    units: [['hour',[1,2,3]]],
    dateTimeLabelFormats:{hour:'%H:%M',day:'%H:%M'}
  },
  tooltip:{dateTimeLabelFormats:{hour:langue[20]+" : %H:%M"}},
    yAxis: {
      title: { text: '' },
      plotLines: [{
        color: '#FF0000',
        width: 2,
        dashStyle:"dash",
        zIndex:4,
        label:{
          text:langue[35]+" "+langue[21],
          style:{color:"#F00"}
        }
      }]  
    },
    legend: { enabled: false },
    colors:['#7cb5ec', '#f7a35c', '#434348','#8085e9','#f15c80','#90ed7d', '#e4d354', '#2b908f', '#f45b5b', '#91e8e1'],
    series: [{
      type: 'area',
      name: langue[21],
      pointInterval: 3600 * 1000, // one hour
      tooltip:{pointFormat:'{series.name}: <b>{point.y}</b><br/>'},
      zIndex:1,
      data: []
    }]
  });
  period = today.getFullYear()+''+today.getMonth();
  get_data(2,period);
} //function init_hour

function init_nav(){
  if (!dashLoad.dash3) dashLoad.dash3 = {};
  dashLoad.dash3.chart = new Highcharts.Chart({
    chart: {
      renderTo: 'dashdiv3-content',
      plotBackgroundColor: null,
      plotBorderWidth: null,
      plotShadow: false,
      type: 'pie'
    },
    title: { text: '' },
    subtitle: { text: langue[22] },
    tooltip: { pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>' },
    plotOptions: {
      pie: {
        allowPointSelect: true,
        cursor: 'pointer',
        dataLabels: { enabled: false },
        showInLegend: true
      }
    },
    series: [{
      name: langue[23],
      colorByPoint: true,
      data: []
    }]
  });
  period = today.getFullYear()+''+today.getMonth();
  get_data(3,period);
} //function init_nav

function init_url(){
if (!dashLoad.dash4) dashLoad.dash4 = {};
content = [];
content.push('<table cellspacing=0 cellpadding=0 id="dash4-table" class="dashtable">');
content.push('<thead><tr><th data-tsorter="link">');
content.push(langue[24]);
content.push('</th><th data-tsorter="numeric">');
content.push(langue[25]);
content.push('</th></tr></thead>');
content.push('<tbody>');
content.push('</tbody></table>');
document.getElementById("dashdiv4-content").innerHTML=content.join('');
dashLoad.dash4.tsort = tsorter.create('dash4-table');
period = today.getFullYear()+''+today.getMonth();
get_data(4,period);
} //function init_url

function init_online(){
if (!dashLoad.dash5) dashLoad.dash5 = {};
content = [];
content.push('<table cellspacing=0 cellpadding=0 id="dash5-table" class="dashtable">');
content.push('<thead><tr><th data-tsorter="img">');
content.push('&nbsp;');
content.push('</th><th>');
content.push(langue[27]);
content.push('</th><th data-tsorter="link">');
content.push(langue[28]);
content.push('</th><th data-tsorter="age">');
content.push(langue[29]);
content.push('</th></tr></thead>');
content.push('<tbody>');
content.push('</tbody></table>');
document.getElementById("dashdiv5-content").innerHTML=content.join('');
dashLoad.dash5.tsort = tsorter.create('dash5-table',0,{ 'img': function(row){ return this.getCell(row).innerHTML; }, 'age': function(row){ content=this.getCell(row).innerHTML; return (content.indexOf('m')==-1)?parseInt(content):60*parseInt(content); } });
get_data(5,0);
} //function init_online

function init_ref(){
if (!dashLoad.dash6) dashLoad.dash6 = {};
content = [];
content.push('<table cellspacing=0 cellpadding=0 id="dash6-table" class="dashtable">');
content.push('<thead><tr><th data-tsorter="link">');
content.push(langue[24]);
content.push('</th><th data-tsorter="numeric">');
content.push(langue[25]);
content.push('</th></tr></thead>');
content.push('<tbody>');
content.push('</tbody></table>');
document.getElementById("dashdiv6-content").innerHTML=content.join('');
dashLoad.dash6.tsort = tsorter.create('dash6-table');
period = today.getFullYear()+''+today.getMonth();
get_data(6,period);
} //function init_ref

function load_data(objet){
if (objet.type==1){
vues = [];
vis = [];
bots = [];
moy = [];
for(key in objet.data){
datum=Date.UTC(key.substr(0,4),key.substr(5,2)-1,key.substr(8,2));
vues.push([datum,objet.data[key].vue]);
vis.push([datum,objet.data[key].vis]);
bots.push([datum,objet.data[key].bvue]);
moy.push([datum,Math.round(100*parseInt(objet.data[key].vue)/parseInt(objet.data[key].vis))/100]);
}
dashLoad.dash1.chart.series[0].setData(vues);
dashLoad.dash1.chart.series[1].setData(vis);
avcalc({target:{chart:dashLoad.dash1.chart}});
dashLoad.dash1.chart.series[2].setData(bots);
dashLoad.dash1.chart.series[3].setData(moy);
document.getElementById("dash1-period").innerHTML=objet["period"];
}else if (objet.type==2){
vues = [];
period = objet.period + '';
month = (parseInt(period.substr(4)) + 1);
if (month<10) month='0'+month;
month = month+'';
cnt=0;
sum=0;
if (objet.data[month])
for(hour in objet.data[month]){
vues.push(objet.data[month][hour]);
cnt++;
sum+=objet.data[month][hour];
}
dashLoad.dash2.chart.yAxis[0].plotLinesAndBands[0].options.value=(cnt==0)?0:sum/cnt;
dashLoad.dash2.chart.series[0].setData(vues);
dashLoad.dash2.data = objet;

document.getElementById("dash2-period").innerHTML = dashLoad.dash2.chart.options.lang.shortMonths[parseInt(period.substr(4))] + ' ' + period.substr(0,4);
}else if (objet.type==3){
vues = [];
period = objet.period + '';
month = (parseInt(period.substr(4)) + 1);
if (month<10) month='0'+month;
month = month+'';
if (objet.data[month])
for(nav in objet.data[month]){
vues.push([nav,objet.data[month][nav]]);
}
dashLoad.dash3.chart.series[0].setData(vues);
dashLoad.dash3.data = objet;
document.getElementById("dash3-period").innerHTML = dashLoad.dash3.chart.options.lang.shortMonths[parseInt(period.substr(4))] + ' ' + period.substr(0,4);
}else if (objet.type==4){
period = objet.period + '';
month = (parseInt(period.substr(4)) + 1);
if (month<10) month='0'+month;
month = month+'';
content = [];
for(url in objet.data) if (objet.data[url][month]){
content.push('<tr><td><a href="');
content.push(pluginDir);
content.push('../../');
if (url!='') content.push(url);
content.push('">');
if (url==''){
content.push(langue[30]);
}else{
content.push(url);
}
content.push('</a></td><td>');
content.push(objet.data[url][month]);
content.push('</td></tr>');
}
if (content.length==0) content.push('<tr><td colspan=2 class="nodata">'+langue[31]+'</td></tr>');

update_table_data(4,content,1);

dashLoad.dash4.data= objet;
if (dashLoad.dash4.top){//hide unwanted nodes
  for(i=30;i<dashLoad.dash4.tsort.trs.length;i++) dashLoad.dash4.tsort.trs[i].style.display="none";
}
document.getElementById("dash4-period").innerHTML = Highcharts.getOptions().lang.shortMonths[parseInt(period.substr(4))] + ' ' + period.substr(0,4);
}else if (objet.type==5){
content = [];
for(ip in objet.data.where){
content.push('<tr><td>');
content.push('<img src="');
content.push(pluginDir);
content.push('img/');
content.push((objet.data.where[ip].bot)?'bot':'human');
content.push('.png" title="');
content.push((objet.data.where[ip].bot)?langue[32]:langue[33]);
content.push('" alt="');
content.push((objet.data.where[ip].bot)?langue[32]:langue[33]);
content.push('"> ');
content.push('</td><td>');
content.push(ip);
content.push('</td><td><a href="');
content.push(pluginDir);
content.push('../../');
if (objet.data.where[ip].url!='') content.push(objet.data.where[ip].url);
content.push('">');
if (objet.data.where[ip].url==''){
content.push(langue[30]);
}else{
content.push(objet.data.where[ip].url);
}
content.push('</a></td><td>');
if (objet.data.where[ip].since>59){
content.push(Math.round(objet.data.where[ip].since/60));
content.push('&nbsp;m');
}else{
content.push(objet.data.where[ip].since);
content.push('&nbsp;s');
}
content.push('</td></tr>');
}
if (content.length==0) content.push('<tr><td colspan=4 class="nodata">'+langue[34]+'</td></tr>');
update_table_data(5,content,3);
}else if (objet.type==6){
period = objet.period + '';
month = (parseInt(period.substr(4)) + 1);
if (month<10) month='0'+month;
month = month+'';
content = [];
for(url in objet.data) if (objet.data[url][month]){
content.push('<tr><td><a href="');
content.push(url);
content.push('">');
content.push(url);
content.push('</a></td><td>');
content.push(objet.data[url][month]);
content.push('</td></tr>');
}
if (content.length==0) content.push('<tr><td colspan=2 class="nodata">'+langue[31]+'</td></tr>');

update_table_data(6,content,1);

dashLoad.dash6.data= objet;
document.getElementById("dash6-period").innerHTML = Highcharts.getOptions().lang.shortMonths[parseInt(period.substr(4))] + ' ' + period.substr(0,4);
}else if (objet.type==7){
vues = [];
vis = [];
bots = [];
moy = [];
week = [];
dataweek = {};
for(key in objet.data){
  weeknum = getWeekNumber(key);
  weeknum = weeknum[0] + '-' + weeknum[1];
  if (!dataweek[weeknum]) dataweek[weeknum] = {vue:0,vis:0,bots:0};
  dataweek[weeknum].vue += objet.data[key].vue;
  dataweek[weeknum].vis += objet.data[key].vis;
  dataweek[weeknum].bots += objet.data[key].bvue; 
}

for(key in dataweek){
week.push(key);
vues.push(dataweek[key].vue);
vis.push(dataweek[key].vis);
bots.push(dataweek[key].bots);
moy.push(Math.round(100*parseInt(dataweek[key].vue)/parseInt(dataweek[key].vis))/100);
}
dashLoad.dash7.chart.xAxis[0].categories = week;
dashLoad.dash7.chart.series[0].setData(vues);
dashLoad.dash7.chart.series[1].setData(vis);
avcalc({target:{chart:dashLoad.dash7.chart}});
dashLoad.dash7.chart.series[2].setData(bots);
dashLoad.dash7.chart.series[3].setData(moy);
document.getElementById("dash7-period").innerHTML=objet["period"];
}else if (objet.type==8){
vues = [];
vis = [];
bots = [];
moy = [];
month = [];
datamonth = {};
for(key in objet.data){
  monthnum = Highcharts.getOptions().lang.months[parseInt(key.substr(5,2))-1];
  if (!datamonth[monthnum]) datamonth[monthnum] = {vue:0,vis:0,bots:0};
  datamonth[monthnum].vue += objet.data[key].vue;
  datamonth[monthnum].vis += objet.data[key].vis;
  datamonth[monthnum].bots += objet.data[key].bvue; 
}

for(key in datamonth){
month.push(key);
vues.push(datamonth[key].vue);
vis.push(datamonth[key].vis);
bots.push(datamonth[key].bots);
moy.push(Math.round(100*parseInt(datamonth[key].vue)/parseInt(datamonth[key].vis))/100);
}
dashLoad.dash8.chart.xAxis[0].categories = month;
dashLoad.dash8.chart.series[0].setData(vues);
dashLoad.dash8.chart.series[1].setData(vis);
avcalc({target:{chart:dashLoad.dash8.chart}});
dashLoad.dash8.chart.series[2].setData(bots);
dashLoad.dash8.chart.series[3].setData(moy);
document.getElementById("dash8-period").innerHTML=objet["period"];
}
dashToLoad.shift();
if (dashToLoad.length>0)
  add_dash(dashToLoad[0]);
} //function load_data

function update_table_data(dash,content,sortcol){
var tbody = document.getElementById("dash"+dash+"-table").getElementsByTagName("tbody")[0];
try {
 tbody.innerHTML=content.join('');
} catch(e) {
 var temp = document.createElement('div');
 temp.innerHTML = '<table><tbody>' + content.join('') + '</tbody></table>';
 tbody.parentNode.replaceChild(temp.firstChild.firstChild, tbody);
 dashLoad["dash"+dash].tsort.tbody = dashLoad["dash"+dash].tsort.table.tBodies[0]; //remplacement de l'ancien tbody par le nouveau
 dashLoad["dash"+dash].tsort.trs = dashLoad["dash"+dash].tsort.tbody.rows; //remplacement des anciennes TR par les nouvelles
}
if (dashLoad["dash"+dash].tsort.prevCol==sortcol) dashLoad["dash"+dash].tsort.prevCol=-1;//reset du tri
dashLoad["dash"+dash].tsort.sort({target:dashLoad["dash"+dash].tsort.ths[sortcol]});//tri décroissant
if (dash==5)dashLoad["dash"+dash].tsort.sort({target:dashLoad["dash"+dash].tsort.ths[sortcol]});//tri sur age croissant
} // function update_table_data

function get_data(dash,period){
  xmlhttp.open("POST", window.location.href, true);
  xmlhttp.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
  xmlhttp.send('getdata='+dash+'&period='+period);
  return;
} //function get_data

function saveConfig() {
  var name = 'SimpleStatAdmin=';
	var values = [];
	var divs = document.getElementsByClassName("dash");
	for(i=0;i<divs.length;i++){
    value = divs[i].id.substr(7,1);
    if (divs[i].className.indexOf('double')>-1) value += '.2';
    values.push(value);
  }
  var date = new Date();
  date.setTime(date.getTime()+(365*24*60*60*1000)); // 1 year
  document.cookie = name+values.join(',')+"; expires="+date.toGMTString()+"; path=/";
} //function saveConfig

function dashdataprevnext(dash,sens){
if (dash==1 || dash==7 || dash==8){
  get_data(dash, parseInt(document.getElementById("dash"+dash+"-period").innerHTML)+sens);
}else if (dash==5){
  get_data(dash, 0);
}else{ //dash2,3,4
  period_i = dashLoad["dash"+dash].data.period;
  period = "" + period_i
  if (sens==-1 && period.substr(4,2) =='0'){
    get_data(dash,(parseInt(period.substr(0,4))-1) + '11');
  }else if (sens==1 && period.substr(4,2) =='11'){
    get_data(dash,(parseInt(period.substr(0,4))+1) + '0');
  }else if (sens==0){
    get_data(dash,period_i);
  }else{
    period = period.substr(0,4) + (parseInt(period.substr(4,2))+sens);
    dashLoad["dash"+dash].data.period = parseInt(period);
    load_data(dashLoad["dash"+dash].data);
  }
}
} //function dashdataprevnext

function loadConfig() {
  var value = '';
  var name = 'SimpleStatAdmin=';
  var ca = document.cookie.split(';');
  for(var i=0;i < ca.length;i++) {
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(name) == 0){
      value = c.substring(name.length,c.length);
      break; //break for
    }
	}
	var ca = value.split(',');
	for(var i=0;i < ca.length;i++)
	  if (ca[i]!='')
      dashToLoad.push(ca[i]);
  if (dashToLoad.length>0)
    add_dash(dashToLoad[0]);
}

// Display last choosen dash
loadConfig();


