<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/
class sharesocialbuttons {

	public function __construct() {
		
	}

   /**
     * Retourne le contenu de l'url de la première image de l'article
     * @param plxShow $plxShow
     * @return string
     */
    public function imageUrl($content)
    {
        $image = '';
        if (@preg_match('~<img[^>]*?src="(.*?)"[^>]+>~', $content, $match)) {
            $image = trim($match[1]);
            if (strpos($image, 'http') !== 0) {
                $image = plxUtils::getRacine() . trim($match[1]);
				$image = str_replace('https', 'http', $image);
            }
        }
		
        return $image;
    }	
	
	public function ok() 
	{
		global $plxMotor;

		return ($plxMotor->mode == 'article') or (($plxMotor->mode == 'static') and (($plxMotor->aStats[ $plxMotor->cible ]['readable'] > 0)));
	}
	
	public function getDescription()
	{
		global $plxMotor;

		$result = $plxMotor->aConf['description'];
		switch ($plxMotor->mode) {
			case 'article' :
				$description = $plxMotor->plxRecord_arts->f('chapo').$plxMotor->plxRecord_arts->f('content');
				if (! empty($description)) {
					$result = $description;
				} else {
					$meta_description = $plxMotor->plxRecord_arts->f('meta_description');
					if(!empty($meta_description)) {
						$result = $meta_description;
					}
				}
				break;
			case 'static' :
				$description = $plxMotor->aStats[ $plxMotor->cible ]['meta_description'];
				if (! empty($description))
					$result = $description;
				break;
		}
		return strip_tags($result);
	}

	public function getTitlePage()
	{
		global $plxMotor;

		switch ($plxMotor->mode) {
			case 'article' :
				$result = $plxMotor->plxRecord_arts->f('title');
				break;
			case 'static' :
				$result = plxUtils::strCheck($plxMotor->aStats[ $plxMotor->cible ]['name']);
				break;
			default :
				$result = '';
		}
		return $result;
	}
	
	public function getUrl()
	{
		global $plxMotor;
		
		switch ($plxMotor->mode) {
			case 'article' :
				$id = intval($plxMotor->plxRecord_arts->f('numero'));
				$url = $plxMotor->plxRecord_arts->f('url');
				$result = $plxMotor->urlRewrite('?article'.$id.'/'.$url);
				break;
			case 'static' :
				$result = plxUtils::strCheck($plxMotor->aStats[ $plxMotor->cible ]['url']);
				break;
			default :
				$result = '';
		}
		return $result;

	}
	
	public function getURI()
	{
		$adresse = $_SERVER['PHP_SELF'];
		$i = 0;
		foreach($_GET as $cle => $valeur){
			$adresse .= ($i == 0 ? '?' : '&').$cle.($valeur ? '='.$valeur : '');
			$i++;
		}
		return plxUtils::getRacine().$adresse;
	}
	
	public function getMedia()
	{
		global $plxMotor;

		if (!empty($this->media))
			$content= $this->media;
		else {
			// look for a picture in the content of article or the static page
			$pattern = '@<img\s.*src="([^"]*)".*/?>@';
			$content = '';
			switch ($plxMotor->mode) {
				case 'article' :
					# on recherche une image d'accroche
					$content = $plxMotor->plxRecord_arts->f('thumbnail');
					if(empty($content)) {
						# pas d'image d'accroche. On recherche une image dans le contenu de l'article
						$content = $plxMotor->plxRecord_arts->f('chapo').$plxMotor->plxRecord_arts->f('content');
						if(preg_match($pattern, $content, $matches)) {
							$content = str_replace('tb.', '', $matches[1]);
						} else {
							$content = 'none';
						}
					} else {
						$content = str_replace('tb.', '', $content);
					}
					break;
				case 'static' :
					$idStat = $plxMotor->cible;
					$filename = implode('', array(
						PLX_ROOT,
						$plxMotor->aConf['racine_statiques'],
						$idStat.'.'.$plxMotor->aStats[$idStat]['url'].'.php'
					));
					if(is_readable($filename)) {
						$buf = file_get_contents($filename);
						if(preg_match($pattern, $buf, $matches)) {
							$content = str_replace('tb.', '', $matches[1]);
						} else {
							$content = 'none';
						}
					} else {
						$content = 'none';
					}
					break;
			}
		}

		/*if (! empty($content)) {
			if(preg_match('@^\w+://@', $content, $matches) == false) {
				//$result = $plxMotor->racine;
				$result = $content;
			} else {
				$result = $content;
			}
		} else
			$result = '';*/
		
		$result = $content;

		return $result;
	}	
	
	/**
	 * Verification des version des plugins
	 *
	 * @param	plugin				le nom du plugin
	 * @return	array()
	 * @author	DPFPIC
	 **/
	public function UpdatePlugin($plugin) {
	    $array = array();
		$url = 'http://dpfpic.com/plugins.rep';
		$filename = PLX_PLUGINS.$plugin.'/infos.xml';
		
		# Mise en place du parseur XML
		$data = implode('',file($filename));
		$parser = xml_parser_create('UTF-8');
		xml_parser_set_option($parser,XML_OPTION_CASE_FOLDING,0);
		xml_parser_set_option($parser,XML_OPTION_SKIP_WHITE,0);
		xml_parse_into_struct($parser,$data,$strings,$iTags);
		xml_parser_free($parser);
		# Récupération des données xml
		$array['actualversion'] = plxUtils::getValue($strings[$iTags['version'][0]]['value']);
		$array['actualdate'] = plxUtils::getValue($strings[$iTags['date'][0]]['value']);


		if (ini_get('allow_url_fopen')) {
			$handleplugin = @file($url);
		}
		elseif ($curl = @curl_init()){
			$timeout = 5; // set to zero for no timeout
			curl_setopt ($curl, CURLOPT_URL, $url);
			curl_setopt ($curl, CURLOPT_CONNECTTIMEOUT, $timeout);
			curl_setopt ($curl, CURLOPT_RETURNTRANSFER, 1);
			$version_content = curl_exec($curl);
			curl_close($curl);
			if ($version_content != false) {
				$handleplugin = explode("\n", $version_content);
			}
		}	
		if ($handleplugin) {
			$nb = sizeof($handleplugin);
			for($i=0;$i<$nb;$i++) {
				$seach = strstr($handleplugin[$i], '||', true);
				if ($seach == $plugin) {
				    $value = explode('||', $handleplugin[$i]);
					$array['newplugin'] = $value[0];
					$array['newversion'] = $value[1];
					$array['newdate'] = $value[2];
					$array['newurl'] = $value[3];
					$array['active'] = $value[4];
				}
			}
		} else {
			$array ['status'] = 0;
			return $array;
		}
		
		$adate = explode("/", $array['actualdate']); 
		$ndate = explode("/", $array['newdate']);
		$actualdate = $adate[2].$adate[1].$adate[0];
		$newdate = $ndate[2].$ndate[1].$ndate[0];
		
		if (isset($array['actualversion']) AND ($array['actualversion'] == $array['newversion']  AND  $actualdate == $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 1;
			return $array;
		} elseif (isset($array['actualversion']) AND ($array['actualversion'] != $array['newversion'] OR  $actualdate != $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 2;
			return $array;
		} elseif (isset($array['active']) AND $array['active'] == 0) {
			$array ['status'] = 3;
			return $array;
		} else {
		    $array ['status'] = 0;
			return $array;
		}
	}		
}
?>