<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/
include(dirname(__FILE__).'/lib/class.plx.scrolltotop.php'); 
 
class plxScrollToTop extends plxPlugin {
	
	
/**
	 * Constructeur de la classe
	 *
	 * @param	default_lang	langue par défaut utilisée par PluXml
	 * @return	null
	 * @author	Stephane F
	 **/
	public function __construct($default_lang) {

		# Appel du constructeur de la classe plxPlugin (obligatoire)
		parent::__construct($default_lang);

		# droits pour accéder à la page config.php et admin.php du plugin
		$this->setConfigProfil(PROFIL_ADMIN);
		$this->setAdminProfil(PROFIL_ADMIN);
		
		# Vérification des version du plugin
		$this->scrolltotop = new scrolltotop();
		
		# Ajouts des hooks
		$this->addHook('ThemeEndHead', 'ThemeEndHead');
		$this->addHook('ThemeEndBody', 'ThemeEndBody');
	}

	/**
	 * Méthode pour afficher la mise en page 
	 *
	 * @author DPFPIC
	 */
	public function ThemeEndHead()
	{
		# récupérer la racine du site http//.... et du repertoire plugins
		$baseDirPlugins = plxUtils::getRacine().substr(PLX_PLUGINS,2);
		
		$imgUrl = $baseDirPlugins.'plxScrollToTop/img/'.plxPlugin::getParam('STTimg');
		list($width, $height) = @getimagesize($imgUrl);
		$right = plxPlugin::getParam('STT_right');
		$bottom = plxPlugin::getParam('STT_bottom');
		
		echo "\n\t".'<link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.'plxScrollToTop/css/scrolltotop.css" media="screen" />'."\n";
		echo "\t".'<style type="text/css">'."\n";
		echo "\t".'.scrollToTop {'."\n";
		echo "\t".'width: '.$width.'px !important;'."\n";		
		echo "\t".'height: '.$height.'px !important;'."\n";		
		echo "\t".'background-image: url("'.$imgUrl.'");'."\n";
		echo "\t".'right:'.$right.'px;'."\n";
		echo "\t".'bottom:'.$bottom.'px;'."\n";
		echo "\t".'}'."\n";
		echo "\t".'</style>'."\n";
	}
	
	/**
	 * Méthode pour afficher le javascript
	 *
	 * @author DPFPIC
	 */
	public function ThemeEndBody()
	{
		echo "\n\t".'
		<script type="text/javascript">
		if (typeof jQuery == "undefined") {
			document.write(\'<script type="text\/javascript" src="'.PLX_PLUGINS.'plxScrollToTop\/js\/jquery-1.11.0.min.js"><\/script>\');
		}
		</script>'."\n";
		echo "\n\t".'<script type="text/javascript" src="'.PLX_PLUGINS.'plxScrollToTop/js/scrolltotop.js"></script>'."\n";
		echo "\n\t".'<a href="#" class="scrollToTop"></a>'."\n";		
	}
}	