<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/
 
include(dirname(__FILE__).'/lib/class.plx.rendezvous.php'); 
 
class plxRendezVous extends plxPlugin {

	/**
	 * Constructeur de la classe RendezVous
	 *
	 * @param	default_lang	langue par dfaut utilise par PluXml
	 * @return	null
	 **/
	public function __construct($default_lang) {

		# Appel du constructeur de la classe plxPlugin (obligatoire)
		parent::__construct($default_lang);
		
		# Autorisation d'acces  la configuration du plugin
		$this->setConfigProfil(PROFIL_ADMIN, PROFIL_MANAGER);

		# Autorisation d'accs  l'administration du plugin
		$this->setAdminProfil(PROFIL_ADMIN, PROFIL_MANAGER);

		$this->rendezvous = new rendezvous();		

		# Personnalisation du menu admin
		$this->setAdminMenu($this->getlang('L_RDV_DEFAULT_MENU_NAME'),'',$this->getlang('L_RDV_DEFAULT_MENU_NAME'));
		
		# dclaration des hooks
		$this->addHook('plxRendezVous', 'plxRendezVous');
		$this->addHook('ThemeEndHead', 'ThemeEndHead');
	}

	/**
	 * Mthode qui ajoute le fichier css et js dans le fichier header.php du thme
	 **/
	public function ThemeEndHead() {
		echo "\n\t".'<link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.'plxRendezVous/css/rendezvous.css" media="screen" />'."\n";
	}

    public function plxRendezVous(){
		
		echo '<div class="titlerdv"><h1>'.$this->getLang('L_RDV_FO_TITLE').'</h1></div>';
					
		$nbrdv = $this->rendezvous->getRendezVous($this->getParam('tri_rdv'),'online');

		if($nbrdv) {
		$num=1;
		$Affnb = $this->getParam('byPage');
		$dateNow = strtotime(date('Ymd'));
			while($this->rendezvous->plxRecord_rdv->loop()) { # On boucle
				$dateRdv = strtotime($this->rendezvous->plxRecord_rdv->f('date'));
				if ($dateRdv >= $dateNow) {					
					$date = plxDate::formatDate($this->rendezvous->plxRecord_rdv->f('date'));
					$rdv = $this->rendezvous->plxRecord_rdv->f('rdv');
					$link = $this->rendezvous->plxRecord_rdv->f('link');
					$thumbnail = $this->rendezvous->plxRecord_rdv->f('thumbnail')=='' ? 'plugins/plxRendezVous/img/rdv.png' : $this->rendezvous->plxRecord_rdv->f('thumbnail');
					$content = str_replace('../../', '',nl2br($this->rendezvous->plxRecord_rdv->f('content')));
					?>
					<div id="conteneur">
						<div id="blocImg">
							<img alt="thumbnail" src="<?php echo plxUtils::strCheck($thumbnail) ?>" style="width: 90px; height: 90px;" />
						</div>
						<div id="blocTxt">
							<p><strong><?php echo plxUtils::strCheck($date) ?></strong></p>
						    <?php if (!empty($link) AND !empty($content)) { ?>								
								<a class="tooltip <?php echo $this->getParam('tooltipColor') ?>-tooltip" href="<?php echo plxUtils::strCheck($link) ?>">
								<p class="rvh3"><?php echo plxUtils::strCheck($rdv) ?></p>
								<span class="infob"><strong><?php echo plxUtils::strCheck($rdv) ?></strong><br /><?php echo $content ?></span>
								</a>
							<?php } elseif (!empty($link) AND empty($content)) { ?>
								<a class="tooltip <?php echo $this->getParam('tooltipColor') ?>-tooltip" href="<?php echo plxUtils::strCheck($link) ?>">
								<p class="rvh3"><?php echo plxUtils::strCheck($rdv) ?></p>
							<?php } elseif (empty($link) AND !empty($content)) {?>
								<a class="tooltip <?php echo $this->getParam('tooltipColor') ?>-tooltip">
								<p class="rvh3"><?php echo plxUtils::strCheck($rdv) ?></p>
								<span class="infob"><strong><?php echo plxUtils::strCheck($rdv) ?></strong><br /><?php echo $content ?></span>
								</a>
							<?php } else {?>
								<p class="rvh3"><?php echo plxUtils::strCheck($rdv) ?></p>
							<?php } ?>
						</div>
						<br />
					</div>
					<?php
					$num++;
				}
				if ($num > $Affnb) break;
			}
		} else { 
			echo '<div class="titlerdv">'.$this->getLang('L_RDV_NO_RDV').'</div>'; 
		}
		 
	} 
	
}
	
?>
