<?php if(!defined('PLX_ROOT')) exit; ?>
<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/

# Control du token du formulaire
plxToken::validateFormToken($_POST);

# Control de l'accès à la page en fonction du profil de l'utilisateur connecté
$plxAdmin->checkProfil(PROFIL_ADMIN, PROFIL_MANAGER, PROFIL_MODERATOR);

if (!isset($_GET['rdv'])) {
# Suppression des message selectionnes
if (isset($_POST['selection']) AND ((!empty($_POST['btn_ok1']) AND $_POST['selection'][0]=='delete') OR (!empty($_POST['btn_ok2']) AND $_POST['selection'][1]=='delete') AND isset($_POST['idRDV']))) {
	foreach ($_POST['idRDV'] as $k => $v) $plxPlugin->rendezvous->delRendezVous($v);
	header('Location: plugin.php?p=plxRendezVous');
	exit;
}
# Validation des message selectionnes
elseif(isset($_POST['selection']) AND (!empty($_POST['btn_ok1']) AND ($_POST['selection'][0]=='online') OR (!empty($_POST['btn_ok2']) AND $_POST['selection'][1]=='online')) AND isset($_POST['idRDV'])) {
	foreach ($_POST['idRDV'] as $k => $v) $plxPlugin->rendezvous->modRendezVous($v, 'online');
	header('Location: plugin.php?p=plxRendezVous');
	exit;
}
# Mise hors-ligne des message selectionnes
elseif (isset($_POST['selection']) AND ((!empty($_POST['btn_ok1']) AND $_POST['selection'][0]=='offline') OR (!empty($_POST['btn_ok2']) AND $_POST['selection'][1]=='offline')) AND isset($_POST['idRDV'])) {
	foreach ($_POST['idRDV'] as $k => $v) $plxPlugin->rendezvous->modRendezVous($v, 'offline');
	header('Location: plugin.php?p=plxRendezVous');
	exit;
}
elseif (!empty($_POST['new'])) {
# new entrie
	header('Location: plugin.php?p=plxRendezVous&rdv=new');
	exit;
}
elseif (!empty($_POST['add'])) {
	$error ='';
	$link = $_POST['link'];
	# Vérification de la validité de la date de publication
	if(!plxDate::checkDate($_POST['date_rdv_day'],$_POST['date_rdv_month'],$_POST['date_rdv_year'],$_POST['date_rdv_time']))
		$error .= L_ERR_INVALID_PUBLISHING_DATE.' ';
	if(empty($_POST['rdv']))
		$error .= L_ERR_INVALID_SITE.' ';
	if(!empty($_POST['link']) AND !plxUtils::checkSite($_POST['link'])) {
		$error .= L_ERR_INVALID_SITE.' ';	
		$_POST['link'] = $link;
	}
	if (!$error) {
	# new entry
	$comment['rdv'] = $_POST['rdv'];
	$comment['link'] = $_POST['link'];
	$comment['thumbnail'] = $_POST['thumbnail'];
	$comment['content'] = $_POST['content'];
	# Génération du nouveau nom du fichier
	$nbnote = $plxPlugin->rendezvous->nextIdRDV();
	$time = time();
	$time = strftime("%H%M",$time);
	$date = $_POST['date_rdv_year'].$_POST['date_rdv_month'].$_POST['date_rdv_day'].$time;
	$comment['nbnote'] = $nbnote;
	$first = '_';
	$comment['id'] = $first.$date.'_'.$nbnote;
	#print_r($comment);
    $plxPlugin->rendezvous->addRendezVous($comment); # Ajout du nouveau message
	# destruction des variables de saisie
	unset($_SESSION['rdv']);
	unset($_SESSION['link']);
	unset($_SESSION['thumbnail']);
	unset($_SESSION['content']);
	unset($_SESSION['date_rdv_day']);
	unset($_SESSION['date_rdv_month']);
	unset($_SESSION['date_rdv_year']);
	header('Location: plugin.php?p=plxRendezVous');
	exit;
	} else {
	plxMsg::Error($error);
	$_SESSION['rdv'] = $_POST['rdv'];
	$_SESSION['link'] = $_POST['link'];
	$_SESSION['thumbnail'] = $_POST['thumbnail'];
	$_SESSION['content'] = $_POST['content'];
	$_SESSION['date_rdv_day'] = $_POST['date_rdv_day'];
	$_SESSION['date_rdv_month'] = $_POST['date_rdv_month'];
	$_SESSION['date_rdv_year'] = $_POST['date_rdv_year'];
	#print_r($_POST);
	header('Location: plugin.php?p=plxRendezVous&rdv=new');
	exit;
	}
}
elseif (!empty($_POST['update']) AND isset($_POST['idRDV'])) {
# Edition
	$plxPlugin->rendezvous->editRendezVous($_POST,$_POST['idRDV']);
	header('Location: plugin.php?p=plxRendezVous&rdv='.$_POST['idRDV']);
	exit;
}
elseif (isset($_POST['online'])) {
# Commentaire en ligne
	$plxPlugin->rendezvous->editRendezVous($_POST,$_POST['idRDV']);
	$plxPlugin->rendezvous->modRendezVous($_POST['idRDV'],'online');
	header('Location: plugin.php?p=plxRendezVous&rdv='.$_POST['idRDV']);
	exit;
}
elseif (isset($_POST['offline'])) { 
# Commentaire hors-ligne
	$plxPlugin->rendezvous->editRendezVous($_POST,$_POST['idRDV']);
	$plxPlugin->rendezvous->modRendezVous($_POST['idRDV'],'offline');
	header('Location: plugin.php?p=plxRendezVous&rdv='.$_POST['idRDV']);
	exit;
}
elseif (!empty($_POST['btn_ok3']) AND $_POST['selection']=='delete') {
# Suppression des message selectionnes
	$plxPlugin->rendezvous->delRendezVous($_POST['idRDV']);
	header('Location: plugin.php?p=plxRendezVous');
	exit;
}

# Récuperation du type de commentaire à afficher
$_GET['sel'] = !empty($_GET['sel']) ? $_GET['sel'] : '';
if(in_array($_GET['sel'], array('online', 'offline', 'all')))
	$rdvSel = plxUtils::nullbyteRemove($_GET['sel']);
else
	$rdvSel = ((isset($_SESSION['selRDV']) AND !empty($_SESSION['selRDV'])) ? $_SESSION['selRDV'] : 'all');

if($rdvSel=='online') {
	$rdvSelMotif = '/^[0-9]{4}.(.*).xml$/';
	$_SESSION['selRDV'] = 'online';
	$nbRdvPagination=$plxPlugin->rendezvous->nbRendezVous('online');
	echo '<h2>'.$plxPlugin->getlang('L_RDV_ONLINE_LIST').'</h2>';
}
elseif($rdvSel=='offline') {
	$rdvSelMotif = '/^_[0-9]{4}.(.*).xml$/';
	$_SESSION['selRDV'] = 'offline';
	$nbRdvPagination=$plxPlugin->rendezvous->nbRendezVous('offline');
	echo '<h2>'.$plxPlugin->getlang('L_RDV_OFFLINE_LIST').'</h2>';
}
elseif($rdvSel=='all') { // all
	$rdvSelMotif = '/^[[:punct:]]?[0-9]{4}.(.*).xml$/';
	$_SESSION['selRDV'] = 'all';
	$nbRdvPagination=$plxPlugin->rendezvous->nbRendezVous('all');
	echo '<h2>'.$plxPlugin->getlang('L_RDV_ALL_LIST').'</h2>';
}
# destruction des variables saisie
unset($_SESSION['rdv']);
unset($_SESSION['link']);
unset($_SESSION['thumbnail']);
unset($_SESSION['content']);
unset($_SESSION['date_rdv_day']);
unset($_SESSION['date_rdv_month']);
unset($_SESSION['date_rdv_year']);


$breadcrumbs = array();
$breadcrumbs[] = '<a '.($_SESSION['selRDV']=='all'?'class="selected" ':'').'href="plugin.php?p=plxRendezVous&sel=all&amp;page=1">'.$plxPlugin->getLang('L_RDV_ALL').'</a>&nbsp;('.$plxPlugin->rendezvous->nbRendezVous('all').')';
$breadcrumbs[] = '<a '.($_SESSION['selRDV']=='online'?'class="selected" ':'').'href="plugin.php?p=plxRendezVous&sel=online&amp;page=1">'.$plxPlugin->getLang('L_RDV_ONLINE').'</a>&nbsp;('.$plxPlugin->rendezvous->nbRendezVous('online').')';
$breadcrumbs[] = '<a '.($_SESSION['selRDV']=='offline'?'class="selected" ':'').'href="plugin.php?p=plxRendezVous&sel=offline&amp;page=1">'.$plxPlugin->getLang('L_RDV_OFFLINE').'</a>&nbsp;('.$plxPlugin->rendezvous->nbRendezVous('offline').')';

$offline = $plxPlugin->getlang('L_RDV_SET_OFFLINE');
$online = $plxPlugin->getlang('L_RDV_SET_ONLINE');
$delete = $plxPlugin->getlang('L_RDV_DELETE');
$selection = $plxPlugin->getlang('L_RDV_FOR_SELECTION');

function selector($rdvSel, $id) {
    global $offline, $online, $delete, $selection;
    ob_start();
	if($rdvSel=='online')
		plxUtils::printSelect('selection[]', array(''=> $selection, 'offline' => $offline, '-'=>'-----', 'delete' => $delete), '', false,'',$id);
	elseif($rdvSel=='offline')
		plxUtils::printSelect('selection[]', array(''=> $selection, 'online' => $online, '-'=>'-----', 'delete' => $delete), '', false,'',$id);
	elseif($rdvSel=='all')
		plxUtils::printSelect('selection[]', array(''=> $selection, 'online' => $online, 'offline' => $offline,  '-'=>'-----','delete' => $delete), '', false,'',$id);
	return ob_get_clean();
}

$selector1=selector($rdvSel, 'id_selection1');
$selector2=selector($rdvSel, 'id_selection2');
?>
<form action="plugin.php?p=plxRendezVous<?php echo !empty($_GET['a'])?'&a='.$_GET['a']:'' ?>" method="post" id="form_comments">

<div class="inline-form action-bar">
<h2><?php $plxPlugin->lang('L_PAGE_TITLE') ?></h2>
<p class="breadcrumbs">
	<?php echo implode('&nbsp;|&nbsp;', $breadcrumbs); ?>
</p>
<p>
	<?php echo plxToken::getTokenPostMethod() ?>
	<?php echo $selector1 ?><input type="submit" name="btn_ok1" value="<?php echo L_OK ?>" onclick="return confirmAction(this.form, 'id_selection1', 'delete', 'idRDV[]', '<?php echo L_CONFIRM_DELETE ?>')" />
	&nbsp;&nbsp;&nbsp;<input type="submit" name="new" value="<?php $plxPlugin->lang('L_RDV_NEW_RDV') ?>" />
</p>
</div>
<div class="scrollable-table">
<table id="rdv-table" class="full-width">
<thead>
	<tr>
		<th class="checkbox"><input type="checkbox" onclick="checkAll(this.form, 'idRDV[]')" /></th>
		<th class="nbnote"><?php $plxPlugin->lang('L_RDV_LIST_ID') ?></th>			
		<th class="datetime"><?php $plxPlugin->lang('L_RDV_LIST_DATE') ?></th>
		<th class="rdv"><?php $plxPlugin->lang('L_RDV_LIST_RDV') ?></th>
		<th class="etat"><?php $plxPlugin->lang('L_RDV_LIST_ETAT') ?></th>		
		<?php if($_SESSION['selRDV']=='all') { ?>		
		<th class="status"><?php $plxPlugin->lang('L_RDV_LIST_STATUS') ?></th>
		<?php } ?>
		<th class="action"><?php $plxPlugin->lang('L_RDV_LIST_ACTION') ?></th>
	</tr>
</thead>
<tbody>

<?php
# On va récupérer les messages
$plxPlugin->rendezvous->getPagerdv();
$savePage = preg_match('/admin\/(index|plugin).php/', $_SERVER['PHP_SELF']);
$bypage_admin_rdv = 10;
$start = $bypage_admin_rdv*($plxPlugin->rendezvous->page-1);
$nbrdv = $plxPlugin->rendezvous->getRendezVous('rsort',$rdvSel,$start,$bypage_admin_rdv);
$dateNow = strtotime(date('Ymd'));

if($nbrdv) {
	$num=0;
	while($plxPlugin->rendezvous->plxRecord_rdv->loop()) { # On boucle
		$status = $plxPlugin->rendezvous->plxRecord_rdv->f('status');
		$dateRdv = strtotime($plxPlugin->rendezvous->plxRecord_rdv->f('date'));
		if ($status == 'online') { $first = ''; } else { $first = '_'; }
		$id = $first.$plxPlugin->rendezvous->plxRecord_rdv->f('date').'_'.$plxPlugin->rendezvous->plxRecord_rdv->f('nbnote');
		$content = nl2br($plxPlugin->rendezvous->plxRecord_rdv->f('content'));
		# On génère notre ligne
		echo '<tr class="line-'.(++$num%2).' top type-'.$plxPlugin->rendezvous->plxRecord_rdv->f('type').'">';
		echo '<td><input type="checkbox" name="idRDV[]" value="'.$id.'" /></td>';
		echo '<td class="nbnote">'.$plxPlugin->rendezvous->plxRecord_rdv->f('nbnote').'&nbsp;</td>';		
		echo '<td class="datetime">'.plxDate::formatDate($plxPlugin->rendezvous->plxRecord_rdv->f('date')).'&nbsp;</td>';
		echo '<td>'.plxUtils::strCut($plxPlugin->rendezvous->plxRecord_rdv->f('rdv'),60).'&nbsp;</td>';
		if ($dateNow > $dateRdv) {
			echo '<td><span style="color:red">Terminé&nbsp;</span></td>';
		} else {
			echo '<td><span style="color:green">Actif&nbsp;</span></td>';
		}
		if($_SESSION['selRDV']=='all') {
			$status = '<strong>'.($status=='online'?$plxPlugin->getlang('L_RDV_ONLINE'):$plxPlugin->getlang('L_RDV_OFFLINE')).'</strong>';
			echo '<td>'.$status.'&nbsp;</td>';
		}
		echo '<td class="action">';
		echo '<a href="plugin.php?p=plxRendezVous&rdv='.$id.'" title="'.$plxPlugin->getlang('L_RDV_EDIT_TITLE').'">'.$plxPlugin->getlang('L_RDV_EDIT').'</a>';
		echo '</td></tr>';
	}
} else { # Pas de message
	echo '<tr><td colspan="7" class="center">'.$plxPlugin->getlang('L_RDV_NO_MESSAGE').'</td></tr>';
}
?>
</tbody>
</table>
</div>
</form>

<div id="pagination">
<p>
<?php
# Affichage de la pagination
if($nbrdv) { # Si on a des message (hors page)
	# Calcul des pages
	$last_page = ceil($nbRdvPagination/$bypage_admin_rdv);
	if($plxPlugin->rendezvous->page > $last_page) $plxPlugin->rendezvous->page = $last_page;
	$prev_page = $plxPlugin->rendezvous->page - 1;
	$next_page = $plxPlugin->rendezvous->page + 1;
	# Generation des URLs
	$p_url = 'plugin.php?p=plxRendezVous&page='.$prev_page.'&amp;sel='.$_SESSION['selRDV']; # Page precedente
	$n_url = 'plugin.php?p=plxRendezVous&page='.$next_page.'&amp;sel='.$_SESSION['selRDV']; # Page suivante
	$l_url = 'plugin.php?p=plxRendezVous&page='.$last_page.'&amp;sel='.$_SESSION['selRDV']; # Derniere page
	$f_url = 'plugin.php?p=plxRendezVous&page=1'.'&amp;sel='.$_SESSION['selRDV']; # Premiere page
	# On effectue l'affichage
	if($plxPlugin->rendezvous->page > 2) # Si la page active > 2 on affiche un lien 1ere page
		echo '<span class="p_first"><a href="'.$f_url.'" title="'.L_PAGINATION_FIRST_TITLE.'">'.L_PAGINATION_FIRST.'</a></span>';
	if($plxPlugin->rendezvous->page > 1) # Si la page active > 1 on affiche un lien page precedente
		echo '<span class="p_prev"><a href="'.$p_url.'" title="'.L_PAGINATION_PREVIOUS_TITLE.'">'.L_PAGINATION_PREVIOUS.'</a></span>';
	# Affichage de la page courante
	printf('<span class="p_page">'.L_PAGINATION.'</span>',$plxPlugin->rendezvous->page,$last_page);
	if($plxPlugin->rendezvous->page < $last_page) # Si la page active < derniere page on affiche un lien page suivante
		echo '<span class="p_next"><a href="'.$n_url.'" title="'.L_PAGINATION_NEXT_TITLE.'">'.L_PAGINATION_NEXT.'</a></span>';
	if(($plxPlugin->rendezvous->page + 1) < $last_page) # Si la page active++ < derniere page on affiche un lien derniere page
		echo '<span class="p_last"><a href="'.$l_url.'" title="'.L_PAGINATION_LAST_TITLE.'">'.L_PAGINATION_LAST.'</a></span>';
}
?>
</p>
</div>
<?php } else {
if ($_GET['rdv'] != 'new') {
$nbrdv = $plxPlugin->rendezvous->getRendezVous('rsort',$_GET['rdv']);
# Statut de le message
if ($plxPlugin->rendezvous->plxRecord_rdv->f('status') == 'offline') {
	$statut = '<strong>'.$plxPlugin->getlang('L_RDV_OFFLINE').'</strong>';
} else {
	$statut = '<strong>'.$plxPlugin->getlang('L_RDV_ONLINE').'</strong>';
}	
#Date du commentaire
$date = plxDate::date2Array($plxPlugin->rendezvous->plxRecord_rdv->f('date'));

# Email visible
$actmail = plxUtils::strCheck($plxPlugin->rendezvous->plxRecord_rdv->f('actmail'));

# Datas
$nbnote = $plxPlugin->rendezvous->plxRecord_rdv->f('nbnote');
$rdv = plxUtils::strCheck($plxPlugin->rendezvous->plxRecord_rdv->f('rdv'));
$thumbnail = $plxPlugin->rendezvous->plxRecord_rdv->f('thumbnail');
$content = $plxPlugin->rendezvous->plxRecord_rdv->f('content');
$link = $plxPlugin->rendezvous->plxRecord_rdv->f('link');
} else {
$date = array();
$time = '';
$date['time'] = date('H:i');
$date['day'] = isset($_SESSION['date_rdv_day']) ? $_SESSION['date_rdv_day'] : NULL;
$date['month'] = isset($_SESSION['date_rdv_month']) ? $_SESSION['date_rdv_month'] : NULL;
$date['year'] = isset($_SESSION['date_rdv_year']) ? $_SESSION['date_rdv_year'] : NULL;
$rdv = isset($_SESSION['rdv']) ? $_SESSION['rdv'] : NULL;
$thumbnail = isset($_SESSION['thumbnail']) ? $_SESSION['thumbnail'] : NULL;
$link = isset($_SESSION['link']) ? $_SESSION['link'] : NULL;
$content = isset($_SESSION['content']) ? $_SESSION['content'] : NULL;	
}
?>
<script>
function refreshImg(dta) {
	if(dta.trim()==='') {
		document.getElementById('id_thumbnail_img').innerHTML = '';
	} else {
		var link = dta.match(/^(https?:\/\/[^\s]+)/gi) ? dta : '<?php echo $plxAdmin->racine ?>'+dta;
		document.getElementById('id_thumbnail_img').innerHTML = '<img src="'+link+'" alt="" />';
	}
}
</script>
<form action="plugin.php?p=plxRendezVous" method="post" id="form_comment">
	<?php if ($_GET['rdv'] != 'new') { ?>
	<div class="inline-form action-bar">
	    <h2><?php $plxPlugin->lang('L_RDV_EDITING') ?></h2>	
		<p class="back"><a href="plugin.php?p=plxRendezVous"><?php $plxPlugin->lang('L_RDV_BACK_TO_MESSAGES') ?></a></p>
		<?php echo plxToken::getTokenPostMethod() ?>
		<input class="red" type="submit" name="btn_ok3" value="<?php $plxPlugin->lang('L_RDV_DELETE') ?>" onclick="Check=confirm('<?php $plxPlugin->lang('L_RDV_DELETE_CONFIRM') ?>');if(Check==false) return false;"/>
		&nbsp;&nbsp;&nbsp;&nbsp;
		<?php if(substr($_GET['rdv'],0,1) == '_') : ?>
		<input type="submit" name="online" value="<?php $plxPlugin->lang('L_RDV_PUBLISH_BUTTON') ?>" />
		<?php else : ?>
		<input type="submit" name="offline" value="<?php $plxPlugin->lang('L_RDV_OFFLINE_BUTTON') ?>" />
		<?php endif; ?>
		&nbsp;&nbsp;&nbsp;&nbsp;
		<input type="submit" name="update" value="<?php $plxPlugin->lang('L_RDV_UPDATE_BUTTON') ?>" />
	</div>
	<?php } else { ?>
	<div class="inline-form action-bar">
	    <h2><?php $plxPlugin->lang('L_RDV_EDITING') ?></h2>	
		<p class="back"><a href="plugin.php?p=plxRendezVous"><?php $plxPlugin->lang('L_RDV_BACK_TO_MESSAGES') ?></a></p>
		<?php echo plxToken::getTokenPostMethod() ?>
		<?php if ($_GET['rdv'] != 'new') { ?>
		<input class="red" type="submit" name="btn_ok3" value="<?php $plxPlugin->lang('L_RDV_DELETE') ?>" onclick="Check=confirm('<?php $plxPlugin->lang('L_RDV_DELETE_CONFIRM') ?>');if(Check==false) return false;"/>
		&nbsp;&nbsp;&nbsp;&nbsp;
		<?php if(substr($_GET['rdv'],0,1) == '_') : ?>
		<input type="submit" name="online" value="<?php $plxPlugin->lang('L_RDV_PUBLISH_BUTTON') ?>" />
		<?php else : ?>
		<input type="submit" name="offline" value="<?php $plxPlugin->lang('L_RDV_OFFLINE_BUTTON') ?>" />
		<?php endif; ?>
		&nbsp;&nbsp;&nbsp;&nbsp;
		<input type="submit" name="update" value="<?php $plxPlugin->lang('L_RDV_UPDATE_BUTTON') ?>" />
		<?php } else { ?>
		<input type="submit" name="add" value="<?php $plxPlugin->lang('L_RDV_VALID_BUTTON') ?>" />
		<?php } ?>
	</div>
	<?php } ?>
	<?php if ($_GET['rdv'] != 'new') { ?>
	<ul>
		<li><?php $plxPlugin->lang('L_RDV_ID') ?> : <?php echo $nbnote; ?></li> 
		<li><?php $plxPlugin->lang('L_RDV_STATUS_FIELD') ?> : <?php echo $statut; ?></li>
	</ul>
	<?php } ?>
	<fieldset>
		<?php plxUtils::printInput('idRDV',$_GET['rdv'],'hidden'); ?>
        <?php plxUtils::printInput('selection','delete','hidden'); ?>
		<?php plxUtils::printInput('date_rdv_time',$date['time'],'hidden'); ?>
		<label><?php $plxPlugin->lang('L_RDV_DATE_FIELD') ?>&nbsp;:</label>
		<div class="inline-form publication">
		<?php plxUtils::printInput('date_rdv_day',$date['day'],'text','2-2',false,'day'); ?>
		<?php plxUtils::printInput('date_rdv_month',$date['month'],'text','2-2',false,'month'); ?>
		<?php plxUtils::printInput('date_rdv_year',$date['year'],'text','2-4',false,'year'); ?>
		<!--<?php plxUtils::printInput('date_rdv_time',$date['time'],'text','2-5',false,'time'); ?>-->
		<a class="ico_cal" href="javascript:void(0)" onclick="dateNow('date_rdv', <?php echo date('Z') ?>); return false;" title="<?php L_NOW; ?>">
		<img src="theme/images/date.png" alt="calendar" /></a>
		</div>
		<p><label for="id_rdv"><?php $plxPlugin->lang('L_RDV_RDV_FIELD') ?> :</label>
		<?php plxUtils::printInput('rdv',$rdv,'text','100-255') ?></p>
		<p><label for="id_link"><?php $plxPlugin->lang('L_RDV_LINK_FIELD') ?> :</label>
		<?php plxUtils::printInput('link',$link,'text','100-255') ?></p>
		<label for="id_thumbnail">
		<?php $plxPlugin->lang('L_RDV_THUMBNAIL_FIELD') ?>&nbsp;:&nbsp;
						<a title="<?php echo L_THUMBNAIL_SELECTION ?>" id="toggler_thumbnail" href="javascript:void(0)" onclick="mediasManager.openPopup('id_thumbnail', true)" style="outline:none; text-decoration: none">+</a>
		</label>
					<?php plxUtils::printInput('thumbnail',plxUtils::strCheck($thumbnail),'text','255-255',false,'full-width','','onkeyup="refreshImg(this.value)"'); ?>
		<p><label for="id_content"><?php $plxPlugin->lang('L_RDV_INFOBULLE_FIELD') ?> :</label>
		<?php plxUtils::printArea('content',$content, 60, 7); ?></p>
	</fieldset>
</form>
<?php } ?>
