<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/
 
include(dirname(__FILE__).'/lib/class.plx.priserdv.php'); 
 
class plxPriseRDV extends plxPlugin {
	
	/**
		* Constructeur de la classe PriseRDV
	 *
	 * @param	default_lang	langue par défaut utilisée par PluXml
	 * @return	null
	 **/
	public function __construct($default_lang) {

		# Appel du constructeur de la classe plxPlugin (obligatoire)
		parent::__construct($default_lang);
		
		# Autorisation d'acces à la configuration du plugin
		$this->setConfigProfil(PROFIL_ADMIN, PROFIL_MANAGER);

		# Autorisation d'accès à l'administration du plugin
		$this->setAdminProfil(PROFIL_ADMIN, PROFIL_MANAGER, PROFIL_WRITER);

		$this->priserdv = new priserdv();		

		# Personnalisation du menu admin
		$this->setAdminMenu($this->getlang('L_PRDV_DEFAULT_MENU_NAME'),'',$this->getlang('L_PRDV_DEFAULT_MENU_NAME'));
		
		# déclaration des hooks
		$this->addHook('AdminTopBottom', 'AdminTopBottom');
		if(plxUtils::checkMail($this->getParam('email_admin'))) {
			$this->addHook('plxMotorPreChauffageBegin', 'plxMotorPreChauffageBegin');
			$this->addHook('plxShowConstruct', 'plxShowConstruct');
			$this->addHook('plxShowStaticListEnd', 'plxShowStaticListEnd');
			$this->addHook('plxShowPageTitle', 'plxShowPageTitle');
			$this->addHook('ThemeEndHead', 'ThemeEndHead');
			$this->addHook('AdminTopEndHead', 'AdminTopEndHead');
			$this->addHook('SitemapStatics', 'SitemapStatics');
		}
	}

	/**
	 * Méthode de traitement du hook plxShowConstruct
	 **/
	public function plxShowConstruct() {
	
		# infos sur la page statique
		$string  = "if(\$this->plxMotor->mode=='priserdv') {";
		$string .= "	\$array = array();";
		$string .= "	\$array[\$this->plxMotor->cible] = array(
			'name'		=> '".$this->getParam('mnuName')."',
			'menu'		=> '',
			'url'		=> 'priserdv',
			'readable'	=> 1,
			'active'	=> 1,
			'group'		=> ''
		);";
		$string .= "	\$this->plxMotor->aStats = array_merge(\$this->plxMotor->aStats, \$array);";
		$string .= "}";
		echo "<?php ".$string." ?>";
	}
	
	/**
	 * Méthode appelée à l'activation du plugin pour créer le répertoire prdv
	 *
	 * @author	Stephane F
	 **/
	public function onActivate() {
		# Vérification de l'existence du dossier /plugins/prdv
		if(!is_dir(PLX_ROOT.PLX_CONFIG_PATH.'plugins/prdv')) {
			@mkdir(PLX_ROOT.PLX_CONFIG_PATH.'plugins/prdv',0755,true);

			# Protection du répertoire prdv
			plxUtils::write('', PLX_ROOT.PLX_CONFIG_PATH.'plugins/prdv/index.html');
			if (!file_exists(PLX_ROOT.PLX_CONFIG_PATH.'plugins/prdv/.htaccess')){
				file_put_contents(PLX_ROOT.PLX_CONFIG_PATH.'plugins/prdv/.htaccess',"<Files *>
	Order allow,deny
	Deny from all
</Files>      
      ");
    }			
		}
	}	
	/**
	 * Méthode de traitement du hook plxMotorPreChauffageBegin
	 **/
	public function plxMotorPreChauffageBegin() {

		$template = $this->getParam('template')==''?'static.php':$this->getParam('template');

		$string = "
		if(\$this->get && preg_match('/^priserdv\/?/',\$this->get)) {
			\$this->mode = 'priserdv';
			\$this->cible = '../.".PLX_PLUGINS."plxPriseRDV/form';
			\$this->template = '".$template."';
			return true;
		}
		";

		echo "<?php ".$string." ?>";
	}	

	/**
		* Méthode de traitement du hook plxShowStaticListEnd
	 **/
	public function plxShowStaticListEnd() {

		# ajout du menu pour accèder à la page de priserdv
		if($this->getParam('mnuDisplay')) {
			echo "<?php \$class = \$this->plxMotor->mode=='priserdv'?'active':'noactive'; ?>";
			echo "<?php array_splice(\$menus, ".($this->getParam('mnuPos')-1).", 0, '<li><a class=\"static '.\$class.'\" href=\"'.\$this->plxMotor->urlRewrite('?priserdv').'\" title=\"".$this->getParam('mnuName')."\">".$this->getParam('mnuName')."</a></li>'); ?>";
		}

	}

	/**
	 * Méthode qui ajoute le fichier css et js dans le fichier header.php du thème
	 **/
	public function ThemeEndHead() {
		echo "\n\t".'<link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.'plxPriseRDV/css/priserdv.css" media="screen" />'."\n";
		echo "\n\t".'<script type="text/javascript" src="'.PLX_PLUGINS.'plxPriseRDV/js/nospam.js"></script>'."\n";
		echo "\n\t".'<link href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css" rel="stylesheet" type="text/css"/>'."\n";
		echo "\n\t".'
		<script type="text/javascript">
		if (typeof jQuery == "undefined") {
			document.write(\'<script type="text\/javascript" src="'.PLX_PLUGINS.'plxPriseRDV\/js\/jquery-1.12.4.js"><\/script>\');
		}
		</script>'."\n";
		echo "\n\t".'<script src="'.PLX_PLUGINS.'plxPriseRDV/js/jquery-ui.min.js"></script>'."\n";
		echo "\n\t".'<script src="'.PLX_PLUGINS.'plxPriseRDV/js/datepicker-fr.js" type="text/javascript"></script>'."\n";
	}

	public function AdminTopEndHead() {
		echo "\n\t".'<link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.'plxPriseRDV/css/priserdv.css" media="screen" />'."\n";
		echo "\n\t".'<link href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css" rel="stylesheet" type="text/css"/>'."\n";
		echo "\n\t".'
		<script type="text/javascript">
		if (typeof jQuery == "undefined") {
			document.write(\'<script type="text\/javascript" src="'.PLX_PLUGINS.'plxPriseRDV\/js\/jquery-1.12.4.js"><\/script>\');
		}
		</script>'."\n";
		echo "\n\t".'<script src="'.PLX_PLUGINS.'plxPriseRDV/js/jquery-ui.min.js"></script>'."\n";
		echo "\n\t".'<script src="'.PLX_PLUGINS.'plxPriseRDV/js/datepicker-fr.js" type="text/javascript"></script>'."\n";
		echo "\n\t".'<script src="'.PLX_PLUGINS.'plxPriseRDV/js/jquery.timepicker.js" type="text/javascript"></script>'."\n";
		echo "\n\t".'<link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.'plxPriseRDV/css/jquery.timepicker.css" media="screen" />'."\n";
	}	
	
	/**
	 * Méthode qui rensigne le titre de la page dans la balise html <title>
	 **/
	public function plxShowPageTitle() {
		echo '<?php
			if($this->plxMotor->mode == "priserdv") {
				echo plxUtils::strCheck("'.stripslashes($this->getParam('mnuName')).' - ".$this->plxMotor->aConf["title"]);
				return true;
			}
		?>';
	}	

	/**
	 * Méthode qui référence la page de priserdv dans le sitemap
	 **/
	public function SitemapStatics() {
		echo '<?php
		echo "\n";
		echo "\t<url>\n";
		echo "\t\t<loc>".$plxMotor->urlRewrite("?priserdv")."</loc>\n";
		echo "\t\t<changefreq>monthly</changefreq>\n";
		echo "\t\t<priority>0.8</priority>\n";
		echo "\t</url>\n";
		?>';
	}

	/**
	 * Méthode qui affiche un message si l'adresse email du priserdv n'est pas renseignée
	 **/
	public function AdminTopBottom() {

		echo '<?php
		if($plxAdmin->plxPlugins->aPlugins["plxPriseRDV"]->getParam("email_admin")=="") {
			echo "<p class=\"warning\">Plugin PriseRDV<br />'.$this->getLang("L_PRDV_ERR_EMAIL_ADMIN").'</p>";
			plxMsg::Display();
		}
		?>';
	}
	
	public function monthText() {
		$monthText = array('', $this->getLang("L_PRDV_JAN"), $this->getLang("L_PRDV_FEB"), $this->getLang("L_PRDV_MAR"), $this->getLang("L_PRDV_APR"), $this->getLang("L_PRDV_MAY"), $this->getLang("L_PRDV_JUN"), $this->getLang("L_PRDV_JUL"),$this->getLang("L_PRDV_AUG"), $this->getLang("L_PRDV_SEP"), $this->getLang("L_PRDV_OCT"), $this->getLang("L_PRDV_NOV"), $this->getLang("L_PRDV_DEC"));
		return $monthText;
	}
	
	public function dayText() {
		$dayText = array('', $this->getLang("L_PRDV_MON"), $this->getLang("L_PRDV_TUE"), $this->getLang("L_PRDV_WED"), $this->getLang("L_PRDV_THU"), $this->getLang("L_PRDV_FRI"), $this->getLang("L_PRDV_SAT"), $this->getLang("L_PRDV_SUN"));
		return $dayText;
	}
	
	public function monthText_3() {
		$monthText = array('', $this->getLang("L_PRDV_JAN_3"), $this->getLang("L_PRDV_FEB_3"), $this->getLang("L_PRDV_MAR_3"), $this->getLang("L_PRDV_APR_3"), $this->getLang("L_PRDV_MAY_3"), $this->getLang("L_PRDV_JUN_3"), $this->getLang("L_PRDV_JUL_3"),$this->getLang("L_PRDV_AUG_3"), $this->getLang("L_PRDV_SEP_3"), $this->getLang("L_PRDV_OCT_3"), $this->getLang("L_PRDV_NOV_3"), $this->getLang("L_PRDV_DEC_3"));
		return $monthText;
	}
	
	public function dayText_3() {
		$dayText = array('', $this->getLang("L_PRDV_MON_3"), $this->getLang("L_PRDV_TUE_3"), $this->getLang("L_PRDV_WED_3"), $this->getLang("L_PRDV_THU_3"), $this->getLang("L_PRDV_FRI_3"), $this->getLang("L_PRDV_SAT_3"), $this->getLang("L_PRDV_SUN_3"));
		return $dayText;
	}	
}
	
?>
