<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/
 
class priserdv {

	public $plxRecord_pdrv = null; # Objet du livre d'or
	public $plxGlob_pdrv = null; # Objet plxGlob du livre d'or
	
	public function __construct() {
	
		$this->pathname = PLX_ROOT.PLX_CONFIG_PATH.'plugins/prdv/';
		 
	}

	public function getPriseRDV($termin) {

		$array= array();
		# On recupre les fichiers des Messages
		$array = $this->parsePriseRDV($this->pathname.$termin.'.xml');
		# On stocke les enregistrements dans un objet plxRecord				
		return $array;
	}
	
	public function parsePriseRDV($filename) {

		# Mise en place du parseur XML
		$data = implode('',file($filename));
		$parser = xml_parser_create(PLX_CHARSET);
		xml_parser_set_option($parser,XML_OPTION_CASE_FOLDING,0);
		xml_parser_set_option($parser,XML_OPTION_SKIP_WHITE,0);
		xml_parse_into_struct($parser,$data,$values,$iTags);
		xml_parser_free($parser);
		# Recuperation des valeurs de nos champs XML
		$pdrv['time_solt'] = plxUtils::getValue($values[$iTags['time_solt'][0]]['value']);
		$pdrv['last_name'] = plxUtils::getValue($values[$iTags['last_name'][0]]['value']);
		$pdrv['first_name'] = plxUtils::getValue($values[$iTags['first_name'][0]]['value']);
		$pdrv['email'] = plxUtils::getValue($values[$iTags['email'][0]]['value']);
		$pdrv['phone'] = plxUtils::getValue($values[$iTags['phone'][0]]['value']);	
		$pdrv['field_1'] = plxUtils::getValue($values[$iTags['field_1'][0]]['value']);
		$pdrv['field_2'] = plxUtils::getValue($values[$iTags['field_2'][0]]['value']);
		$pdrv['field_3'] = plxUtils::getValue($values[$iTags['field_3'][0]]['value']);
		$pdrv['field_4'] = plxUtils::getValue($values[$iTags['field_4'][0]]['value']);		
		$pdrv['comment'] = plxUtils::getValue($values[ $iTags['comment'][0] ]['value']);
		# On retourne le tableau
		return $pdrv;
	}
	
	public function addPriseRDV($content, $filename, $type='add') {
		$filename = $filename.'.xml';
		
		# On genere le contenu de notre fichier XML
		$xml = "<?xml version='1.0' encoding='".PLX_CHARSET."'?>\n";
		$xml .= "<appointment>\n";
		$xml .= "\t<time_solt>".plxUtils::cdataCheck($content['time_solt'])."</time_solt>\n";
		$xml .= "\t<last_name><![CDATA[".plxUtils::cdataCheck($content['last_name'])."]]></last_name>\n";
		$xml .= "\t<first_name><![CDATA[".plxUtils::cdataCheck($content['first_name'])."]]></first_name>\n";
		$xml .= "\t<email><![CDATA[".plxUtils::cdataCheck($content['email'])."]]></email>\n";		
		$xml .= "\t<phone><![CDATA[".plxUtils::cdataCheck($content['phone'])."]]></phone>\n";
		$xml .= "\t<field_1><![CDATA[".plxUtils::cdataCheck($content['field_1'])."]]></field_1>\n";
		$xml .= "\t<field_2><![CDATA[".plxUtils::cdataCheck($content['field_2'])."]]></field_2>\n";
		$xml .= "\t<field_3><![CDATA[".plxUtils::cdataCheck($content['field_3'])."]]></field_3>\n";
		$xml .= "\t<field_4><![CDATA[".plxUtils::cdataCheck($content['field_4'])."]]></field_4>\n";
		$xml .= "\t<comment><![CDATA[".plxUtils::cdataCheck($content['comment'])."]]></comment>\n";
		$xml .= "</appointment>\n";
		# On ecrit ce contenu dans notre fichier XML
		if ($type == 'add') {
		if (!file_exists($this->pathname.$filename)) {
			return plxUtils::write($xml, $this->pathname.$filename);
		} else {
			return false;
		}
		} else {
			return plxUtils::write($xml, $this->pathname.$filename);
		}
	}

	public function delPriseRDV($id, $nomsg='0') {

		# Gnration du nom du fichier
		$filename = $this->pathname.$id.'.xml';
		# Suppression du Message
		if(file_exists($filename)) {
			unlink($filename);
		}
		
		if(!file_exists($filename))
			if ($nomsg =='0') {
				return plxMsg::Info(L_COMMENT_DELETE_SUCCESSFUL);
			} else {
				return;
			}
		else
			return plxMsg::Error(L_COMMENT_DELETE_ERR);
	}

	public function getDirectoryTree1($Dir,$ext,$ordre='sort',$type='all',$depart='0',$limite=false){ 
		if ($ordre == 'sort') {
			$dirs = @array_diff(scandir($Dir), Array( ".", ".." )); 
		} else {
			$dirs = @array_diff(scandir($Dir,1), Array( ".", ".." )); 
		}
		$dir_array = Array(); 
		foreach($dirs as $d){ 
			if(is_dir($Dir.$d)){ 
				$dir_array[$d] = getDirectoryTree( $Dir."/".$d , $ext); 
			}
			$dir_array[] = $d;
        } 
		
		# On a une limite, on coupe le tableau
		if($limite)
			$dir_array = array_slice($dir_array,$depart,$limite);
		# On retourne le tableau
		return $dir_array; 
	}
	
	public function getDirectoryTree($Dir,$ext,$offext=false,$ordre='sort',$type='all',$depart='0',$limite=false){ 
		if ($ordre == 'sort') {
			$dirs = @array_diff(scandir($Dir), Array( ".", ".." )); 
		} else {
			$dirs = @array_diff(scandir($Dir,1), Array( ".", ".." )); 
		}
		$dir_array = Array(); 
		foreach($dirs as $d){ 
			if(is_dir($Dir.$d)){ 
				$dir_array[$d] = ($offext)? substr(getDirectoryTree( $Dir."/".$d , $ext),0, -4) : getDirectoryTree( $Dir."/".$d , $ext); 
			}else{ 
			if (($ext)?preg_match('/'.$ext.'/',$d):1)
			    $dir_array[] = ($offext)? substr($d,0, -4) : $d; 
			}
		}		
   		
		# On a une limite, on coupe le tableau
		if($limite)
			$dir_array = array_slice($dir_array,$depart,$limite);
		# On retourne le tableau
		return $dir_array; 
	}
	
	public function add_time_slot($slot_am,$solt_pm,$add) {
		$slot_array = Array(); 
		if ($slot_am != '00:00' AND $solt_pm != '00:00') {
		$timestamp = strtotime("$slot_am");
		$add_hour = strtotime("+$add minutes", $timestamp);
		$slot_array[] = date('H:i',$timestamp);
		while ($timestamp < strtotime("$solt_pm")) {
			$add_hour = strtotime("+$add minutes", $timestamp);
			$slot_array[] = date('H:i', $add_hour);
			$timestamp = $add_hour;
		}
		}
		return $slot_array;
	}

	public function add_time_slotH($slot_am,$solt_pm,$add) {
		$slot_array = Array(); 
		if ($slot_am != '00:00' AND $solt_pm != '00:00') {
		$timestamp = strtotime("$slot_am");
		$add_hour = strtotime("+$add minutes", $timestamp);
		$slot_array = date('H:i',$timestamp);
		while ($timestamp < strtotime("$solt_pm")) {
			$add_hour = strtotime("+$add minutes", $timestamp);
			$slot_array .= ','.date('H:i', $add_hour);
			$timestamp = $add_hour;
		}
		}
		return $slot_array;
	}	

    public function plageH ($slot_am,$solt_pm,$add) {
		$plageH1_am = explode('-',$slot_am);

		$i = 0;
		$pH1_am = '';
		for ($i=0; $i < count($plageH1_am)-1; $i=$i+2) {
			$pH1_am .= ','.$this->add_time_slotH($plageH1_am[$i],$plageH1_am[$i+1],$add);
		}
		$plageH1_pm = explode('-',$solt_pm);
		$i = 0;
		$pH1_pm = '';
		for ($i=0; $i < count($plageH1_pm)-1; $i=$i+2) {
			$pH1_pm .= ','.$this->add_time_slotH($plageH1_pm[$i],$plageH1_pm[$i+1],$add);
		}
		$pH1 = substr($pH1_am,1).$pH1_pm;
		$plageH = explode(',', $pH1);
		return $plageH;
	}
	
	public function calDays($date2) {
		$date1 = date("d-m-Y");
		$date2 = str_replace('/', '-', $date2); 
		// On transforme les 2 dates en timestamp
		$date3 = strtotime($date1);
		$date4 = strtotime($date2);
 
		// On rcupre la diffrence de timestamp entre les 2 prcdents
		$nbJoursTimestamp = $date4 - $date3;
 
		// ** Pour convertir le timestamp (exprim en secondes) en jours **
		// On sait que 1 heure = 60 secondes * 60 minutes et que 1 jour = 24 heures donc :
		$nbJours = $nbJoursTimestamp/86400; // 86 400 = 60*60*24
		$nbJours = (floor($nbJours / 7)* 7);
		
		return $nbJours;
	}
	
	public function transform_vars_to_value($template, $vars) {
		$output = $template;
		foreach ($vars as $key => $value) {
			$tag_to_replace = "{{ $key }}";
			$output = str_replace($tag_to_replace, $value, $output);
		}
	return $output;
	}	
	
	public function selectInput($name, $value, $select) {
		$list = array();
		$select = ','.$select;
		$list = explode(',', $select);
		$result = '<select id="id_'.$name.'" name="'.$name.'">';
			foreach ($list as $val1=>$title) {
			$selected = ($value == $title) ? ' selected' : '';
			$result .= '<option value="'.$title.'"'.$selected.'>'.$title.'</option>';
		}
		$result .= '</select>';
		echo $result;
	}
	
	/**
	 * Verification des version des plugins
	 *
	 * @param	plugin				le nom du plugin
	 * @return	array()
	 * @author	DPFPIC
	 **/
	public function UpdatePlugin($plugin) {
	    $array = array();
		$url = 'http://dpfpic.com/plugins.rep';
		$filename = PLX_PLUGINS.$plugin.'/infos.xml';
		
		# Mise en place du parseur XML
		$data = implode('',file($filename));
		$parser = xml_parser_create('UTF-8');
		xml_parser_set_option($parser,XML_OPTION_CASE_FOLDING,0);
		xml_parser_set_option($parser,XML_OPTION_SKIP_WHITE,0);
		xml_parse_into_struct($parser,$data,$strings,$iTags);
		xml_parser_free($parser);
		# Rcupration des donnes xml
		$array['actualversion'] = plxUtils::getValue($strings[$iTags['version'][0]]['value']);
		$array['actualdate'] = plxUtils::getValue($strings[$iTags['date'][0]]['value']);


		if (ini_get('allow_url_fopen')) {
			$handleplugin = @file($url);
		}
		elseif ($curl = @curl_init()){
			$timeout = 5; // set to zero for no timeout
			curl_setopt ($curl, CURLOPT_URL, $url);
			curl_setopt ($curl, CURLOPT_CONNECTTIMEOUT, $timeout);
			curl_setopt ($curl, CURLOPT_RETURNTRANSFER, 1);
			$version_content = curl_exec($curl);
			curl_close($curl);
			if ($version_content != false) {
				$handleplugin = explode("\n", $version_content);
			}
		}	
		if ($handleplugin) {
			$nb = sizeof($handleplugin);
			for($i=0;$i<$nb;$i++) {
				$seach = strstr($handleplugin[$i], '||', true);
				if ($seach == $plugin) {
				    $value = explode('||', $handleplugin[$i]);
					$array['newplugin'] = $value[0];
					$array['newversion'] = $value[1];
					$array['newdate'] = $value[2];
					$array['newurl'] = $value[3];
					$array['active'] = $value[4];
				}
			}
		} else {
			$array ['status'] = 0;
			return $array;
		}
		
		$adate = explode("/", $array['actualdate']); 
		$ndate = explode("/", $array['newdate']);
		$actualdate = $adate[2].$adate[1].$adate[0];
		$newdate = $ndate[2].$ndate[1].$ndate[0];
		
		if (isset($array['actualversion']) AND ($array['actualversion'] == $array['newversion']  AND  $actualdate == $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 1;
			return $array;
		} elseif (isset($array['actualversion']) AND ($array['actualversion'] != $array['newversion'] OR  $actualdate != $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 2;
			return $array;
		} elseif (isset($array['active']) AND $array['active'] == 0) {
			$array ['status'] = 3;
			return $array;
		} else {
		    $array ['status'] = 0;
			return $array;
		}
	}		
}	