<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://dpfpic.com
 * Licence GNU_GPL
 **/
 
include(dirname(__FILE__).'/lib/class.plx.nnforum.php'); 
 
class plxNNForum extends plxPlugin {

	/**
	 * Constructeur de la classe NNForum
	 *
	 * @param	default_lang	langue par défaut utilisée par PluXml
	 * @return	null
	 **/
	public function __construct($default_lang) {

		# Appel du constructeur de la classe plxPlugin (obligatoire)
		parent::__construct($default_lang);
		
		# Autorisation d'acces à la configuration du plugin
		$this->setConfigProfil(PROFIL_ADMIN, PROFIL_MANAGER, PROFIL_MODERATOR);
		$this->setAdminProfil(PROFIL_ADMIN, PROFIL_MANAGER, PROFIL_MODERATOR);
		//$this->checkProfil();
		$this->setAdminMenu($this->getlang('L_NNF_FORUM_MANAGEMENT'), '1', $this->getlang('L_NNF_FORUM_MANAGEMENT'));	

		$this->nnforum = new nnforum();

		# déclaration des hooks
		$this->addHook('AdminTopBottom', 'AdminTopBottom');
		$this->addHook('AdminTopEndHead', 'AdminTopEndHead');
		if(plxUtils::checkMail($this->getParam('email_to'))) {
			$this->addHook('plxMotorPreChauffageBegin', 'plxMotorPreChauffageBegin');
			$this->addHook('plxShowConstruct', 'plxShowConstruct');
			$this->addHook('plxShowStaticListEnd', 'plxShowStaticListEnd');
			$this->addHook('plxShowPageTitle', 'plxShowPageTitle');
			$this->addHook('ThemeEndHead', 'ThemeEndHead');
			$this->addHook('SitemapStatics', 'SitemapStatics');
			$this->addHook('plxShowNNForum', 'plxShowNNForum');
		}
	}

	/**
	 * Méthode de traitement du hook plxShowConstruct
	 **/
	public function plxShowConstruct() {
			
		# infos sur la page statique
		$string  = "if(\$this->plxMotor->mode=='nnforum') {";
		$string .= "	\$array = array();";
		$string .= "	\$array[\$this->plxMotor->cible] = array(
			'name'		=> '".addslashes($this->getParam('forum_name'))."',
			'menu'		=> '',
			'url'		=> 'nnforum',
			'readable'	=> 1,
			'active'	=> 1,
			'group'		=> ''
		);";
		$string .= "	\$this->plxMotor->aStats = array_merge(\$this->plxMotor->aStats, \$array);";
		$string .= "}";
		echo "<?php ".$string." ?>";
	}

	/**
	 * Méthode de traitement du hook plxMotorPreChauffageBegin
	 **/
	public function plxMotorPreChauffageBegin() {

		$template = $this->getParam('template')==''?'static.php':$this->getParam('template');
		$string = "
		if(\$this->get && preg_match('/^nnforum\/?/',\$this->get)) {
			\$this->mode = 'nnforum';
			\$this->cible = '../.".(defined('PLX_MYMULTILINGUE')?'./.':'').PLX_PLUGINS."plxNNForum/form';
			\$this->template = '".$template."';
			return true;
		}
		";

		echo "<?php ".$string." ?>";
	}	

	/**
	 * Méthode de traitement du hook plxShowStaticListEnd
	 **/
	public function plxShowStaticListEnd() {

		# ajout du menu pour accèder à la page de nnforum
		if($this->getParam('forum_menu') == 'true') {
			echo "<?php \$class = \$this->plxMotor->mode=='nnforum'?'active':'noactive'; ?>";
			echo "<?php array_splice(\$menus, ".($this->getParam('forum_menu_pos')-1).", 0, '<li><a class=\"static '.\$class.'\" href=\"'.\$this->plxMotor->urlRewrite('?nnforum').'\" title=\"".addslashes($this->getParam('forum_menu_name'))."\">".addslashes($this->getParam('forum_menu_name'))."</a></li>'); ?>";
		}

	}

	/**
	 * Méthode qui charge le code css nécessaire pour l'affichage admin
	 *
	 * @return	stdio
	 * @author	Stephane F
	 **/	
	public function AdminTopEndHead() {
		echo "\n\t".'<script type="text/javascript" src="'.PLX_PLUGINS.'plxNNForum/js/jscolor/jscolor.js"></script>';
	}
	
	/**
	 * Méthode qui ajoute le fichier css et js dans le fichier header.php du thème
	 **/
	public function ThemeEndHead() {
		echo "\n\t".'<link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.'plxNNForum/css/nnforum.css" media="screen" />'."\n";
		echo "\n\t".'<script type="text/javascript" src="'.PLX_PLUGINS.'plxNNForum/js/fluidvids.js"></script>'."\n";
		echo "\n\t".'<script type="text/javascript" src="'.PLX_PLUGINS.'plxNNForum/js/nnforum.js"></script>'."\n";
	}

	/**
	 * Méthode qui rensigne le titre de la page dans la balise html <title>
	 **/
	public function plxShowPageTitle() {
		echo '<?php
			if($this->plxMotor->mode == "nnforum") {
				echo plxUtils::strCheck("'.$this->getParam('forum_name').' - ".$this->plxMotor->aConf["title"]);
				return true;
			}
		?>';
	}	

	/**
	 * Méthode qui référence la page de nnforum dans le sitemap
	 **/
	public function SitemapStatics() {
		echo '<?php
		echo "\n";
		echo "\t<url>\n";
		echo "\t\t<loc>".$plxMotor->urlRewrite("?nnforum")."</loc>\n";
		echo "\t\t<changefreq>monthly</changefreq>\n";
		echo "\t\t<priority>0.8</priority>\n";
		echo "\t</url>\n";
		?>';
	}

	/**
	 * Méthode qui affiche un message si l'adresse email du nnforum n'est pas renseignée
	 **/
	public function AdminTopBottom() {

		echo '<?php
		if($plxAdmin->plxPlugins->aPlugins["plxNNForum"]->getParam("email_to")=="") {
			echo "<p class=\"warning\">Plugin NNForum<br />'.$this->getLang("L_NNF_ERR_EMAIL").'</p>";
			plxMsg::Display();
		}
		?>';
	}	

	/**
	 * Méthode qui affiche les derniers X posts
	 **/
	public function plxShowNNForum() {
		$plxShow = plxShow::getInstance();
		$plxPlugin = $plxShow->plxMotor->plxPlugins->getInstance('plxNNForum');
		$latestfeeds = $plxPlugin->nnforum->latestFeed($this->getParam('feed_nb'));
		$html  = '<div id="lastfeeds">';
		$html .= '<h3><span class="title-forum"><a href="index.php?nnforum" title="'.$this->getParam('feed_name').'">'.$this->getParam('feed_name').'</a></span></h3>';
		if (!empty($latestfeeds)) {
			$i=0;
			foreach($latestfeeds as $feed) {
				$link = $plxPlugin->nnforum->my_simple_crypt(str_replace('&','@',str_replace(plxUtils::getRacine().substr(PLX_PLUGINS,2),'', $feed->link)), 'e');

				$html .= '<p class="ligne-'.($i %2).'"><span class="thread">'.$feed->thread.'</span>'.(!empty($feed->thread) ? ' - ' : '').'<span class="subject">'.$this->getLang('L_NNF_SHOW_SUBJECT').' : </span><span class="title"><a href="'.PLX_PLUGINS.'plxNNForum/nnforum.php?url='.$link.'" title="'.$feed->title.'">'.$feed->title.'</a></span><br>
				<span class="description">'.strip_tags($feed->description).'</span><br>
				<span class="autor">'.date ("d/m/y @ H:i", strtotime ($feed->modDate)).' (par '.$feed->modAuthor.')</span></p>';
				$i++;
			}
		} else {
			$html .= $this->getLang('L_NNF_SHOW_NOFEEDS');
		}
		$html .= '</div>';
		echo $html;
	}
}