<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://dpfpic.com
 * Licence GNU_GPL
 **/
 
class nnforum {

	/**
	 * Cre un nom unique pour les utilisateurs
	 *
	 * @return	dir
	 * @author	DPFPIC
	 **/
	public function DirUniq() {
		$dir = md5(uniqid(rand(), true));
		return $dir;
	}

	/**
	 * Liste des themes
	 *
	 * @param	dir				le rpertoire
	 * @return	array()
	 * @author	DPFPIC
	 **/	
	public function dir_list($dir, $patern='*'){	
		$tab = array();
		$name = array();
		if (is_dir($dir)) {
			if ($dh = opendir($dir)) {
				while (($file = readdir($dh)) !== false) {
					$ext=explode('.',$file);
					$ext=$ext[count($ext)-1];
					if($ext==$patern || $patern=="*" && $file!='.' && $file!='..' && $file!='index.html' && $file!='theme.config.php'){
						$tab[$file]= $file;
					}
				}
				closedir($dh);
			}
		}
		sort($tab);
		foreach($tab as $k=>$v)
			$name[$v] = $v;

		return $name;
	}

	/**
	 * Liste des sous forum
	 *
	 * @param	dir				le rpertoire du sous forum
	 * @param   dirusers		rpertoire de scurit des utilisateurs
	 * @return	array()
	 * @author	DPFPIC
	 **/	
	public function subforun($dir, $dirusers) {	
		$name = array();
		$files = scandir($dir);
		$files_n = count($files);
		$i=0;
		while($i < $files_n){
			// "is_dir" only works from top directory, so append the $dir before the file
			if (is_dir($dir/*.'/'*/.$files[$i])){   
				$MyFileType[$i] = $files[$i] ;
			} 
			$i++;
		}
		$MyFileType = preg_grep ('/^(\.|'.$dirusers.'$|themes$|lib$|lang$|bbcode$|cgi-bin$)/', $MyFileType, PREG_GREP_INVERT);
		foreach(array_filter($MyFileType) as $k=>$v)
			$name[$v] = $v;
		if (is_array($name)) {
			return array_filter($name);
		}
	}

	/**
	 * Supprimer un rpertoire et son contenu
	 *
	 * @param	dir				le rpertoire  supprimer
	 * @return	NULL
	 * @author	DPFPIC
	 **/	
	public function rrmdir($dir) { 
		if (is_dir($dir)) { 
			$objects = scandir($dir); 
			foreach ($objects as $object) { 
				if ($object != "." && $object != "..") { 
					if (filetype($dir."/".$object) == "dir") rrmdir($dir."/".$object); else unlink($dir."/".$object); 
				} 
			} 
		reset($objects); 
		rmdir($dir); 
		} 
	} 

	/**
	 * Affiche les x derniers posts
	 *
	 * @param	nb				nombre de posts
	 * @return	array()
	 * @author	DPFPIC
	 **/
	public function latestFeed($nb) {
		$feeds = array();
		$index = glob(PLX_PLUGINS.'plxNNForum/forum/index.xml',GLOB_BRACE);
		$index_sub = glob(PLX_PLUGINS.'plxNNForum/forum/*/index.xml',GLOB_BRACE);
		$index_glob = array_merge($index, $index_sub);
		foreach ($index_glob as $filename) {
			$feeds[] = $filename;
		}
		//================================
		// Get all feed entries
		$entries = array();
		foreach ($feeds as $feed) {
			$xml = simplexml_load_file($feed);
			$entries = array_merge($entries, $xml->xpath('/rss//item'));
		}

		// Sort feed entries by modDate (descending)
		usort($entries, function ($x, $y) {
			return strtotime($y->modDate) - strtotime($x->modDate);
		});

		//================================
		foreach (array_slice($entries,0,$nb) as $entry){
			$entry->description = strip_tags( $entry->description );
			$entry->description = $this->cutString($entry->description, 0, 100, ' ...');
			$latest[]=$entry;
		}
		if(isset($latest)){
			return $latest;
		}	
	}

	/**
	 * Moteur de recherche
	 *
	 * @param	word				mot de recherche
	 * @return	array()
	 * @author	DPFPIC
	 **/
	public function searchNNF($word) {
	    $word = trim($word);
		$feeds = array();
		$index = glob(PLX_PLUGINS.'plxNNForum/forum/*.rss',GLOB_BRACE);
		$index_sub = glob(PLX_PLUGINS.'plxNNForum/forum/*/*.rss',GLOB_BRACE);
		$index_glob = array_merge($index, $index_sub);
		foreach ($index_glob as $filename) {
			$feeds[] = $filename;
		}
		//================================
		// Get all feed entries
		$entries = array();
		foreach ($feeds as $feed) {
			$xml = simplexml_load_file($feed);
			$entries = array_merge($entries, $xml->xpath('/rss/channel/item'));
		}

		//Sort feed entries by modDate (descending)
		usort($entries, function ($x, $y) {
			return strtotime($y->modDate) - strtotime($x->modDate);
		});

		//================================
		$author = false;
		$title = false;
		$description = false;
		foreach ($entries as $entry){
			$description_html = htmlspecialchars($entry->description, ENT_QUOTES);
			$author_ = strpos(strtolower($entry->author), strtolower($word));
			$title_ = strpos(strtolower($entry->title), strtolower($word));
			$description_ = strpos(strtolower($entry->description), strtolower($word));
 			if($author_ !== false){
			    $author = true;
			} elseif ($title_ !== false){
				$title = true;
			} elseif ($description_ !== false){
				$description = true;
			}

			if ($author OR $title OR $description) {
				$entry->description = strip_tags( $entry->description );
				$entry->description = $this->cutString($entry->description, 0, 100, ' ...');
				$latest[] = $entry;
				$author = false;
				$title = false;
				$description = false;
			}
		}
		
		if(!isset($latest)){
			return $latest = array();
		}
		return $latest;
	}

	public function cutString($string, $start, $length, $endStr = '[&hellip]'){
		if( strlen( $string ) <= $length ) return $string;
			$str = mb_substr( $string, $start, $length - strlen( $endStr ) + 1, 'UTF-8');
		return substr( $str, 0, strrpos( $str,' ') ).$endStr;
	}	
	
	public function my_simple_crypt( $string, $action = 'e' ) {
		// you may change these values to your own
		$secret_key = 'h4ry4cjr78td';
		$secret_iv = '5r4fu4z8t2c5';
 
		$output = false;
		$encrypt_method = "AES-256-CBC";
		$key = hash( 'sha256', $secret_key );
		$iv = substr( hash( 'sha256', $secret_iv ), 0, 16 );
 
		if( $action == 'e' ) {
			$output = base64_encode( openssl_encrypt( $string, $encrypt_method, $key, 0, $iv ) );
		}
		else if( $action == 'd' ){
			$output = openssl_decrypt( base64_decode( $string ), $encrypt_method, $key, 0, $iv );
		}
 
		return $output;
	}

	public function getPage() {

		# Initialisation
		$pageName = basename($_SERVER['PHP_SELF']);
		$savePage = preg_match('/admin\/(index|plugin).php/', $_SERVER['PHP_SELF']);
		# On check pour avoir le numero de page
		if(!empty($_GET['page']) AND is_numeric($_GET['page']) AND $_GET['page'] > 0)
			$this->page = $_GET['page'];
		elseif($savePage) {
			if(!empty($_POST['sel_cat']))
				$this->page = 1;
			else
				$this->page = !empty($_SESSION['page'][$pageName])?intval($_SESSION['page'][$pageName]):1;
		}
		# On sauvegarde
		if($savePage) $_SESSION['page'][$pageName] = $this->page;
	}	
	
	public function getPagefront() {

		# Initialisation
		$pageName = basename($_SERVER['PHP_SELF']);
		$savePage = preg_match('/\/(index|plugin).php/', $_SERVER['PHP_SELF']);
		# On check pour avoir le numero de page
		if(!empty($_GET['page']) AND is_numeric($_GET['page']) AND $_GET['page'] > 0)
			$this->page = $_GET['page'];
		elseif($savePage) {
			if(empty($_GET['page']))
				$this->page = 1;
			else
				$this->page = !empty($_SESSION['page'][$pageName])?intval($_SESSION['page'][$pageName]):1;
		}
		# On sauvegarde
		if($savePage) $_SESSION['page'][$pageName] = $this->page;
	}		
	
	public function Pagination($nbPagination,$bypage) {
	
		$plxMotor = plxMotor::getInstance();
		$this->getPageFront();
	
		# Calcul des pages
		$last_page = ceil($nbPagination/$bypage);
		if($this->page > $last_page) $this->page = $last_page;
		$prev_page = $this->page - 1;
		$next_page = $this->page + 1;
		# Generation des URLs
		$f_url = $plxMotor->urlRewrite('index.php?nnforum&page=1'); # Premiere page
		$p_url = $plxMotor->urlRewrite('index.php?nnforum&page='.$prev_page); # Page precedente
		$n_url = $plxMotor->urlRewrite('index.php?nnforum&page='.$next_page); # Page suivante	
		$l_url = $plxMotor->urlRewrite('index.php?nnforum&page='.$last_page); # Derniere page	
		# On effectue l'affichage
		if($this->page > 2) # Si la page active > 2 on affiche un lien 1ere page
			echo '<span class="p_first"><a href="'.$f_url.'" title="'.ucfirst(L_PAGINATION_FIRST_TITLE).'">'.ucfirst(L_PAGINATION_FIRST).'</a>&nbsp;</span>';
		if($this->page > 1) # Si la page active > 1 on affiche un lien page precedente
			echo '<span class="p_prev"><a href="'.$p_url.'" title="'.ucfirst(L_PAGINATION_PREVIOUS_TITLE).'">'.ucfirst(L_PAGINATION_PREVIOUS).'</a>&nbsp;</span>';
		# Affichage de la page courante
		printf('<span class="p_page">'.ucfirst(L_PAGINATION).'</span>',$this->page,$last_page);
		if($this->page < $last_page) # Si la page active < derniere page on affiche un lien page suivante
			echo '<span class="p_next">&nbsp;<a href="'.$n_url.'" title="'.ucfirst(L_PAGINATION_NEXT_TITLE).'">'.ucfirst(L_PAGINATION_NEXT).'</a></span>';
		if(($this->page + 1) < $last_page) # Si la page active++ < derniere page on affiche un lien derniere page
			echo '<span class="p_last">&nbsp;<a href="'.$l_url.'" title="'.ucfirst(L_PAGINATION_LAST_TITLE).'">'.ucfirst(L_PAGINATION_LAST).'</a></span>';
	}	
	
	/**
	 * Rcupre les noms de utilisateurs
	 *
	 * @param	filename				chemin et non du fichier
	 * @return	array()
	 * @author	DPFPIC
	 **/
	public function file_get_json($filename) {
		$json = '';
		$json = @file_get_contents($filename); 
		$json = utf8_encode($json); 
		$list = json_decode($json); 
		return $list;
	}

	/**
	 * renregistre les noms de utilisateurs
	 *
	 * @param	filename				chemin et non du fichier
	 * @param	contents				list des utilisateurs	 
	 * @return	array()
	 * @author	DPFPIC
	 **/
	public function file_put_json($filename, $contents) {
		$string = '';
		$string = json_encode($contents);
		@file_put_contents($filename, $string, LOCK_EX);
	}

	/**
	 * Verification des version des plugins
	 *
	 * @param	plugin				le nom du plugin
	 * @return	array()
	 * @author	DPFPIC
	 **/
	public function UpdatePlugin($plugin) {
	    $array = array();
		$url = 'http://dpfpic.com/plugins.rep';
		$filename = PLX_PLUGINS.$plugin.'/infos.xml';
		
		# Mise en place du parseur XML
		$data = implode('',file($filename));
		$parser = xml_parser_create('UTF-8');
		xml_parser_set_option($parser,XML_OPTION_CASE_FOLDING,0);
		xml_parser_set_option($parser,XML_OPTION_SKIP_WHITE,0);
		xml_parse_into_struct($parser,$data,$strings,$iTags);
		xml_parser_free($parser);
		# Rcupration des donnes xml
		$array['actualversion'] = plxUtils::getValue($strings[$iTags['version'][0]]['value']);
		$array['actualdate'] = plxUtils::getValue($strings[$iTags['date'][0]]['value']);

		if (ini_get('allow_url_fopen')) {
			$handleplugin = @file($url);
		}
		elseif ($curl = @curl_init()){
			$timeout = 5; // set to zero for no timeout
			curl_setopt ($curl, CURLOPT_URL, $url);
			curl_setopt ($curl, CURLOPT_CONNECTTIMEOUT, $timeout);
			curl_setopt ($curl, CURLOPT_RETURNTRANSFER, 1);
			$version_content = curl_exec($curl);
			curl_close($curl);
			if ($version_content != false) {
				$handleplugin = explode("\n", $version_content);
			}
		}
		if ($handleplugin) {
			$nb = sizeof($handleplugin);
			for($i=0;$i<$nb;$i++) {
				$seach = strstr($handleplugin[$i], '||', true);
				if ($seach == $plugin) {
				    $value = explode('||', $handleplugin[$i]);
					$array['newplugin'] = $value[0];
					$array['newversion'] = $value[1];
					$array['newdate'] = $value[2];
					$array['newurl'] = $value[3];
					$array['active'] = $value[4];
				}
			}
		} else {
			$array ['status'] = 0;
		}

		$adate = explode("/", $array['actualdate']); 
		$ndate = explode("/", $array['newdate']);
		$actualdate = $adate[2].$adate[1].$adate[0];
		$newdate = $ndate[2].$ndate[1].$ndate[0];

		if (isset($array['actualversion']) AND ($array['actualversion'] == $array['newversion']  AND  $actualdate == $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 1;
		} elseif (isset($array['actualversion']) AND ($array['actualversion'] != $array['newversion'] OR  $actualdate != $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 2;
		} elseif (isset($array['active']) AND $array['active'] == 0) {
			$array ['status'] = 3;
		} else {
			$array ['status'] = 0;
		}
		return $array;
	}
}	