<?php //translation file
/* ====================================================================================================================== */
/* NoNonsense Forum v26 © Copyright (CC-BY) Kroc Camen 2010-2015
   licenced under Creative Commons Attribution 3.0 <creativecommons.org/licenses/by/3.0/deed.en_GB>
   you may do whatever you want to this code as long as you give credit to Kroc Camen, <camendesign.com>
*//*

how to create a theme translation:
----------------------------------
1.      determine the standard language code to use, e.g. "en" (or "en-GB", "en-US" …), "de", "es" etc.
        Read this document on how to choose a language code:
        http://www.w3.org/International/questions/qa-choosing-language-tags
        
2.      make a copy of 'lang.example.php' and rename as 'lang.en.php' where "en" is the language code for your translation
        (do not rename, modify or delete 'lang.example.php')

3.      if you have not already, make a copy of 'theme.config.default.php' and rename it to 'theme.config.php'.
        within that file add your language code, separated from any other languages by a space, to the `THEME_LANGS`
        option; this will tell NNF that your language is available to use and will add it to the theme's language selector

4.      translate the text within your lang file. please note that all text is HTML.
        you can preview as you go by selecting your new language when running NNF

*/

//name of the language, as the user will use to select it;
//therefore should be the name of the language, written in that language - i.e. "Espanol" (Spanish)
$LANG['fr']['name']             = 'Français';

//the `date` format code used to print human readable dates into the HTML,
//see <php.net/manual/en/function.date.php> for documentation
$LANG['fr']['date_format']      = 'd/m/y H:i';

//the following template replacements are done using `sprintf`,
//see <php.net/manual/en/function.sprintf.php> for details

//the HTML title for index and thread pages
//"%1$s" - the title
//"%2$s" - if on page 2 or greater, `THEME_TITLE_PAGENO` will be inserted here, otherwise it will be removed
$LANG['fr']['title']            = '%1$s%2$s';

//the page number, added to the titles of index pages and threads
//"%1$u" - the page number
$LANG['fr']['title_pagenum']    = ' + %1$u';

//the title for append pages
//"%1$s" - the post title (will come from `THEME_RE` for replies)
$LANG['fr']['title_append']     = 'Append to %1$s';

//the title for delete pages
//"%1$s" - the post title (will come from `THEME_RE` for replies)
$LANG['fr']['title_delete']     = 'Supprimer %1$s?';

//reply number shown in threads as a permalink
//"%1$u" - the number of the reply
$LANG['fr']['replynum']         = '#%1$u.';

//title format for each reply
//"%1$u" - number of the reply
//"%2$s" - the thread title
$LANG['fr']['re']               = 'RE[%1$u]: %2$s';

//text used when appending to a post:
//(markup can be used as this is run through `formatText`)
//"%1$s" - username of who posted
//"%2$s" - human-readable time, as per `DATE_FORMAT`
$LANG['fr']['appended']         = ':: @%1$s Ajouté à %2$s';

//HTML that replaces a post when it's deleted (this is not retroactive)
$LANG['fr']['delete_user']      = '<p>Cette publication a été supprimée par son propriétaire</p>';
$LANG['fr']['delete_mod']       = '<p>Cette publication a été supprimée par un modérateur</p>';

//HTML used to replace an invalid post:
$LANG['fr']['corrupt']          = '<p>Cette publication est corrompue et ne peut pas être affichée</p>';

//text use to send email to administrator
$LANG['fr']['subject']			= 'Réponse à la discussion';
$LANG['fr']['subject_thread']	= 'Nouvelle discussion';
$LANG['fr']['content_1']		= 'a répondu à la discussion';
$LANG['fr']['content_thread_1']	= 'a créé une nouvelle discussion';
$LANG['fr']['content_2']		= 'Contenu du message';
$LANG['fr']['content_thread_2']	= 'Description de la discussion';

//text for login
$LANG['fr']['username']			= 'Nom';
$LANG['fr']['password']			= 'Mot de passe';
$LANG['fr']['signin']			= 'Se connecter';
$LANG['fr']['error_signin']		= 'Vous avez indiqué un mot de passe incorrect. Vérifiez votre mot de passe et réessayez.';

//the translation strings
$LANG['fr']['strings']          = array (

/* xpath/shorthand:                     replacement text:                       description:
   ====================================================================================================================== */
/* site header
   ---------------------------------------------------------------------------------------------------------------------- */
//search box
 '#query@placeholder'                   => 'Rechercher…'                     //default text shown in search box
,'#go@alt'                              => 'Cherche'                             //search submit button

//breadcrumb
,'#index/li[1]/a'                       => 'Accueil'                              //breadcrumb root location

/* index page
   ---------------------------------------------------------------------------------------------------------------------- */
,'#nnf_index'							=> 'Accueil forum'
,'#nnf_back'							=> 'Retour au site'
,'.nnf_signed-in'						=> 'Inscrit en tant que'

//list of sub-forums
,'#nnf_folders/h1'                      => 'Sous-Forums'                         //section title
,'.nnf_lock-threads@alt, '.
 '.nnf_lock-threads@title'              => 'Réponses uniquement:'               //alt+title of lock-icon, if thread-locked
,'.nnf_lock-posts@alt, '.
 '.nnf_lock-posts@title'                => 'Lecture seulement:'                 //alt+title of lock-icon, if post-locked

//navigation links
,'#nnf_add'                             => 'Ajouter une discussion'                         //the "add thread" link in 'index.html'
,'#nnf_reply'                           => 'Répondre'                              //the "reply" link in 'thread.html'
,'#nnf_rss'                             => 'RSS'                                //the RSS link in the header

// BBCode
,'.addbbcode0@title'					=> 'Texte gras : [b]texte[/b]'
,'.addbbcode2@title'					=> 'Texte italique : [i]texte[/i]'
,'.addbbcode4@title'					=> 'Texte souligné : [u]texte[/u]'
,'.addbbcode6@title'					=> 'Citation : [quote]texte[/quote]'
,'.addbbcode8@title'					=> 'Code : [code]code[/code]'
,'.addbbcode14@title'					=> 'Texte à gauche : [left]texte[/left]'
,'.addbbcode16@title'					=> 'Texte centré : [center]texte[/center]'
,'.addbbcode18@title'					=> 'Texte à droite : [right]texte[/right]'
,'#closed'								=> <<<HTML
<input type="button" class="button" name="closed" value="Résolu" title="Résolu" alt="Résolu" onclick="addSmiley('[b][color=green]Résolu.[/color][/b]','','smiley'); return false;">
HTML
,'#select20'							=> <<<HTML
<select name="addbbcode20" class="addbbcode20" onchange="bbfontstyle('[size=' + this.form.addbbcode20.options[this.form.addbbcode20.selectedIndex].value + ']', '[/size]');this.form.addbbcode20.selectedIndex = 2;" title="'Taille de la police : [size=100]texte[/size]'">
					<option value="50">Très petite</option>
					<option value="85">Petite</option>
					<option value="100" selected="selected">Normale</option>
					<option value="150">Grande</option>
					<option value="200">Très grande</option>
				</select>
HTML
,'#select21'							=> <<<HTML
				<select name="addbbcode21" class="addbbcode21" onchange="bbfontstyle('[font=' + this.form.addbbcode21.options[this.form.addbbcode21.selectedIndex].value + ']', '[/font]');this.form.addbbcode21.selectedIndex = 2;" title="Type de la police : [font=courrier]texte[/font]">
					<option value="arial">Arial</option>
					<option value="courrier">Courrier</option>
					<option value="" selected="selected">Defaut</option>
					<option value="sans-serif">Sans-serif</option>
					<option value="helvetica">Helvetica</option>
				</select>
HTML
,'#select22'							=> <<<HTML
				<select name="addbbcode22" class="addbbcode22" onchange="bbfontstyle('[color=' + this.form.addbbcode22.options[this.form.addbbcode22.selectedIndex].value + ']', '[/color]');this.form.addbbcode22.selectedIndex = 2;" title="Couleur du texte : [color=black]texte[/color]">
					<option value="red">Rouge</option>
					<option value="blue">Bleu</option>
					<option value="" selected="selected">Defaut</option>
					<option value="black">Noir</option>
					<option value="white">Blanc</option>
					<option value="green">Vert</option>
				</select>	
HTML

//access rights
,'#nnf_forum-lock-threads'              => <<<HTML
        Seuls <a href="#mods">les modérateurs ou les membres</a> peuvent commencer de nouvelles discussions ici, mais <em>n'importe qui</em> peut répondre aux discussions existantes.
HTML
,'.nnf_reply-last'    	                => <<<HTML
        Dernière modification par
HTML
,'#nnf_forum-lock-posts'                => <<<HTML
        Seuls <a href="#mods">les modérateurs ou les membres</a> peuvent participer ici.
        Connectez vous si vous êtes un modérateur ou un membre afin de poster.
HTML

//list of threads
,'#nnf_threads/h1'                      => 'Discussions'
,'.nnf_thread-locked@alt, '.
 '.nnf_thread-locked@title'             => 'Fermé:'

,'#nnf_new-form/h1'                     => 'Ajouter une discussion'                         //add thread form title
,'#nnf_new-form/form/p/'.
 'label@for="submit"/span'              => 'Envoyer'                             //form submit button

/* thread page
   ---------------------------------------------------------------------------------------------------------------------- */
,'#nnf_post-append, #nnf_post-append, '.
 '.nnf_reply-append, .nnf_reply-append' => 'Editer'                             //"append" link in posts
,'#nnf_post-delete, #nnf_post-delete, '.
 '.nnf_reply-delete, .nnf_reply-delete' => 'Supprimer'                             //"delete" link in posts

,'.nnf_forum-locked'                    => <<<HTML
		Seuls <a href="#mods">les modérateurs ou les membres</a> peuvent répondre à cette discussion. Connectez vous si vous êtes un modérateur ou un membre afin de publier.
HTML

,'#nnf_replies/h1'                      => 'Réponses'                            //title for replies list

,'#nnf_reply-form/h1'                   => 'Répondre'                              //reply form title
,'#nnf_reply-form/form/p/'.
 'label@for="submit"/span'              => 'Répondre'                              //form submit button

/* append page
   ---------------------------------------------------------------------------------------------------------------------- */
,'#append/h1'                           => 'Editer'                             //append form title
,'#append/form/p/'.
 'label@for="submit"/span'              => 'Valider'                             //form submit button

/* delete page
   ---------------------------------------------------------------------------------------------------------------------- */
,'#delete/h1'                           => 'Supprimer'                             //delete form title

,'label@for="remove"/span'              => 'Supprimer complètement (modérateurs seulement)'
,'#nnf_remove/ul/li[1]'                 => 'Le message sera complètement supprimé de la discussion, plutôt que d\'être fermé<br>Seuls les messages sur la dernière page de la discussion peuvent être supprimés complètement (afin de ne pas interrompre les permalinks)'

,'#delete/form/p/'.
 'label@for="submit"/span'              => 'Supprimer'                             //form submit button

/* input forms
   ---------------------------------------------------------------------------------------------------------------------- */
,'label@for="nnf_title-field"'          => 'Titre:'                                    //title field label
,'#nnf_title-field@placeholder'         => 'Tapez le titre de la discussion ici…'      //placeholder text for the title field

,'label@for="nnf_name-field-http"'      => 'Vous êtes connecté en tant que:'           //label for name field if HTTP_AUTH
,'label@for="nnf_name-field"'           => 'Nom:'                                      //name field label
,'#nnf_name-field@placeholder'          => 'Votre nom'                                 //placeholder text for the name field

,'label@for="nnf_pass-field"'           => 'Mot de passe:'                             //label for password field
,'#nnf_pass-field@placeholder'          => 'Mot de passe à conserver'                  //placeholder text for the password field

,'label@for="nnf_captcha-field"'        => 'Anti-spam:'                				   //label for captcha field
,'#nnf_captcha-field@placeholder'       => 'Entrer le code de sécurité'                //placeholder text for the captcha field

,'#nnf_error-none'                      => <<<HTML
                        <!-- this is shown by default as long as new users aren't disabled and the user isn't signed in -->
                        Il n'est pas nécessaire de "s'inscrire", il suffit d'entrer le même nom + mot de passe de votre choix à chaque fois.
HTML
,'#nnf_error-none-append'               => <<<HTML
                        <!-- this is shown by default as long as new users aren't disabled and the user isn't signed in -->
                        Seul l'auteur original ou un modérateur peut modifer cette publication.
HTML
,'#nnf_info-none-append'                => <<<HTML
                        <!-- this is shown by default as long as new users aren't disabled and the user isn't signed in -->
                        Seul l'auteur original ou un modérateur peut modifer cette publication.
HTML
,'#nnf_error-none-thread'               => <<<HTML
                        Pour supprimer cette discussion, et toutes les réponses associer, vous devez être soit l'auteur original<br>
                        ou un modérateur désigné.
HTML
,'#nnf_error-none-reply'                => <<<HTML
                        Pour supprimer cette publication, vous devez être l'auteur original ou un modérateur désigné.<br>
                        Le contenu de la publication sera supprimé mais le nom et la date resteront.
HTML
,'#nnf_error-newbies'                   => <<<HTML
                        <!-- if the `FORUM_NEWBIES` option is false, only existing users can post -->
                        Seuls les utilisateurs enregistrés peuvent publier. Aucune nouvelle inscription n'est autorisée.
HTML
,'#nnf_error-title'                     => <<<HTML
                        Vous devez entrer le titre de votre nouvelle discussion.
HTML
,'#nnf_error-name'                      => <<<HTML
                        Entrez un nom. Vous devrez l'utiliser avec le mot de passe à chaque fois.
HTML
,'#nnf_error-name-append'               => <<<HTML
                        Entrez le nom de l'auteur original ou d'un modérateur pour pouvoir ajouter cette réponse.
HTML
,'#nnf_error-name-delete'               => <<<HTML
                        Entrez le nom de l'auteur original ou d'un modérateur pour pouvoir supprimer.
HTML
,'#nnf_error-pass'                      => <<<HTML
                        Entrer un mot de passe. C'est pour que vous puissiez réutiliser votre nom à chaque fois.
HTML
,'#nnf_error-pass-append'               => <<<HTML
                        Entrez le mot de passe pour l'auteur original ou un modérateur pour pouvoir ajouter cette réponse
HTML
,'#nnf_error-pass-delete'               => <<<HTML
                        Entrez le mot de passe pour l'auteur original ou un modérateur pour pouvoir supprimer.
HTML
,'#nnf_error-captcha'                   => <<<HTML
                        Code de sécurité incorrect.
HTML
,'#nnf_error-captcha-append'            => <<<HTML
                        Code de sécurité incorrect.
HTML
,'#nnf_error-text'                      => <<<HTML
                        Eh bien, écrivez un message!nnf_error-user
HTML
,'#nnf_error-user'                      => <<<HTML
                        Utilisateur non autorisé.
HTML
,'#nnf_error-auth'                      => <<<HTML
                        Ce nom est pris. Indiquez le mot de passe ou choisissez un autre nom. (Erreur de mot de passe?).
HTML
,'#nnf_error-auth-append'               => <<<HTML
                       Vous devez entrer le nom et le mot de passe de l'auteur original, ou un modérateur désigné.
HTML
,'#nnf_error-none-name'       	        => <<<HTML
                       Vous devez entrer le nom et le mot de passe de l'auteur original, ou un modérateur désigné.
HTML
,'#nnf_error-auth-delete'               => <<<HTML
                        Le nom de compte et / ou le mot de passe sont incorrects.
HTML
,'#nnf_error-delete'          		     => <<<HTML
                        Vous devez entrer le nom et le mot de passe de l'auteur original, ou un modérateur désigné.
HTML
,'#nnf_error-captcha-delete'            => <<<HTML
                        Code de sécurité incorrect.
HTML
,'#protip'                              => <<<HTML
                        Information : Utilisation de <a href="markup.php">l'aide</a> pour ajouter des liens, des citations et plus.
HTML

,'label@for="nnf_text-field"'           => 'Message:'
,'#nnf_text-field@placeholder'          => 'Tapez votre message ici…'

/* markup page
   ---------------------------------------------------------------------------------------------------------------------- */
//the markup documentation:
,'/html[@class="markup"]/head/title'    => 'Aide'
,'#markup'                              => <<<HTML

<h1>Aide</h1>
<article>
<header>
<ol>
        <li><a href="#links">» Liens</a></li>
        <li><a href="#names">» Noms</a></li>
        <li><a href="#bolditalic">» Gras &amp; italique</a></li>
		<li><a href="#align">» Aligner texte</a></li>
		<li><a href="#color">» Couleur</a></li>
		<li><a href="#typefont">» Type police</a></li>
		<li><a href="#sizefont">» Taille police</a></li>
        <li><a href="#titles">» Titres</a></li>
        <li><a href="#dividers">» Séparateurs</a></li>
        <li><a href="#quotes">» Citations</a></li>
        <li><a href="#pre">» Code</a></li>
</ol>
</header>
        
<h2 id="links">Liens:</h2>
<p>
        Les liens cliquables seront créés automatiquement sur toutes les adresses Web de votre texte qui commencent par
        "<samp>http://</samp>", "<samp>https://</samp>", "<samp>ftp://</samp>" or "<samp>irc://</samp>".
        En outre, les adresses e-mail seront transformées en liens cliquables pour vous.
</p>
<pre>
OUI:    http://www.google.com
NON:     www.google.com
OUI:    email@email.com
</pre>

<h2 id="names">Noms:</h2>
<p>
        Vous pouvez vous référer à une autre personne en précisant leur nom avec un symbole at. Par exemple, "<samp>@bob</samp>" Le nom sera lié à la dernière réponse faite par cette personne dans le fil de discussion actuel.
</p>

<h2 id="bolditalic">Bold &amp; Italic</h2>
<pre>
[b]Écrivez un texte en gras comme celui-ci[/b], et [i]texte italique comme ceci[/i].
</pre>

<h2 id="align">Aligner texte</h2>
<p>
		Vous pouvez utiliser left, right, center pour positinner votre texte.
</p>
<pre>
[left]Votre texte[/left]
[center]Votre texte[/center]
[right]Votre texte[/right]
</pre>

<h2 id="color">Couleurs</h2>
<p>
		Vous pouvez utiliser vos propres codes de couleur par exemple : #F14E23 our red.
</p>
<pre>
[color=code_couleur]Votre texte en couleur[/color]
</pre>

<h2 id="typefont">Type police</h2>
<p>
		Vous pouvez utiliser plusieur type de polices : Arial, Courrier, Sans-serif, Helvetica.
</p>
<pre>
[font=courrier]Votre texte[/font]
</pre>

<h2 id="sizefont">Taille police</h2>
<p>
		Vous pouvez utiliser plusieur taille de polices : très petite, petite, normale, grande, très grande.
</p>
<pre>
[size=200]Votre texte[/size]
</pre>

<h2 id="titles">Titre:</h2>
<p>
        Pour un titre, écrivez une ligne avec deux :. Exemple:
</p>
<pre>
:: Liste de courses
</pre>

<h2 id="dividers">Séparateurs:</h2>
<p>
        Pour tracer une ligne sur votre texte, utilisez trois ou plusieurs tirets:<br> 
(Cela devrait être sur sa propre ligne, avec une ligne vierge avant et après)
</p>
<pre>
---
</pre>

<h2 id="quotes">Citations:</h2>
<p>
        Pour citer le texte de quelqu'un d'autre, placez-le sur sa propre ligne avec [quote] et [/quote] en fin de texte.
</p>
<pre>
[quote]C'est mon texte[/quote]
</pre>
<h2 id="pre">Code:</h2>
<p>
        Pour les petits extraits de code ou d'écriture technique que vous souhaitez afficher, vous pouvez utiliser [code] et [/code].
</p>

<pre>
[code]
&lt;?php
echo 'Hello world';
?&gt;
[/code]
</pre>
</article>
HTML

/* privacy policy page
   ---------------------------------------------------------------------------------------------------------------------- */
,'/html[@class="privacy"]/head/title'   => 'Politique de confidentialité'
,'#privacy'                             => <<<HTML

<h1>Politique de confidentialité</h1>
<article>
<header>
<ol>
        <li><a href="#collected">» Renseignements recueillis</a></li>
        <li><a href="#stored">» Information stockée</a></li>
        <li><a href="#other">» Autre information</a></li>
</ol>
</header>

<p>
        Ce forum de discussion est propulsé par <a href="http://camendesign.com/nononsense_forum">NoNonsense Forum</a>
        (ici après "NNF"). En tant que forum, NNF est unique dans la façon dont il stocke l'information, notamment parcequ'il <em>ne stocke pas</em> d'information , par rapport à d'autres forums.
</p>

<h2 id="collected">Renseignements recueillis:</h2>
<p>
        La seule information que vous devez fournir est un nom, un mot de passe et le texte que vous souhaitez publier.
</p>

<h2 id="stored">Information stockée:</h2>
<ul>
        <li><p>
                Le nom et le message que vous fournissez sont stockés dans le flux de discussion et rendus publics.<br> 
				Le nom peut être n'importe quel texte et vous ne devez pas utiliser votre nom réel mais un pseudo.
        </p></li>
        <li><p>
                Le mot de passe que vous fournissez est crypté à sens unique une fois reçu et stocké uniquement dans ce formulaire crypté - cela signifie que NNF (et le propriétaire du site) ne connaît pas votre mot de passe et ne peut pas le récupérer.
        </p></li>
        <li><p>
                Si ce forum fournit des traductions sélectionnables, la modification de la langue d'affichage définira un <em>cookie</em> spécifiant la langue choisie.
        </p><p>
                Un <em>cookie</em> est un petit morceau de texte stocké sur votre ordinateur qui se souvient d'une sorte d'interaction avec un site Web, dans ce cas, quelle langue vous avez sélectionné. NNF utilise uniquement des cookies pour se souvenir de la sélection de la langue et ne vous suit pas de manière quelconque. Il est tout à fait sûr de supprimer le cookie
        </p></li>
</ul>

<h2 id="other">Autre information:</h2>
<ul>
        <li><p>
                Notez que <strong>NoNonsense Forum</strong> est un logiciel open source gratuit, adaptable par toute personne possédant suffisamment de connaissances. Ce forum peut recueillir des informations supplémentaires au-delà de cette politique de confidentialité. La personne qui possède et exploite ce site Web peut avoir des politiques de confidentialité supplémentaires en place. Veuillez contacter le propriétaire du site pour toute question.
        </p></li>
        <li><p>
                Presque tous les sites Web recueillent des informations sur les visiteurs, qui incluent généralement des détails tels que votre adresse IP, l'heure d'accès et la marque d'identification du navigateur Web (également possible le système d'exploitation). Ces détails sont généralement utilisés pour mesurer le trafic et trouver des défauts. Aucune de ces informations n'est collectée par une partie du NoNonsense Forum lui-même. Encore une fois, contactez le propriétaire du site avec des questions.
        </p></li>
</ul>

</article>
HTML

/* site footer
   ---------------------------------------------------------------------------------------------------------------------- */
,'#nnf_stick@value'                     => 'Épinglée'                              //Stick button in 'thread.html'
,'#nnf_unstick@value'                   => 'Désépinglée'                            //Unstick button in 'thread.html'
,'#nnf_lock@value'                      => 'Verrouiller'                               //Lock button in 'thread.html'
,'#nnf_unlock@value'                    => 'Déverrouiller'                             //Unlock button in 'thread.html'

,'#nnf_mods-local'                      => <<<HTML
        Modérateur pour ce sous-forum:
        <span id="nnf_mods-local-list"><b class="nnf_mod">Alice</b></span>
HTML
,'#nnf_mods'                            => <<<HTML
        Vos modérateurs globaux:
        <span id="nnf_mods-list"><b class="nnf_mod">Bob</b></span>
HTML
,'#nnf_members'                         => <<<HTML
        Membres de ce forum:
        <span id="nnf_members-list"><b>Charlie</b></span>
HTML

,'/html/body/footer/p[1]'               => <<<HTML
        <a href="privacy.php">Politique de confidentialité</a>
HTML
,'.nnf_signed-in'                       => <<<HTML
        Connecter en tant que : <b class="nnf_signed-in-name">Kroc</b>
HTML
,'.nnf_signed-out/input@value'          => 'Se connecter'
,'.nnf_signedout/input@value'           => 'Se déconnecter'
);
//no : Warning: Cannot modify header information - headers already sent by (output started at plugins/plxNNForum/forum/lang/lang.fr.php 529
?>
<script type="text/javascript"><!--
	function checkLinks() {
    if(!document.getElementsByTagName)
        return;
    var links = document.getElementsByTagName('A');
    for(var i=links.length-1; i>=0; --i)
        if(links[i].className.indexOf('delete') != -1)
            links[i].onclick = function (e) {  
			return confirm("Êtes vous sur de vouloir supprimer cet élément ?");
                }
}
window.onload = checkLinks;
--></script>