<?php //translation file
/* ====================================================================================================================== */
/* NoNonsense Forum v26 © Copyright (CC-BY) Kroc Camen 2010-2015
   licenced under Creative Commons Attribution 3.0 <creativecommons.org/licenses/by/3.0/deed.en_GB>
   you may do whatever you want to this code as long as you give credit to Kroc Camen, <camendesign.com>
*//*

how to create a theme translation:
----------------------------------
1.      determine the standard language code to use, e.g. "en" (or "en-GB", "en-US" …), "de", "es" etc.
        Read this document on how to choose a language code:
        http://www.w3.org/International/questions/qa-choosing-language-tags
        
2.      make a copy of 'lang.example.php' and rename as 'lang.en.php' where "en" is the language code for your translation
        (do not rename, modify or delete 'lang.example.php')

3.      if you have not already, make a copy of 'theme.config.default.php' and rename it to 'theme.config.php'.
        within that file add your language code, separated from any other languages by a space, to the `THEME_LANGS`
        option; this will tell NNF that your language is available to use and will add it to the theme's language selector

4.      translate the text within your lang file. please note that all text is HTML.
        you can preview as you go by selecting your new language when running NNF

*/

//name of the language, as the user will use to select it;
//therefore should be the name of the language, written in that language - i.e. "Espanol" (Spanish)
$LANG['en']['name']             = 'English';

//the `date` format code used to print human readable dates into the HTML,
//see <php.net/manual/en/function.date.php> for documentation
$LANG['en']['date_format']      = 'd M ’y · H:i';

//the following template replacements are done using `sprintf`,
//see <php.net/manual/en/function.sprintf.php> for details

//the HTML title for index and thread pages
//"%1$s" - the title
//"%2$s" - if on page 2 or greater, `THEME_TITLE_PAGENO` will be inserted here, otherwise it will be removed
$LANG['en']['title']            = '%1$s%2$s';

//the page number, added to the titles of index pages and threads
//"%1$u" - the page number
$LANG['en']['title_pagenum']    = ' + %1$u';

//the title for append pages
//"%1$s" - the post title (will come from `THEME_RE` for replies)
$LANG['en']['title_append']     = 'Append to %1$s';

//the title for delete pages
//"%1$s" - the post title (will come from `THEME_RE` for replies)
$LANG['en']['title_delete']     = 'Delete %1$s?';

//reply number shown in threads as a permalink
//"%1$u" - the number of the reply
$LANG['en']['replynum']         = '#%1$u.';

//title format for each reply
//"%1$u" - number of the reply
//"%2$s" - the thread title
$LANG['en']['re']               = 'RE[%1$u]: %2$s';

//text used when appending to a post:
//(markup can be used as this is run through `formatText`)
//"%1$s" - username of who posted
//"%2$s" - human-readable time, as per `DATE_FORMAT`
$LANG['en']['appended']         = ':: @%1$s added on %2$s';

//HTML that replaces a post when it's deleted (this is not retroactive)
$LANG['en']['delete_user']      = '<p>This post was deleted by its owner</p>';
$LANG['en']['delete_mod']       = '<p>This post was deleted by a moderator</p>';

//HTML used to replace an invalid post:
$LANG['en']['corrupt']          = '<p>This post is corrupted and cannot be displayed</p>';

//text use to send email to administrator
$LANG['en']['subject']			= 'Response to the thread';
$LANG['en']['subject_thread']	= 'New thread';
$LANG['en']['content_1']		= 'replied to the thread';
$LANG['en']['content_thread_1']	= 'created a new thread';
$LANG['en']['content_2']		= 'Content of the message';
$LANG['en']['content_thread_2']	= 'Description of the thread';

//text for login
$LANG['en']['username']			= 'Username';
$LANG['en']['password']			= 'Password';
$LANG['en']['signin']			= 'Sign In';
$LANG['en']['error_signin']		= 'You have entered an incorrect password. Check your password and try again.';

//the translation strings
$LANG['en']['strings']          = array (

/* xpath/shorthand:                     replacement text:                       description:
   ====================================================================================================================== */
/* site header
   ---------------------------------------------------------------------------------------------------------------------- */
//search box
 '#query@placeholder'                   => 'Google Search…'                     //default text shown in search box
,'#go@alt'                              => 'Search'                             //search submit button

//language selector
,'#nnf_lang/img@alt, '.
 '#nnf_lang/img@title'                  => 'Language:'                          //language chooser icon
,'#nnf_lang/input@alt'                  => 'Set language'                       //language chooser submit button

//breadcrumb
,'#index/li[1]/a'                       => 'Index'                              //breadcrumb root location

/* index page
   ---------------------------------------------------------------------------------------------------------------------- */
//list of sub-forums
,'#nnf_folders/h1'                      => 'Sub-Forums'                         //section title
,'.nnf_lock-threads@alt, '.
 '.nnf_lock-threads@title'              => 'Replies-only:'                      //alt+title of lock-icon, if thread-locked
,'.nnf_lock-posts@alt, '.
 '.nnf_lock-posts@title'                => 'Read-only:'                         //alt+title of lock-icon, if post-locked

//navigation links
,'#nnf_add'                             => 'Add Thread'                         //the "add thread" link in 'index.html'
,'#nnf_reply'                           => 'Reply'                              //the "reply" link in 'thread.html'
,'#nnf_rss'                             => 'RSS'                                //the RSS link in the header

//access rights
,'#nnf_forum-lock-threads'              => <<<HTML
        Only <a href="#mods">moderators or members</a> can start new threads here,
        but <em>anybody</em> can reply to existing threads.
HTML
,'#nnf_forum-lock-posts'                => <<<HTML
        Only <a href="#mods">moderators or members</a> can participate here.
        Sign-in if you are a moderator or member in order to post.
HTML

//list of threads
,'#nnf_threads/h1'                      => 'Threads'
,'.nnf_thread-locked@alt, '.
 '.nnf_thread-locked@title'             => 'Locked:'

,'#nnf_new-form/h1'                     => 'Add Thread'                         //add thread form title
,'#nnf_new-form/form/p/'.
 'label@for="submit"/span'              => 'Submit'                             //form submit button

/* thread page
   ---------------------------------------------------------------------------------------------------------------------- */
,'#nnf_post-append, #nnf_post-append, '.
 '.nnf_reply-append, .nnf_reply-append' => 'append'                             //"append" link in posts
,'#nnf_post-delete, #nnf_post-delete, '.
 '.nnf_reply-delete, .nnf_reply-delete' => 'delete'                             //"delete" link in posts

,'.nnf_forum-locked'                    => <<<HTML
		Only <a href="#mods">moderators or members</a> can reply to this thread. Sign-in if you are a moderator or member in order to post.
HTML

,'#nnf_replies/h1'                      => 'Replies'                            //title for replies list

,'#nnf_reply-form/h1'                   => 'Reply'                              //reply form title
,'#nnf_reply-form/form/p/'.
 'label@for="submit"/span'              => 'Reply'                              //form submit button

/* append page
   ---------------------------------------------------------------------------------------------------------------------- */
,'#append/h1'                           => 'Append'                             //append form title
,'#append/form/p/'.
 'label@for="submit"/span'              => 'Append'                             //form submit button

/* delete page
   ---------------------------------------------------------------------------------------------------------------------- */
,'#delete/h1'                           => 'Delete'                             //delete form title

,'label@for="remove"/span'              => 'Remove completely (moderators only)'
,'#nnf_remove/ul/li[1]'                 => 'The post will be removed completely from the thread, rather than blanked'
,'#nnf_remove/ul/li[2]'                 => 'Only posts on the last page of the thread can be removed completely (so as to not break permalinks)'

,'#delete/form/p/'.
 'label@for="submit"/span'              => 'Delete'                             //form submit button

/* input forms
   ---------------------------------------------------------------------------------------------------------------------- */
,'label@for="nnf_title-field"'          => 'Title:'                             //title field label
,'#nnf_title-field@placeholder'         => 'Type thread title here…'            //placeholder text for the title field

,'label@for="nnf_name-field-http"'      => 'You are signed in as:'              //label for name field if HTTP_AUTH
,'label@for="nnf_name-field"'           => 'Name:'                              //name field label
,'#nnf_name-field@placeholder'          => 'Your name'                          //placeholder text for the name field

,'label@for="nnf_pass-field"'           => 'Password:'                          //label for password field
,'#nnf_pass-field@placeholder'          => 'A password to keep your name'       //placeholder text for the password field

,'label@for="nnf_captcha-field"'        => 'Anti-spam:'    				        //label for captcha field
,'#nnf_captcha-field@placeholder'       => 'Enter security code'                //placeholder text for the captcha field

,'#nnf_error-none'                      => <<<HTML
                        <!-- this is shown by default as long as new users aren't disabled and the user isn't signed in -->
                        There is no need to “register”, just enter the same name + password of your choice every time.
HTML
,'#nnf_info-none-append'               => <<<HTML
                        <!-- this is shown by default as long as new users aren't disabled and the user isn't signed in -->
                        Only the original author or a moderator can append to this post.
HTML
,'#nnf_error-none-append'               => <<<HTML
                        <!-- this is shown by default as long as new users aren't disabled and the user isn't signed in -->
                        Only the original author or a moderator can append to this post.
HTML
,'#nnf_error-none-thread'               => <<<HTML
                        To delete this thread, and all replies to it, you must be either the original author<br>
                        or a designated moderator.
HTML
,'#nnf_error-none-reply'                => <<<HTML
                        To delete this post you must be either the original author or a designated moderator.<br>
                        The content of the post will be removed but the name and date will remain.
HTML
,'#nnf_error-newbies'                   => <<<HTML
                        <!-- if the `FORUM_NEWBIES` option is false, only existing users can post -->
                        Only registered users can post. No new registrations are allowed.
HTML
,'#nnf_error-title'                     => <<<HTML
                        You need to enter the title of your new discussion thread.
HTML
,'#nnf_error-name'                      => <<<HTML
                        Enter a name. You’ll need to use this with the password each time.
HTML
,'#nnf_error-name-append'               => <<<HTML
                        Enter the name of either the original author or a moderator to be able to append to this reply.
HTML
,'#nnf_error-name-delete'               => <<<HTML
                        Enter the name of either the original author or a moderator to be able to delete.
HTML
,'#nnf_error-pass'                      => <<<HTML
                        Enter a password. It’s so you can re-use your name each time.
HTML
,'#nnf_error-pass-append'               => <<<HTML
                        Enter the password for either the original author or a moderator to be able to append to this reply
HTML
,'#nnf_error-pass-delete'               => <<<HTML
                        Enter the password for either the original author or a moderator to be able to delete.
HTML
,'#nnf_error-text'                      => <<<HTML
                        Well, write a message!
HTML
,'#nnf_error-user'                      => <<<HTML
                        Unauthorized user.
HTML
,'#nnf_error-captcha'                   => <<<HTML
                        Incorrect Captcha.
HTML
,'#nnf_error-captcha-append'            => <<<HTML
                        Incorrect Captcha.
HTML
,'#nnf_error-auth'                      => <<<HTML
                        That name is taken. Provide the password for it, or choose another name. (password typo?)
HTML
,'#nnf_error-auth-append'               => <<<HTML
                        Name / password mismatch! You must enter the name and password of either the original author,
                        or a designated moderator.
HTML
,'#nnf_error-auth-delete'               => <<<HTML
                        Name / password mismatch! You must enter the name and password of either the original author,
                        or a designated moderator.
HTML
,'#protip'                              => <<<HTML
                        Pro tip: Use <a href="/markup.php">markup</a> to add links, quotes and more.
HTML

,'label@for="nnf_text-field"'           => 'Message:'
,'#nnf_text-field@placeholder'          => 'Type your message here…'

/* markup page
   ---------------------------------------------------------------------------------------------------------------------- */
//the markup documentation:
,'/html[@class="markup"]/head/title'    => 'Markup'
,'#markup'                              => <<<HTML

<h1>Markup</h1>
<article>
<header>
<ol>
        <li><a href="#links">» Links</a></li>
        <li><a href="#names">» Names</a></li>
        <li><a href="#bolditalic">» Bold &amp; italic</a></li>
		<li><a href="#align">» Text align</a></li>
		<li><a href="#color">» Colors</a></li>
		<li><a href="#typefont">» Type font</a></li>
		<li><a href="#sizefont">» Font size</a></li>		
        <li><a href="#titles">» Titles</a></li>
        <li><a href="#dividers">» Dividers</a></li>
        <li><a href="#quotes">» Quotes</a></li>
        <li><a href="#pre">» Code</a></li>
</ol>
</header>
        
<h2 id="links">Links:</h2>
<p>
        Clickable links will be created automatically on any web addresses in your text that begin with
        "<samp>http://</samp>", "<samp>https://</samp>", "<samp>ftp://</samp>" or "<samp>irc://</samp>".
        Also, e-mail addresses will be turned into clickable links for you.
</p>
<pre>
YES:    http://www.google.com
NO:     www.google.com
YES:    email@email.com
</pre>

<h2 id="names">Names:</h2>
<p>
        You can refer to another person by prefixing their name with an at-symbol. E.g. "<samp>@bob</samp>"
        The name will link to the last reply made by that person in the current discussion thread.
</p>

<h2 id="bolditalic">Bold &amp; Italic</h2>
<pre>
[b]Write a bold text like this[/b], et [i]italic text like this[/i].
</pre>

<h2 id="align">Align text</h2>
<p>
		You can use left, right, center to position your text.
</p>
<pre>
[left]Your text[/left]
[center]Your text[/center]
[right]Your text[/right]
</pre>

<h2 id="color">Colors</h2>
<p>
		You can use your own color codes for example: # F14E23 or red.
</p>
<pre>
[color=color_code]Your color text[/color]
</pre>

<h2 id="typefont">Type font</h2>
<p>
		You can use more than one font type : Arial, Courrier, Sans-serif, Helvetica.
</p>
<pre>
[font=courrier]Your text[/font]
</pre>

<h2 id="sizefont">Font size</h2>
<p>
		You can use several font sizes: very small, small, normal, big, very big.
</p>
<pre>
[size=200]Your text[/size]
</pre>

<h2 id="titles">Titre:</h2>
<p>
       For a title, write a line with two:. Example:
</p>
<pre>
:: Shopping list
</pre>

<h2 id="dividers">separators:</h2>
<p>
        To draw a line on your text, use three or more dashes:<br> 
(This should be on its own line, with a blank line before and after)
</p>
<pre>
---
</pre>

<h2 id="quotes">Quotes:</h2>
<p>
        To quote someone else's text, place it on its own line with [quote] and [/ quote] at the end of the text.
</p>
<pre>
[quote]This is my text[/quote]
</pre>
<h2 id="pre">Code:</h2>
<p>
        For small snippets of code or technical writing you want to display, you can use [code] and [/ code].
</p>

<pre>
[code]
&lt;?php
echo 'Hello world';
?&gt;
[/code]
</pre>
</article>
HTML

/* privacy policy page
   ---------------------------------------------------------------------------------------------------------------------- */
,'/html[@class="privacy"]/head/title'   => 'Privacy Policy'
,'#privacy'                             => <<<HTML

<h1>Privacy Policy</h1>
<article>
<header>
<ol>
        <li><a href="#collected">» Information Collected</a></li>
        <li><a href="#stored">» Information Stored</a></li>
        <li><a href="#other">» Other Information</a></li>
</ol>
</header>

<p>
        This discussion forum is powered by <a href="http://camendesign.com/nononsense_forum">NoNonsense Forum</a>
        (here after “NNF”). As a forum, NNF is unique in what and the way it stores information,
        notably in what it <em>doesn’t</em> store, compared to other forums.
</p>

<h2 id="collected">Information Collected:</h2>
<p>
        The only information you are asked to provide is a name, password and the text that you wish to publish.
</p>

<h2 id="stored">Information Stored:</h2>
<ul>
        <li><p>
                The name and message you provide is stored as part of the discussion feed and made public.<br>
                The name can be any text and you do not have to use your real name or any identifying moniker
        </p></li>
        <li><p>
                The password you provide is one-way encrypted once received and stored only in this encrypted form —
                this means that NNF (and the site owner) does not know your password and cannot recover it
        </p></li>
        <li><p>
                If this forum provides selectable translations then changing the display language will set a
                <em>cookie</em> specifying your chosen language.
        </p><p>
                A <em>Cookie</em> is a small piece of text stored on your computer used to remember some kind of
                interaction with a website, in this case which language you have selected. NNF only uses cookies to
                remember the language selection and does not track you in any way. It is completely safe to delete the
                cookie
        </p></li>
</ul>

<h2 id="other">Other Information:</h2>
<ul>
        <li><p>
                Please note that NoNonsense Forum is free, open-source software, adaptable by anybody with sufficient
                knowledge; this forum may be collecting additional information beyond this privacy policy.
                The person who owns and operates this website may have additional privacy policies in place.
                Please contact the site owner with any questions
        </p></li>
        <li><p>
                Almost all websites collect visitor information, which typically includes details such as your I.P. address,
                time of access and web browser (also possibly operating system) identifying mark.
                These details are typically used for measuring traffic and finding faults. None of this information is
                collected by any part of NoNonsense Forum itself; again, contact the website owner with any questions
        </p></li>
        <li><p>
                The search feature is controlled by a third party (usually <a href="http://google.com">Google</a>),
                and will certainly collect information. Please check their website for their privacy policy
        </p></li>
</ul>

</article>
HTML

/* site footer
   ---------------------------------------------------------------------------------------------------------------------- */
,'#nnf_stick@value'                     => 'Stick'                              //Stick button in 'thread.html'
,'#nnf_unstick@value'                   => 'Unstick'                            //Unstick button in 'thread.html'
,'#nnf_lock@value'                      => 'Lock'                               //Lock button in 'thread.html'
,'#nnf_unlock@value'                    => 'Unlock'                             //Unlock button in 'thread.html'

,'#nnf_mods-local'                      => <<<HTML
        Moderators for this sub-forum:
        <span id="nnf_mods-local-list"><b class="nnf_mod">Alice</b></span>
HTML
,'#nnf_mods'                            => <<<HTML
        Your global moderators:
        <span id="nnf_mods-list"><b class="nnf_mod">Bob</b></span>
HTML
,'#nnf_members'                         => <<<HTML
        Members of this forum:
        <span id="nnf_members-list"><b>Charlie</b></span>
HTML

,'/html/body/footer/p[1]'               => <<<HTML
        <a href="privacy.php">privacy policy</a>
HTML
,'.nnf_signed-in'                       => <<<HTML
        Signed in as : <b class="nnf_signed-in-name">Kroc</b>
HTML
,'.nnf_signed-out/input@value'          => 'Sign in'

);

?>
<script type="text/javascript"><!--
	function checkLinks() {
    if(!document.getElementsByTagName)
        return;
    var links = document.getElementsByTagName('A');
    for(var i=links.length-1; i>=0; --i)
        if(links[i].className.indexOf('delete') != -1)
            links[i].onclick = function (e) {  
			return confirm("Are you sure you want to delete this item ?");
                }
}
window.onload = checkLinks;
--></script>
