<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/
include(dirname(__FILE__).'/lib/class.plx.minitchat.php');

class plxMiniTchat extends plxPlugin {
	
	public $rep_plugins;
	
	/**
	 * Constructeur de la classe
	 *
	 * @param	default_lang	langue par défaut utilisée par PluXml
	 * @return	null
	 * @author	Stephane F
	 **/
	public function __construct($default_lang) {

		# Appel du constructeur de la classe plxPlugin (obligatoire)
		parent::__construct($default_lang);
		
		# droits pour accéder à la page config.php du plugin
		$this->setConfigProfil(PROFIL_ADMIN);
		
		$this->minitchat = new minitchat();
		
		$_SESSION['prohibited_words'] = unserialize($this->getParam('prohibited_words'));
		$_SESSION['prohibited_words_ok'] = $this->getParam('prohibited_words_ok');
		$_SESSION['ipban'] = unserialize($this->getParam('ipban'));
		$_SESSION['ipban_ok'] = $this->getParam('ipban_ok');	
		$_SESSION['lang'] = $default_lang;
		
		# ajout du hook
		$this->addHook('plxShowMiniTchat', 'plxShowMiniTchat');
		$this->addHook('plxShowMiniTchat_static', 'plxShowMiniTchat_static');
		$this->addHook('AdminTopBottom', 'AdminTopBottom');
		$this->addHook('ThemeEndHead', 'ThemeEndHead');		

	}

	/**
	 * Méthode appelée à l'activation du plugin pour créer le répertoire tchat
	 *
	 * @author	Stephane F
	 **/
	public function onActivate() {
		# Vérification de l'existence du dossier /plugins/tchat
		if(!is_dir(PLX_ROOT.PLX_CONFIG_PATH.'plugins/tchat')) {
			@mkdir(PLX_ROOT.PLX_CONFIG_PATH.'plugins/tchat',0755,true);

			# Protection du répertoire tchat
			plxUtils::write('', PLX_ROOT.PLX_CONFIG_PATH.'plugins/tchat/index.html');
			if (!file_exists(PLX_ROOT.PLX_CONFIG_PATH.'plugins/tchat/.htaccess')){
				file_put_contents(PLX_ROOT.PLX_CONFIG_PATH.'plugins/tchat/.htaccess',"<Files *>
	Order allow,deny
	Deny from all
</Files>      
      ");
    }
			# Création du fichier data
			if (!file_exists(PLX_ROOT.PLX_CONFIG_PATH.'plugins/tchat/minitchat.xml')) {
				plxUtils::write('', PLX_ROOT.PLX_CONFIG_PATH.'plugins/tchat/minitchat.xml');
			}	
		}
	}		
	/**
	 * Méthode qui ajoute le fichier css et js dans le fichier header.php du thème
	 **/
	public function ThemeEndHead() {
		echo "\n\t".'
		<script type="text/javascript">
		if (typeof jQuery == "undefined") {
			document.write(\'<script type="text\/javascript" src="'.PLX_PLUGINS.'plxMiniTchat\/js\/jquery-2.1.3.min.js"><\/script>\');
		}
		</script>';
		echo "\n\t".'<script type="text/javascript" src="'.PLX_PLUGINS.'plxMiniTchat/js/tchatfunctions.js"></script>';

	}
	
	/**
	 * Méthode qui affiche le mini tchat
	 *
	 * @param	dim			largeur du tchat full ou mini
	 * @author  DPFPIC
	 **/	
    public function plxShowMiniTchat($dim = 'mini') {
	
		if ($dim == 'mini' OR empty($dim)) {
			echo "\n\t".'<link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.'plxMiniTchat/css/minitchat-mini.css" media="screen" />'."\n";
		} else {
			echo "\n\t".'<link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.'plxMiniTchat/css/minitchat.css" media="screen and (min-width: 800px)" />'."\n";
			echo "\n\t".'<link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.'plxMiniTchat/css/minitchat-mini.css" media="screen and (max-width: 800px)" />'."\n";
		}
  
		$plxMotor = plxMotor::getInstance();
		$rep_plugins = $plxMotor->aConf['racine_plugins'];
		$_SESSION['rep_plugins'] = $rep_plugins;
		$_SESSION['rep_configuration'] = PLX_CONFIG_PATH;
		$racine_plugins_config = PLX_ROOT.PLX_CONFIG_PATH.'plugins/tchat/minitchat.xml';
		$Url = plxUtils::getRacine().PLX_CONFIG_PATH.'plugins/tchat/minitchat.xml';		
		$Root = plxUtils::getRacine();
		$_SESSION['supervision'] = plxPlugin::getParam('supervision');
		$_SESSION['to'] = plxPlugin::getParam('to');
		$_SESSION['from'] = plxPlugin::getParam('from');
		$_SESSION['display'] = plxPlugin::getParam('display');
		$_SESSION['width'] = plxPlugin::getParam('width');
		$_SESSION['timeout'] = plxPlugin::getParam('timeout') * 60;
		$_SESSION['tk'] = $tk = uniqid();
		$_SESSION['error'] = 0;
		$sound = $Root.$rep_plugins.'plxMiniTchat/img/beep'.plxPlugin::getParam('soundsend').'.wav';
		$num = 0;
		$div = '';

		?>
		<!-- Plugin plxMiniTchat -->
		<div id="tchatbox">
		<?php if (plxPlugin::getParam('afftitle') == 1) { ?>
		<div id="title"><?php echo plxPlugin::getParam('boxtitle'); ?></div>
		<?php } ?>
		<div id="wrapper">
		<?php if (!$this->minitchat->ipban()) { ?>
		<form method="post" id="form_msg" name="message" action="#">
		<div><input placeholder="Pseudo" type="text" name="pseudo" id="pseudo" size="20"/></div>
		<div class="error" id="error" style="display:none;" title=""><?php $this->lang('L_MT_ERROR_PSEUDO'); ?></div>
		<div class="error" id="error2"></div>
		<div id="chatbox"><?php
		if(file_exists($racine_plugins_config) && filesize($racine_plugins_config) > 0){
			$contents = array();
			$nb = 0;
			$contents = $this->minitchat->getMsg($racine_plugins_config,plxPlugin::getParam('display'));
			if (count($contents) < plxPlugin::getParam('display')) { 
				$nb = count($contents);
			} else {
				$nb = plxPlugin::getParam('display');
			}
			for($i=0;$i<$nb;$i++) {
			    ++$num;
				echo '<div class="msgln'.($num%2).'">'.$contents[$i]['message'].'</div>';
			}
		}
		
		?></div>
		<div id="userpane"></div>
		<div style="clear:both"></div>
		<?php 
		$string = '<div id="barre">';
		$string .= '<a href="javascript:openhelp();"><img class="clsCursor" src="'.PLX_PLUGINS.'plxMiniTchat/img/bbcode/help.gif" alt="'.$this->getLang('L_MT_HELP').'" title="'.$this->getLang('L_MT_HELP').'"></a>&nbsp;';
		$string .= '<a href="javascript:void(0);" onclick="addbbcode(\'[b]\', \'[/b]\');"><img class="clsCursor" src="'.PLX_PLUGINS.'plxMiniTchat/img/bbcode/bold.gif" alt="'.$this->getLang('L_MT_BOLD').'" title="'.$this->getLang('L_MT_BOLD').'"></a>&nbsp;';
		$string .= '<a href="javascript:void(0);" onclick="addbbcode(\'[i]\', \'[/i]\');"><img class="clsCursor" src="'.PLX_PLUGINS.'plxMiniTchat/img/bbcode/italics.gif" alt="'.$this->getLang('L_MT_ITALICS').'" title="'.$this->getLang('L_MT_ITALICS').'"></a>&nbsp;';
		$string .= '<a href="javascript:void(0);" onclick="addbbcode(\'[u]\', \'[/u]\');"><img class="clsCursor"  src="'.PLX_PLUGINS.'plxMiniTchat/img/bbcode/underline.gif" alt="'.$this->getLang('L_MT_UNDERLINE').'" title="'.$this->getLang('L_MT_UNDERLINE').'"></a>&nbsp;';
		$string .= '<a href="javascript:void(0);" onclick="addbbcode(\'[url]\', \'[/url]\');"><img class="clsCursor" src="'.PLX_PLUGINS.'plxMiniTchat/img/bbcode/link.gif" alt="'.$this->getLang('L_MT_LINK').'" title="'.$this->getLang('L_MT_LINK').'"></a>&nbsp;';
		$string .= '<a href="javascript:void(0);" onclick="addbbcode(\'[mail]\', \'[/mail]\');"><img class="clsCursor" src="'.PLX_PLUGINS.'plxMiniTchat/img/bbcode/email.gif" alt="'.$this->getLang('L_MT_EMAIL').'" title="'.$this->getLang('L_MT_EMAIL').'"></a>&nbsp;';
		$string .= '<a href="javascript:void(0);" onclick="addbbcode(\'[q]\', \'[/q]\');"><img class="clsCursor" src="'.PLX_PLUGINS.'plxMiniTchat/img/bbcode/say.gif" alt="'.$this->getLang('L_MT_SAY').'" title="'.$this->getLang('L_MT_SAY').'"></a>&nbsp;';	
		$string .= '<a href="javascript: undo();"><img class="clsCursor" src="'.PLX_PLUGINS.'plxMiniTchat/img/bbcode/undo.gif" alt="'.$this->getLang('L_MT_UNDO').'" title="'.$this->getLang('L_MT_UNDO').'"></a>&nbsp;';
		$string .= '<a href="javascript: redo();"><img class="clsCursor" src="'.PLX_PLUGINS.'plxMiniTchat/img/bbcode/redo.gif" alt="'.$this->getLang('L_MT_REDO').'" title="'.$this->getLang('L_MT_REDO').'"></a>&nbsp;';
		$string .= '</div>';
		$string .= '<script type="text/javascript">';
		$string .= 'function openhelp() {';
		$string .= 'window.open("'.plxUtils::getRacine().$plxMotor->aConf['racine_plugins'].'plxMiniTchat/lang/fr-user_help.php","help_window","toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=no,top=200,left=200,width=300,height=320");}';
		$string .= '</script>'."\n";
		echo $string;

		?><span id="chatbeep"></span>
		<textarea name="usermsg" id="usermsg" class="usermsg" rows="2"></textarea><br />
    <?php $this->lang('L_MT_BEFORE'); ?>&nbsp;<span class="maxlength" id="maxlength"><?php echo plxPlugin::getParam('msgmax'); ?></span>&nbsp;<?php $this->lang('L_MT_AFTER'); ?>.
    <script type="text/javascript">
        <!--
            maxlength_textarea('usermsg','maxlength',<?php echo plxPlugin::getParam('msgmax'); ?>);
        -->
    </script>
		<div><?php $this->minitchat->DrawSmileys($rep_plugins); ?></div>
		<input name="submitmsg" class="submitmsg" type="button" id="submitmsg" value="<?php $this->lang('L_MT_SUBMIT'); ?>" />
		</form>
		<?php } else { ?>
		      <?php $this->lang('L_MT_MSG_IPBAN'); ?>
		<?php } ?>
		</div>
		</div>
		<script type="text/javascript">
		// jQuery Document
		$(document).ready(function(){
			refresh_tchat();
			refresh_pseudo();
		});	
		//If user submits the form
		$('#submitmsg').click(function(){
			$('#pseudo').each(function(){
			//Si le input est vide
			if($(this).val()===""){
				//on affiche l'erreur a cote
				document.getElementById('error').style.display = 'block';
				//si le input n'est pas vide
			}else{
			//on cache l'erreur
			document.getElementById('error').style.display = 'none';
			var clientmsg = $('#usermsg').val();
			var pseudo = $('#pseudo').val();
			$.post('<?php echo $Root.$rep_plugins; ?>plxMiniTchat/MiniTchat_Post.php?tk=ok&act=usermsg', {text: clientmsg, name: pseudo});	
			$('#chatbox').stop().animate({ scrollTop: 0 }, 270);			
			$('#usermsg').attr('value', '');
			$('#usermsg').val('');
			v_maxlength('usermsg','maxlength',<?php echo plxPlugin::getParam('msgmax'); ?>);
			<?php if (plxPlugin::getParam('soundsend') != 0) { ?>
				playBeep('<?php echo $sound; ?>');
			<?php } ?>
			message_error(pseudo);			
			return false;
			}
		});
		});
		//Load the file containing the chat log
		function refresh_tchat() {
			var xhr_object = null;
			if(window.XMLHttpRequest) { // Firefox
				xhr_object = new XMLHttpRequest();
			}
			else if(window.ActiveXObject) { // Internet Explorer
				xhr_object = new ActiveXObject('Microsoft.XMLHTTP');
			}
			var method = 'GET';
			var filename = '<?php echo $Root.$rep_plugins; ?>plxMiniTchat/MiniTchat_Post.php?tk=ok&act=usermsg';
			xhr_object.open(method, filename, true);
			xhr_object.onreadystatechange = function() {
				if(xhr_object.readyState == 4) {
					var tmp = xhr_object.responseText;
					document.getElementById('chatbox').innerHTML = tmp;
				}
			}
			xhr_object.send(null);
			setTimeout('refresh_tchat()', <?php echo plxPlugin::getParam('delay'); ?>);
		}
		
		//Load the file containing the chat log
		function refresh_pseudo() {
			var xhr_object = null;
			if(window.XMLHttpRequest) { // Firefox
				xhr_object = new XMLHttpRequest();
			}
			else if(window.ActiveXObject) { // Internet Explorer
				xhr_object = new ActiveXObject('Microsoft.XMLHTTP');
			}
			var method = 'GET';
			var filename = '<?php echo $Root.$rep_plugins; ?>plxMiniTchat/MiniTchat_Post.php?tk=ok&act=userlist';
			xhr_object.open(method, filename, true);
			xhr_object.onreadystatechange = function() {
				if(xhr_object.readyState == 4) {
					var tmp = xhr_object.responseText;
					document.getElementById('userpane').innerHTML = tmp;
				}
			}
			xhr_object.send(null);
			setTimeout('refresh_pseudo()', <?php echo plxPlugin::getParam('delay'); ?>);
		}		

		function message_error(pseudo) {
			var xhr_object = null;
			if(window.XMLHttpRequest) { // Firefox
				xhr_object = new XMLHttpRequest();
			}
			else if(window.ActiveXObject) { // Internet Explorer
				xhr_object = new ActiveXObject('Microsoft.XMLHTTP');
			}
			var method = 'GET';
			var filename = '<?php echo $Root.$rep_plugins; ?>plxMiniTchat/MiniTchat_Post.php?tk=ok&pseudo='+ pseudo + '&act=verif';
			xhr_object.open(method, filename, true);
			xhr_object.onreadystatechange = function() {
				if(xhr_object.readyState == 4) {
					var tmp = xhr_object.responseText;
					document.getElementById('error2').innerHTML = tmp;
				}
			}
			xhr_object.send(null);

		}
		</script>
		<?php
	}	
}
?>