<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/
class minitchat {

	/**
	 * Constructeur de la classe
	 *
	 * @return	null
	 * @author	DPFPIC
	 **/
	public function __construct() {
	
		# Déclaration des smileys
		$this->smileys = array(
		array('|:-)', 'plxMiniTchat/img/smileys/cool.gif', 	    	'cool'),
		array(';-)',  'plxMiniTchat/img/smileys/wink.gif',   	  	'wink'),
		array(':-))', 'plxMiniTchat/img/smileys/biggrin.gif', 	 	'biggrin'),
		array(':-)',  'plxMiniTchat/img/smileys/smile.gif',   	 	'smile'),
		array(':-o',  'plxMiniTchat/img/smileys/frown.gif',   	 	'frown'),
		array(':-((', 'plxMiniTchat/img/smileys/mad.gif',     	 	'mad'),
		array(':-(',  'plxMiniTchat/img/smileys/embarassed.gif',	'embarassed'),
		array(':-/',  'plxMiniTchat/img/smileys/undecided.gif', 	'undecided'),
		array(':-O',  'plxMiniTchat/img/smileys/surprised.gif', 	'surprised'),	
		array(':-p',  'plxMiniTchat/img/smileys/tongue.gif',   		'tongue'),
		array(';-(',  'plxMiniTchat/img/smileys/cry.gif',      		'cry')
		);
	}
	
	/**
	 * Création barre de Smileys
	 *
	 * @param	rep_plugins		nom du dossier Plugins
	 * @return	null
	 * @author	DPFPIC
	 **/	
	public function DrawSmileys($rep_plugins) {
	
		for ($i = 0; $i < count($this->smileys); $i++) {
			echo '<a href="JavaScript:AddSmiley(\''.$this->smileys[$i][0].'\')"><img src="'.$rep_plugins.$this->smileys[$i][1].'" class="clsCursor" title="'.$this->smileys[$i][0].'" alt="'.$this->smileys[$i][0].'" /></a>&nbsp;';
		}
	}

	/**
	 * Remplace les code simleys par des icones
	 *
	 * @param	rep_plugins		nom du dossier Plugins
	 * @return	chaine string
	 * @author	DPFPIC
	 **/	
	public function replaceimg($rep_plugins,$string) {
	
		foreach($this->smileys as $item) {
			$string = str_replace($item[0], '<img src="'.$this->getRacine().$rep_plugins.$item[1].'" title="'.$item[2].'" alt="'.$item[2].'" />', $string);
		}
		return $string;
	}

		/**
	 * Création barre de Smileys
	 *
	 * @param	rep_plugins		nom du dossier Plugins
	 * @param	string			le message du tchat
	 * @return	chaine string
	 * @author	DPFPIC
	 **/
	public function replacebbcode($rep_plugins,$string) {
	
	    #This function searches the shout for HTML tags and replaces them with the actual symbol.
		$string = str_replace('<', '&lt;', $string);
		$string = str_replace('>', '&gt;', $string);
	
		# Replaces javascripts with message
	    $string = str_replace('<script', '[i]no JavaScript allowed.[/i]', $string);
		$string = str_replace('<script>', '[i]no JavaScript allowed.[/i]', $string);
		$string = str_replace('javascript://', '[i]no JavaScript allowed.[/i]', $string);
		
		$string = $this->goodUrl($string);
		
		$string = str_replace('[b]','<strong>',$string);
		$string = str_replace('[/b]','</strong>',$string);
		$string = str_replace('[i]','<em>',$string);
		$string = str_replace('[/i]','</em>',$string);
		$string = str_replace('[u]','<span style="text-decoration: underline;">',$string);
		$string = str_replace('[/u]','</span>',$string);
		$string = str_replace('[n]','<span style="text-align: center;">',$string);
		$string = str_replace('[/n]','</span>',$string);	
		$string = str_replace('[q]','<span><em>Citation: "',$string);
		$string = str_replace('[/q]','"</em></span>',$string);	
		$string = str_replace('[url]','<a target="_blank" href="',$string);
		$string = str_replace('[/url]','"><img src="'.$this->getRacine().$rep_plugins.'/plxMiniTchat/img/www.gif" title="www" alt="" /></a>',$string);		
		$string = str_replace('[mail]','<a href="mailto:',$string);
		$string = str_replace('[/mail]','"><img src="'.$this->getRacine().$rep_plugins.'/plxMiniTchat/img/email.gif" title="email" alt="" /></a>',$string);
		
		return $string;
	}
	
	/**
	 * Sauvegarde du fichier xml
	 *
	 * @param	content		le message du tchat
	 * @param	filname		emplacement et nom du fichier
	 * @return	null
	 * @author	DPFPIC
	 **/	
	public function saveMsg($content, $filename) {

		$nb = sizeof($content);
		
		# sauvegarde
		# On génére le fichier XML
			$xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
			$xml .= "<document>\n";
			for($i=0;$i<$nb;$i++) {
				++$num;
				$xml .= "\t<minitchat id=\"".$i."\">";
				$xml .= "<message><![CDATA[".$content[$i]['message']."]]></message>\n";	
				$xml .= "\t<ip><![CDATA[".$content[$i]['ip']."]]></ip>";				
				$xml .=	"</minitchat>\n";
			}
		$xml .= "</document>";
		# On écrit le fichier si une action valide a été faite
		$this->write($xml,$filename);
	}	

	/**
	 * Sauvegarde du fichier xml
	 *
	 * @param	content		le message du tchat
	 * @param	filname		emplacement et nom du fichier
	 * @return	null
	 * @author	DPFPIC
	 **/	
	public function savePseudo($content, $filename) {

		$nb = sizeof($content);
		
		# sauvegarde
		# On génére le fichier XML
			$xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
			$xml .= "<document>\n";
			for($i=0;$i<$nb;$i++) {
				++$num;
				$xml .= "\t<userpane id=\"".$i."\">";
				$xml .= "<timestamp><![CDATA[".$content[$i]['timestamp']."]]></timestamp>\n";	
				$xml .= "\t<pseudo><![CDATA[".$content[$i]['pseudo']."]]></pseudo>\n";				
				$xml .= "\t<ip><![CDATA[".$content[$i]['ip']."]]></ip>";
				$xml .=	"</userpane>\n";
			}
		$xml .= "</document>";
		# On écrit le fichier si une action valide a été faite
		$this->write($xml,$filename);
	}		
	
	
	/**
	 * Edit du fichier xml
	 *
	 * @param	filename		emplacement et nom du fichier
	 - @param	all				le nombre de ligne à lire
	 * @return	null
	 * @author	DPFPIC
	 **/
	public function getMsg($filename, $all="") {
	
		$contents = array(); # Tableau de touts les messsages
		$t = 0;

		if(!is_file($filename)) return;

		# Mise en place du parseur XML
		$data = implode('',file($filename));
		$parser = xml_parser_create('UTF-8');
		xml_parser_set_option($parser,XML_OPTION_CASE_FOLDING,0);
		xml_parser_set_option($parser,XML_OPTION_SKIP_WHITE,0);
		xml_parse_into_struct($parser,$data,$strings,$iTags);
		xml_parser_free($parser);
		if(isset($iTags['minitchat']) AND isset($iTags['message'])) {
			if ($all == "") { 
				$nb = sizeof($iTags['message']);
			} else {
				$nb = intval($all);
				if ( $nb > sizeof($iTags['message'])) $nb = sizeof($iTags['message']);
			}
			for($i=0;$i<$nb;$i++) {
			# Recuperation du message et de l'IP
			$contents[$i]['message']=$strings[$iTags['message'][$i]]['value'];
			$contents[$i]['ip']=$strings[$iTags['ip'][$i]]['value'];
			}
		}
		return $contents;
	}

	/**
	 * Edit du fichier xml
	 *
	 * @param	filename		emplacement et nom du fichier
	 - @param	all				le nombre de ligne à lire
	 * @return	null
	 * @author	DPFPIC
	 **/
	public function getPseudo($filename) {
	
		$contents = array(); # Tableau de touts les messsages
		$t = 0;

		if(!is_file($filename)) return;

		# Mise en place du parseur XML
		$data = implode('',file($filename));
		$parser = xml_parser_create('UTF-8');
		xml_parser_set_option($parser,XML_OPTION_CASE_FOLDING,0);
		xml_parser_set_option($parser,XML_OPTION_SKIP_WHITE,0);
		xml_parse_into_struct($parser,$data,$strings,$iTags);
		xml_parser_free($parser);
		if(isset($iTags['userpane']) AND isset($iTags['userpane'])) {
			$nb = sizeof($iTags['pseudo']);
			for($i=0;$i<$nb;$i++) {
			# Recuperation du message et de l'IP
			$contents[$i]['timestamp']=$strings[$iTags['timestamp'][$i]]['value'];
			$contents[$i]['pseudo']=$strings[$iTags['pseudo'][$i]]['value'];
			$contents[$i]['ip']=$strings[$iTags['ip'][$i]]['value'];
			}
		}
		return $contents;
	}
	
	/**
	 * Méthode qui écrit dans un fichier
	 * Mode écriture seule; place le pointeur de fichier au début du fichier et réduit la taille du fichier à 0. Si le fichier n'existe pas, on tente de le créer.
	 *
	 * @param	xml					contenu du fichier
	 * @param	filename			emplacement et nom du fichier
	 * @return	boolean				retourne vrai si l'écriture s'est bien déroulée
	 **/
	public function write($xml, $filename) {

		if(file_exists($filename)) {
			$f = fopen($filename.'.tmp', 'w'); # On ouvre le fichier temporaire
			fwrite($f, trim($xml)); # On écrit
			fclose($f); # On ferme
			unlink($filename);
			rename($filename.'.tmp', $filename); # On renomme le fichier temporaire avec le nom de l'ancien
		} else {
			$f = fopen($filename, 'w'); # On ouvre le fichier
			fwrite($f, trim($xml)); # On écrit
			fclose($f); # On ferme
		}
		# On place les bons droits
		chmod($filename,0644);
		# On vérifie le résultat
		if(file_exists($filename) AND !file_exists($filename.'.tmp'))
			return true;
		else
			return false;
		}

	/**
	 * Trouve la racine du site
	 *
	 * @return	racine
	 * @author	DPFPIC
	 **/		
	public function getRacine() {

		$protocol = (!empty($_SERVER['HTTPS']) AND strtolower($_SERVER['HTTPS']) == 'on') || (!empty($_SERVER['HTTP_X_FORWARDED_PROTO']) AND strtolower($_SERVER['HTTP_X_FORWARDED_PROTO']) == 'https' )?        'https://' : "http://";
		$servername = $_SERVER['HTTP_HOST'];
		$serverport = (preg_match('/:[0-9]+/', $servername) OR $_SERVER['SERVER_PORT'])=='80' ? '' : ':'.$_SERVER['SERVER_PORT'];
		$dirname = preg_replace('/\/(core|plugins)\/(.*)/', '', dirname($_SERVER['SCRIPT_NAME']));
		$racine = rtrim($protocol.$servername.$serverport.$dirname, '/\\').'/';
		return $racine;
	}	

	/**
	 * Remise à zero du fichier message
	 *
	 * @param	filename		emplacement et nom du fichier
	 * @return	null
	 * @author	DPFPIC
	 **/	
	public function RazMsg($filename) {
	
		rename($filename, $filename.'.'.date('dmYHi'));
		unlink($filename);
		$xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
		$xml .= "<document>\n";
		$xml .= "</document>";
		# On écrit le fichier si une action valide a été faite
		$this->write($xml,$filename);
	}	

	/**
	* Méthode d'envoi de mail
	*
	* @param	from	string 			Email de l'expéditeur
	* @param	to		array/string	Adresse(s) du(des) destinataires(s)
	* @param	subject	string			Objet du mail
	* @param	body	string			contenu du mail
	* @return			boolean			renvoie FAUX en cas d'erreur d'envoi
	**/
	public function sendMail($from, $to, $subject, $body) {

		if(is_array($to))
			$to = implode(', ', $to);

		$headers  = "From: ".$from."\r\n";
		$headers .= "Reply-To: ".$from."\r\n";
		$headers .= 'MIME-Version: 1.0'."\r\n";
		// Content-Type
		$headers .= 'Content-type: text/html; charset="UTF-8"'."\r\n";

		$headers .= 'Content-transfer-encoding: 8bit'."\r\n";
		$headers .= 'Date: '.date("D, j M Y G:i:s O")."\r\n"; // Sat, 7 Jun 2001 12:35:58 -0700

		return mail($to, $subject, $body, $headers);
	}
	
	/**
	 * Formate les sites http
	 *
	 * @param	url		nom du dossier Plugins
	 * @return	null
	 * @author	DPFPIC
	 **/
	public function addScheme($url, $scheme = 'http://') {
	
		return parse_url($url, PHP_URL_SCHEME) === null ?
		$scheme . $url : $url;
	}	
	
	/**
	 * Verifie les Urls
	 *
	 * @param	string		le message
	 * @return	string
	 * @author	DPFPIC
	 **/	
	public function goodUrl($string) {

		# l'expression commence par /  le \s pour le caractère espace le \/ pour escaper le / de </url> et fini par /
		$regexp='#\[url\](.*?)\[/url\]#i';
 
		preg_match_all($regexp,$string,$output); # mets les resultats (.*?) de la recherche dans un tableau $output
 
		# les valeurs trouvées sont dans $output[1]
		foreach($output[1] as $key=>$val) {
			$string = str_replace($val,$this->addScheme($val),$string);
		}
	return $string;
	}

	/**
	 * Filtre les mots interdits
	 *
	 * @param	string				le message
	 * @param	prohibited_words	la liste des mots interdis
	 * @return	string
	 * @author	DPFPIC
	 **/
	public function prohibited_words($string, $prohibited_words){
		foreach ($prohibited_words as $value) {
			$string = str_replace($value, '****', $string);
		}
		return $string;
	}
	
	/**
	 * Filtre les IP bannis
	 *
	 * @return	TRUE or FAULSE
	 * @author	DPFPIC
	 **/
	public function ipban(){
	    $ipblock = false;
		if ($_SESSION['ipban_ok'] == 1) {
		$ipban = $_SESSION['ipban'];
		foreach ($ipban as $ip) {
			if ($ip == $_SERVER[REMOTE_ADDR]) { $ipblock = true; }
		}
		return $ipblock;
		}
		return $ipblock;
	}	

	/**
	 * Verification des version des plugins
	 *
	 * @param	plugin				le nom du plugin
	 * @return	array()
	 * @author	DPFPIC
	 **/
	public function UpdatePlugin($plugin) {
	    $array = array();
		$url = 'http://dpfpic.com/plugins.rep';
		$filename = PLX_PLUGINS.$plugin.'/infos.xml';
		
		# Mise en place du parseur XML
		$data = implode('',file($filename));
		$parser = xml_parser_create('UTF-8');
		xml_parser_set_option($parser,XML_OPTION_CASE_FOLDING,0);
		xml_parser_set_option($parser,XML_OPTION_SKIP_WHITE,0);
		xml_parse_into_struct($parser,$data,$strings,$iTags);
		xml_parser_free($parser);
		# Récupération des données xml
		$array['actualversion'] = plxUtils::getValue($strings[$iTags['version'][0]]['value']);
		$array['actualdate'] = plxUtils::getValue($strings[$iTags['date'][0]]['value']);


		if (ini_get('allow_url_fopen')) {
			$handleplugin = @file($url);
		}
		elseif ($curl = @curl_init()){
			$timeout = 5; // set to zero for no timeout
			curl_setopt ($curl, CURLOPT_URL, $url);
			curl_setopt ($curl, CURLOPT_CONNECTTIMEOUT, $timeout);
			curl_setopt ($curl, CURLOPT_RETURNTRANSFER, 1);
			$version_content = curl_exec($curl);
			curl_close($curl);
			if ($version_content != false) {
				$handleplugin = explode("\n", $version_content);
			}
		}	
		if ($handleplugin) {
			$nb = sizeof($handleplugin);
			for($i=0;$i<$nb;$i++) {
				$seach = strstr($handleplugin[$i], '||', true);
				if ($seach == $plugin) {
				    $value = explode('||', $handleplugin[$i]);
					$array['newplugin'] = $value[0];
					$array['newversion'] = $value[1];
					$array['newdate'] = $value[2];
					$array['newurl'] = $value[3];
					$array['active'] = $value[4];
				}
			}
		} else {
			$array ['status'] = 0;
			return $array;
		}
		
		$adate = explode("/", $array['actualdate']); 
		$ndate = explode("/", $array['newdate']);
		$actualdate = $adate[2].$adate[1].$adate[0];
		$newdate = $ndate[2].$ndate[1].$ndate[0];
		
		if (isset($array['actualversion']) AND ($array['actualversion'] == $array['newversion']  AND  $actualdate == $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 1;
			return $array;
		} elseif (isset($array['actualversion']) AND ($array['actualversion'] != $array['newversion'] OR  $actualdate != $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 2;
			return $array;
		} elseif (isset($array['active']) AND $array['active'] == 0) {
			$array ['status'] = 3;
			return $array;
		} else {
		    $array ['status'] = 0;
			return $array;
		}
	}		
}
?>