<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/

include(dirname(__FILE__).'/lib/class.plx.hrefdownload.php'); 
 
class plxHrefDownload extends plxPlugin {

	public function __construct($default_lang) {

		# appel du constructeur de la classe plxPlugin (obligatoire)
		parent::__construct($default_lang);

		# Personnalisation du menu admin
		$this->setAdminMenu($this->getlang('L_HD_DEFAULT_MENU_NAME'),'',$this->getlang('L_HD_DEFAULT_MENU_NAME'));

		# Ajoute des hooks
		$this->addHook('plxShowConstruct', 'plxShowConstruct');		
		$this->addHook('AdminArticleContent', 'AdminArticleContent');
		$this->addHook('plxMotorPreChauffageBegin', 'plxMotorPreChauffageBegin');		
		$this->addHook('plxAdminEditArticleXml', 'plxAdminEditArticleXml');
		$this->addHook('plxMotorParseArticle', 'plxMotorParseArticle');
		$this->addHook('AdminArticleTop', 'AdminArticleTop');
		$this->addHook('plxShowStaticListEnd', 'plxShowStaticListEnd');
		$this->addHook('AdminTopEndHead', 'AdminTopEndHead');	
		$this->addHook('ThemeEndHead', 'ThemeEndHead');	
        $this->addHook('plxAdminDelArticle', 'plxAdminDelArticle');		
		$this->addHook('plxShowHrefDownload', 'plxShowHrefDownload');

		# Autorisation d'acces à la configuration du plugins
		$this->setConfigProfil(PROFIL_ADMIN);
		$this->setAdminProfil(PROFIL_ADMIN);	
		
		$this->hrefdownload = new hrefdownload();	
		
	}

	/**
	 * Méthode appelée à l'activation du plugin pour créer le répertoire hits
	 *
	 * @author	Stephane F
	 **/
	public function onActivate() {
		# Vérification de l'existence du dossier /plugins/hits
		if(!is_dir(PLX_ROOT.PLX_CONFIG_PATH.'plugins/hits')) {
			@mkdir(PLX_ROOT.PLX_CONFIG_PATH.'plugins/hits',0755,true);

			# Protection du répertoire hits
			plxUtils::write('', PLX_ROOT.PLX_CONFIG_PATH.'plugins/hits/index.html');
		}
	}

	public function AdminTopEndHead() {
		echo "\n\t".'<script type="text/javascript" src="'.PLX_PLUGINS.'plxHrefDownload/js/filemanager.js"></script>';		
		echo "\n\t".'<script type="text/javascript" src="'.PLX_PLUGINS.'plxHrefDownload/js/hrefdownload.js"></script>';
		echo "\n\t".'<script type="text/javascript" src="'.PLX_PLUGINS.'plxHrefDownload/js/jscolor/jscolor.js"></script>';
		echo "\n\t".'
		<script type="text/javascript">
		if (typeof jQuery == "undefined") {
			document.write(\'<script type="text\/javascript" src="'.PLX_PLUGINS.'plxHrefDownload\/js\/jquery-1.11.0.min.js"><\/script>\');
		}
		</script>';
	}

	public function ThemeEndHead() {
		
		# récupérer la racine du site http//.... et du repertoire plugins
		$baseDirPlugins = plxUtils::getRacine().substr(PLX_PLUGINS,2);
		$baseDir = plxUtils::getRacine();

		echo "\t".'<link rel="stylesheet" href="'.PLX_PLUGINS.'plxHrefDownload/css/hrefdownload.css" type="text/css" media="screen" />'."\n";
		echo "\t".'<style type="text/css">'."\n";
		echo "\t".'.hrefdownload {'."\n";
		if (plxPlugin::getParam('hdBtPosition') =='C') {
		echo "\t".'margin-left: auto;'."\n";
		echo "\t".'margin-right: auto;'."\n";
		} elseif (plxPlugin::getParam('hdBtPosition') =='L') {
		echo "\t".'margin-left: 0;'."\n";
		} else {
		echo "\t".'margin-right: 0;'."\n";
		}
		if (plxPlugin::getParam('hdImgPerso') == 0) {
			echo "\t".'background: url('.$baseDirPlugins.'plxHrefDownload/img/bouton-'.plxPlugin::getParam('hdBtColor').'.png) center top no-repeat transparent;'."\n";
		} else {
			echo "\t".'background: url('.$baseDir.'/'.plxPlugin::getParam('hdBtcolorPerso').') center top no-repeat transparent;'."\n";
		}
		echo "\t".'}'."\n";
		echo "\t".'a.download:hover {'."\n";
		if (plxPlugin::getParam('hdImgPerso') == 0) {
			echo "\t".'background: url('.$baseDirPlugins.'plxHrefDownload/img/bouton-'.plxPlugin::getParam('hdBtColorHover').'.png) center top no-repeat transparent;'."\n";
		} else {
			echo "\t".'background: url('.$baseDir.'/'.plxPlugin::getParam('hdBtcolorHoverPerso').') center top no-repeat transparent;'."\n";
		}
		echo "\t".'}'."\n";		
		echo "\t".'.a-dl-text {'."\n";
		echo "\t".'color:#'.plxPlugin::getParam('hdBtColorTitle').'!important;'."\n";
		echo "\t".'}'."\n";
		echo "\t".'.hits {'."\n";   
		echo "\t".'color: #'.plxPlugin::getParam('hdBtColorHits').';'."\n";
		echo "\t".'}'."\n";		
		echo "\t".'</style>'."\n";
	}

	public function plxShowConstruct() {
		
		$urlrewrite = plxUtils::title2url(plxPlugin::getParam('hdButton'));
		
		# infos sur la page statique
		$string  = "if(\$this->plxMotor->mode=='".$urlrewrite."') {";
		$string .= "	\$array = array();";
		$string .= "	\$array[\$this->plxMotor->cible] = array(
			'name'		=> '".$urlrewrite."',
			'menu'		=> '',
			'url'		=> 'hits',
			'readable'	=> 1,
			'active'	=> 1,
			'group'		=> ''
		);";
		$string .= "	\$this->plxMotor->aStats = array_merge(\$this->plxMotor->aStats, \$array);";
		$string .= "}";
		echo "<?php ".$string." ?>";
	}	

	public function plxMotorPreChauffageBegin() {

		$template = 'static.php';
		$urlrewrite = plxUtils::title2url(plxPlugin::getParam('hdButton'));

		$string = "
		if(\$this->get && preg_match('/^".$urlrewrite."\/?/',\$this->get)) {
			\$this->mode = '".$urlrewrite."';
			\$this->cible = '../.".PLX_PLUGINS."plxHrefDownload/form';
			\$this->template = '".$template."';
			return true;
		}
		";

		echo "<?php ".$string." ?>";
	}
	
	public function plxAdminDelArticle() {
		# Suppression du compteur hits
		if (isset($_POST['artId'])) {
			$artid = $_POST['artId'];
			$hitsname = PLX_ROOT.PLX_CONFIG_PATH.'plugins/hits/art_'.$artid.'.txt';
			if(file_exists($hitsname)) {
				unlink($hitsname);
			}			
		} else {
			$artid = $_POST['idArt'];
			foreach ($artid as $k => $v) {
				$hitsname = PLX_ROOT.PLX_CONFIG_PATH.'plugins/hits/art_'.$v.'.txt';
				if(file_exists($hitsname)) {
					unlink($hitsname);
				}
			}
		}
	}	

	public function plxShowStaticListEnd() {
	
		if($this->getParam('hdDisplay')) {
		$plxShow = plxShow::getInstance();		
		# ajout du menu pour accèder à la page de Télécharger
		$idCat = $this->getParam('hdCat');

        if($plxShow->plxMotor->aCats[$idCat]['menu']=='oui' AND $plxShow->plxMotor->aCats[$idCat]['active']) {
            $id = 'cat-'.intval($idCat);
            $url = $plxShow->plxMotor->urlRewrite('?categorie'.intval($idCat).'/'.$plxShow->plxMotor->aCats[$idCat]['url']);
            //$name = plxUtils::strCheck($plxShow->plxMotor->aCats[$idCat]['name']);
			$name = $this->getParam('hdMenuName');
            $active = ($plxShow->catId()==intval($idCat)?'active':'noactive');
			$link = '<li id="'.$id.'"><a class="'.$active.'" title="'.$name.'" href="'.$url.'">'.$name.'</a></li>';
            echo "<?php array_splice(\$menus, ".($this->getParam('Pos')-1).", 0, '".$link."'); ?>";
		}
		}
	}	

	
	# Méthode qui ajoute les deux champs sur la page de rédaction d'un article
	public function AdminArticleContent() {
		$plxAdmin = plxAdmin::getInstance();
		$dfolder = plxPlugin::getParam('hdDownloadFolder');
		$plx_plugins = PLX_PLUGINS;
		$string53 = <<<END
			<p class="field"><label for="id_titledownload">{$this->getlang('L_HD_FIELD_TITLE')}</label>&nbsp;<a class="help" title="{$this->getlang('L_HD_HELP_TITLE')}">&nbsp;</a></p>
			<?php echo plxUtils::printInput('titledownload',plxUtils::strCheck(\$titledownload),'text','66-255'); ?></p><br />		
			<p class="field"><label for="id_hrefdownload">{$this->getlang('L_HD_FIELD_HREF')}</label>&nbsp;
			<a class="help" title="{$this->getlang('L_HD_HELP_HREF')}">&nbsp;</a></p>
			<?php echo plxUtils::printInput('hrefdownload',plxUtils::strCheck(\$hrefdownload),'text','66-255'); ?>
			<a title="{$this->getlang('L_HD_FILES')}" id="toggler" href="javascript:void(0)" onclick="plxmedia.openPopup('{$plx_plugins}plxHrefDownload/filemanager.php?id=hrefdownload')" style="outline:none; text-decoration: none">
			<img src="{$plx_plugins}plxHrefDownload/img/gfichiers.png" height="16" width="16" style="vertical-align: middle"></a>
			<p>&nbsp;</p>
END;
		$string54 = <<<END
			<div class="grid"><div class="col sml-12"><label for="id_titledownload">{$this->getlang('L_HD_FIELD_TITLE')}&nbsp;&nbsp;<a class="hint"><span>{$this->getlang('L_HD_HELP_TITLE')}</span></a></label>
			<?php echo plxUtils::printInput('titledownload',plxUtils::strCheck(\$titledownload),'text','66-255',false,'full-width'); ?></div></div>		
			<div class="grid"><div class="col sml-12"><label for="id_hrefdownload">{$this->getlang('L_HD_FIELD_HREF')}&nbsp;&nbsp;
			<a class="hint"><span>{$this->getlang('L_HD_HELP_HREF')}</span></a>&nbsp;&nbsp;<a id="toggler" href="javascript:void(0)" onclick="plxmedia.openPopup('{$plx_plugins}plxHrefDownload/filemanager.php?id=hrefdownload&df={$dfolder}')" style="outline:none; text-decoration: none">
			<img src="{$plx_plugins}plxHrefDownload/img/gfichiers.png" height="16" width="16"></a></label>
			<?php echo plxUtils::printInput('hrefdownload',plxUtils::strCheck(\$hrefdownload),'text','66-255',false,'full-width'); ?></div></div>
END;
        if ($plxAdmin->aConf['version'] >= '5.4') {
			echo $string54;
		} else {
			echo $string53;
		}

	}
	
	
	# Méthode qui écrit les deux champs dans le fichier xml de l'article
	public function plxAdminEditArticleXml() {	
		echo "<?php	\$xml .= \"\t\".'<hrefdownload><![CDATA['.plxUtils::cdataCheck(trim(\$content['hrefdownload'])).']]></hrefdownload>'.\"\n\"; ?>";
		echo "<?php	\$xml .= \"\t\".'<titledownload><![CDATA['.plxUtils::cdataCheck(trim(\$content['titledownload'])).']]></titledownload>'.\"\n\"; ?>";
	}
	
	# Méthode qui lit les deux champs dans le fichier xml de l'article
	public function plxMotorParseArticle() {	
		echo "<?php	\$art['hrefdownload'] = (isset(\$iTags['hrefdownload']))?trim(\$values[ \$iTags['hrefdownload'][0] ]['value']):''; ?>";
		echo "<?php	\$art['titledownload'] = (isset(\$iTags['titledownload']))?trim(\$values[ \$iTags['titledownload'][0] ]['value']):''; ?>";
	}	
	
	# Méthode qui récupere la valeur du champ à afficher dans le champ de saisie
	public function AdminArticleTop() {	
		
		$string = <<<END
		<?php
		if(!empty(\$_POST)) {
			\$hrefdownload = \$_POST['hrefdownload'];
			\$titledownload = \$_POST['titledownload'];
		} elseif(!empty(\$_GET['a'])) {
			\$hrefdownload = trim(\$result['hrefdownload']);
			\$titledownload = trim(\$result['titledownload']);			
		} else {
			\$hrefdownload = '';
			\$titledownload = '';
		}
		?>
END;
		echo $string;
	
	}	
	
	# Méthode appelée à partir du theme pour afficher le bouton télécharger et le Href
	public function plxShowHrefDownload() {

		$plxShow = plxShow::getInstance();
		$plxPlugin = $plxShow->plxMotor->plxPlugins->getInstance('plxHrefDownload');
		
		$title = $plxShow->plxMotor->plxRecord_arts->f('titledownload');
		$filepath = $plxShow->plxMotor->plxRecord_arts->f('hrefdownload');
		$pos = strripos($filepath, '/');
		$string = substr($filepath, $pos+1);
		$artid = str_pad($plxShow->artId(), 4, "0", STR_PAD_LEFT);
		
		if (strtolower(substr($plxShow->plxMotor->plxRecord_arts->f('hrefdownload'),0,4)) == 'http') {
		# Lien externe
		$filepath = $plxShow->plxMotor->plxRecord_arts->f('hrefdownload');
		$crypt = plxEncrypt::encryptId($filepath);
		} else {
		# Lien interne
		$filepath = $plxShow->plxMotor->plxRecord_arts->f('hrefdownload');
		$crypt = plxEncrypt::encryptId($filepath);
		}
		 
		$urlrewrite = plxUtils::title2url(plxPlugin::getParam('hdButton'));
				
	    echo '<div class="hrefdownload">';
		echo '<a class="download" href="';
		$plxShow->urlRewrite('?'.$urlrewrite.'&artid='.$artid.'&file='.$crypt);
		echo '" title="'.$title.'">';
		echo '<span class="dl-text">'.$title;
		if (plxPlugin::getParam('hdSize') == 1) {
			echo '-'.ceil(filesize($filepath)/1024).'Ko';
		}
		echo '</span>';				
		echo '<span class="a-dl-text">'.plxPlugin::getParam('hdButton').'</span>';
		if (plxPlugin::getParam('hdHits')) {
			echo '<span class="hits">&nbsp;&nbsp;('.$plxPlugin->hrefdownload->NumberOfHit($artid).')</span>';
		}	
		echo '</a></div>';
		
	}
	
}
?>