<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/
class hrefdownload {
	
	
	public function __construct() {
		
		$this->pathname = PLX_ROOT.PLX_CONFIG_PATH.'plugins/hits/'; # emplacement des hits
	}
	
	public function id_hits_list($ordre='sort',$depart='0',$limite=false){
		$patern='*';
		$dir = $this->pathname;
		$tab = array();
		if (is_dir($dir)) {
			if ($dh = opendir($dir)) {
				while (($file = readdir($dh)) !== false) {
					$ext=explode('.',$file);
					$ext=$ext[count($ext)-1];
					if($ext==$patern || $patern=="*" && $file!='.' && $file!='..' && $file!='index.html'){
						$tab[]= substr($file,4,4);
					}
				}
				closedir($dh);
			}
		}
		if ($ordre == 'sort') {
			sort($tab);
		} else {
			rsort($tab);
		}
		
		# On a une limite, on coupe le tableau
		if($limite)
			$tab = array_slice($tab,$depart,$limite);
		# On retourne le tableau
		return $tab;
	}
  
	public function getHrefArt($id) {
		$plxMotor = plxMotor::getInstance();

		$plxGlob_arts = clone $plxMotor->plxGlob_arts;
		
		# On génère notre motif de recherche
		$motif ='/^'.$id.'.[home|'.$plxMotor->activeCats.',]*.[0-9]{3}.[0-9]{12}.[a-z0-9-]+.xml$/';
		
		if ($filename = $plxGlob_arts->query($motif,'art','rsort',0,false,'before')){
         
		$tmp = $plxMotor->parseArticle(PLX_ROOT.$plxMotor->aConf['racine_articles'].$filename[0]);
		
		$hitsname = $this->pathname.'art_'.$id.'.txt';
		$FileContent = fopen( $hitsname, 'r' );
        $hits = fgets( $FileContent );
        fclose( $FileContent );
		
		$art = array(
			'id'		=> $tmp['numero'],
			'url' 		=> $plxMotor->urlRewrite('?article'.intval($tmp['numero']).'/'.$tmp['url']),
			'title' 	=> $tmp['title'],
			'hits'		=> $hits,
		);	
		return $art;
		} else {
		
		$art = array(
			'id'		=> $id,
			'url' 		=> 'L\'article n\'existe plus',
			'title' 	=> 'L\'article n\'existe plus',
			'hits'		=> '0',
		);	
		return  $art;
		}

	}
	
	public function hitsTotal() {
		
		$hitsTot = $this->id_hits_list('sort',0);
		$hitTotal = 0;
		foreach($hitsTot as $k=>$v) { 
			if ($art = $this->getHrefArt($v)) {
					$hitTotal = $hitTotal + intval($art['hits']);
			}
		}
		return $hitTotal;
	}

	public function resetHits($id) {
		$hitsname = $this->pathname.'art_'.$id.'.txt';
		$FileContent = fopen( $hitsname, 'w' );
        $hits = fputs( $FileContent, 0 );
        fclose( $FileContent );
		
	}
	
	# Méthode pour affichier le nombre de hits
	public function NumberOfHit($name) // création de la fonction NumberOfHit
	{		

		$folder_stat = $this->pathname; // répertoire dans lequel seront stockées les statistiques

        $file = $folder_stat . 'art_'. $name . '.txt' ; // nom du fichier de statistiques contenant le nombre de hits
        
        if ( file_exists( $file ) ) // si le fichier existe
        {
                $FileContent = fopen( $file , 'r' ); // ouverture du fichier
        
                $hit = fgets( $FileContent ); // récupération de la valeur
                fclose( $FileContent ); // fermeture du fichier
                
                return $hit; // retour de la valeur de $hit
        }
        else // si le fichier n’existe pas
        {
                touch( $file ); // création du fichier
                
                $FileContent = fopen( $file  , 'r+' ); // ouverture du fichier
        
                fseek( $FileContent, 0 ); // réinitialisation du curseur
                fputs( $FileContent, 0 ); // écriture dans le fichier
                
                fclose( $FileContent ); // fermeture du fichier
				
				return $hit = 0; // retour de la valeur de $hit
        }
	}
	
	/**
	 * Verification des version des plugins
	 *
	 * @param	plugin				le nom du plugin
	 * @return	array()
	 * @author	DPFPIC
	 **/
	public function UpdatePlugin($plugin) {
	    $array = array();
		$url = 'http://dpfpic.com/plugins.rep';
		$filename = PLX_PLUGINS.$plugin.'/infos.xml';
		
		# Mise en place du parseur XML
		$data = implode('',file($filename));
		$parser = xml_parser_create('UTF-8');
		xml_parser_set_option($parser,XML_OPTION_CASE_FOLDING,0);
		xml_parser_set_option($parser,XML_OPTION_SKIP_WHITE,0);
		xml_parse_into_struct($parser,$data,$strings,$iTags);
		xml_parser_free($parser);
		# Récupération des données xml
		$array['actualversion'] = plxUtils::getValue($strings[$iTags['version'][0]]['value']);
		$array['actualdate'] = plxUtils::getValue($strings[$iTags['date'][0]]['value']);


		if (ini_get('allow_url_fopen')) {
			$handleplugin = @file($url);
		}
		elseif ($curl = @curl_init()){
			$timeout = 5; // set to zero for no timeout
			curl_setopt ($curl, CURLOPT_URL, $url);
			curl_setopt ($curl, CURLOPT_CONNECTTIMEOUT, $timeout);
			curl_setopt ($curl, CURLOPT_RETURNTRANSFER, 1);
			$version_content = curl_exec($curl);
			curl_close($curl);
			if ($version_content != false) {
				$handleplugin = explode("\n", $version_content);
			}
		}	
		if ($handleplugin) {
			$nb = sizeof($handleplugin);
			for($i=0;$i<$nb;$i++) {
				$seach = strstr($handleplugin[$i], '||', true);
				if ($seach == $plugin) {
				    $value = explode('||', $handleplugin[$i]);
					$array['newplugin'] = $value[0];
					$array['newversion'] = $value[1];
					$array['newdate'] = $value[2];
					$array['newurl'] = $value[3];
					$array['active'] = $value[4];
				}
			}
		} else {
			$array ['status'] = 0;
			return $array;
		}
		
		$adate = explode("/", $array['actualdate']); 
		$ndate = explode("/", $array['newdate']);
		$actualdate = $adate[2].$adate[1].$adate[0];
		$newdate = $ndate[2].$ndate[1].$ndate[0];
		
		if (isset($array['actualversion']) AND ($array['actualversion'] == $array['newversion']  AND  $actualdate == $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 1;
			return $array;
		} elseif (isset($array['actualversion']) AND ($array['actualversion'] != $array['newversion'] OR  $actualdate != $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 2;
			return $array;
		} elseif (isset($array['active']) AND $array['active'] == 0) {
			$array ['status'] = 3;
			return $array;
		} else {
		    $array ['status'] = 0;
			return $array;
		}
	}		
}