<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 * Based on file media.php
 **/

include(dirname(__FILE__).'/../../core/admin/prepend.php');

# Recuperation de l'id de l'diteur appelant et du dossier
$editor = (isset($_GET['id'])) ? $_GET['id'] : die;
$dFolder = (isset($_GET['df'])) ? $_GET['df'] : die;

$redirect = $plxAdmin->aConf['racine'].'plugins/plxHrefDownload/filemanager.php?id='.$editor.'&df='.$dFolder;

# Control du token du formulaire
plxToken::validateFormToken($_POST);

# Scurisation du chemin du dossier
if(!isset($_POST['folder'])) {
	$_POST['folder']='.';
}

# Recherche du type de medias  afficher via la session
$_SESSION['files'] = $dFolder;

if(!empty($_POST['folder'])) {
	$_SESSION['currentfolder']= (isset($_SESSION['folder'])?$_SESSION['folder']:'');
	$_SESSION['folder'] = ($_POST['folder']=='.'?'':$_POST['folder']);
}
# Nouvel objet de type plxMedias
if($plxAdmin->aConf['userfolders'])
	$plxMedias = new plxMedias(PLX_ROOT.$_SESSION['files'].$_SESSION['user'].'/',$_SESSION['folder']);
else
	$plxMedias = new plxMedias(PLX_ROOT.$_SESSION['files'],$_SESSION['folder']);
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo $plxAdmin->aConf['default_lang'] ?>" lang="<?php echo $plxAdmin->aConf['default_lang'] ?>">
<head>
	<title><?php echo plxUtils::strCheck($plxAdmin->aConf['title']) ?> <?php echo L_ADMIN ?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=<?php echo strtolower(PLX_CHARSET) ?>" />
	<link rel="stylesheet" type="text/css" href="<?php echo $plxAdmin->aConf['racine'] ?>plugins/plxHrefDownload/css/filemanager.css" media="screen" />
	<script type="text/javascript">
	function basename(path){
		return path.replace(/\.\.\/\.\.\//gi,'');
	}
	function stripbase(path, base) {
		return path.replace(base,'');
	}
	
	</script>
</head>

<body>

<div id="content">

<p class="path"><?php echo L_MEDIAS_DIRECTORY.' : /'.plxUtils::strCheck(basename($_SESSION['files']).'/'.$_SESSION['folder']) ?></p>

<div id="files_manager">
	<form action="<?php echo $redirect ?>" method="post" id="form_medias" class="form_medias">
		<div class="manager">

		<?php echo plxToken::getTokenPostMethod() ?>
		<div class="files">
		<div style="float:left">
			<?php echo L_MEDIAS_FOLDER ?>&nbsp;:&nbsp;
			<?php echo $plxMedias->contentFolder() ?>
			<input type="submit" name="btn_ok" value="<?php echo L_OK ?>" />&nbsp;&nbsp;&nbsp;&nbsp;
		</div>
			<p>&nbsp;</p>
			<table class="table">
			<thead>
			<tr>
				<th class="image">&nbsp;</th>
				<th class="hcolumn"><?php echo L_MEDIAS_FILENAME ?></th>
				<th class="infos"><?php echo L_MEDIAS_EXTENSION ?></th>
				<th class="infos"><?php echo L_MEDIAS_FILESIZE ?></th>
				<th class="infos"><?php echo L_MEDIAS_DIMENSIONS ?></th>
				<th class="date"><?php echo L_MEDIAS_DATE ?></th>
			</tr>
			</thead>
			<tbody>
			<?php
			# Initialisation de l'ordre
			$num = 0;
			# Si on a des fichiers
			if($plxMedias->aFiles) {
				foreach($plxMedias->aFiles as $v) { # Pour chaque fichier
				    $isImage = in_array(strtolower($v['extension']), array('.png', '.gif', '.jpg'));
					$ordre = ++$num;
					echo '<tr class="line-'.($num%2).'">';
					echo '<td class="icon">';
					if(is_file($v['path']) AND $isImage) {
					echo '<a onclick="this.target=\'_blank\'" title="'.plxUtils::strCheck($v['name']).'" href="'.$v['path'].'"><img alt="" src="'.$v['.thumb'].'" class="thumb" /></a>';
					}
					echo '</td>';					
					echo '<td>';
					echo '<a class="test" onclick="window.opener.plxmedia.addText(\''.$editor.'\',stripbase(\''.str_replace('../../','',$v['path']).'\', \'\'),\'\');self.close();return false;" title="'.plxUtils::strCheck($v['name']).'" href="javascript:void(0)">'.plxUtils::strCheck($v['name']).'</a><br />';
					echo '</td>';
					echo '<td>'.strtoupper($v['extension']).'</td>';
					echo '<td>'.plxUtils::formatFilesize($v['filesize']).'</td>';
					$dimensions = '&nbsp;';
					if(isset($v['infos']) AND isset($v['infos'][0]) AND isset($v['infos'][1])) {
						$dimensions = $v['infos'][0].' x '.$v['infos'][1];
					}
					echo '<td>'.$dimensions.'</td>';
					echo '<td>'.date('d/m/Y', $v['date']).'</td>';
					echo '</tr>';
				}
			}
			else echo '<tr><td colspan="7" class="center">'.L_MEDIAS_NO_FILE.'</td></tr>';
			?>
			</tbody>
			</table>
		</div>
	</form>
	<div class="clear"></div>
</div>

</div><!-- content -->
</body>
</html>
