<?php if(!defined('PLX_ROOT')) exit; ?>
<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/

# Control du token du formulaire
plxToken::validateFormToken($_POST);

# Control de l'accès à la page en fonction du profil de l'utilisateur connecté
$plxAdmin->checkProfil(PROFIL_ADMIN, PROFIL_MANAGER, PROFIL_MODERATOR);

# Nombre d'article sélectionnés
$nbArtPagination = count($plxPlugin->hrefdownload->id_hits_list('sort',0));

# On va récupérer les messages
$plxAdmin->getPage();
$bypage_admin_hits = 15;
$start = $bypage_admin_hits*($plxAdmin->page-1);
$hits = $plxPlugin->hrefdownload->id_hits_list('rsort',$start,$bypage_admin_hits);

# Suppression des articles selectionnes
if(isset($_POST['selection']) AND !empty($_POST['sel']) AND isset($_POST['idHRef'])) {
	foreach ($_POST['idHRef'] as $k => $v) $plxPlugin->hrefdownload->resetHits($v);
	header('Location: plugin.php?p=plxHrefDownload');
	exit;
}
?>
<form action="plugin.php?p=plxHrefDownload" method="post" id="form_comments">
<div class="inline-form action-bar">
	<h2><?php $plxPlugin->lang('L_HD_HITS_TOTAL') ?></h2>
	<p>&nbsp;</p>
	<?php
	echo plxToken::getTokenPostMethod();
	if($_SESSION['profil']<=PROFIL_MODERATOR) {
		plxUtils::printSelect('selection', array( '' => L_FOR_SELECTION, 'delete' => $plxPlugin->getlang('L_HD_HITSRAZ')), '', false, false, 'id_selection');
		echo '<input name="sel" type="submit" value="'.L_OK.'" onclick="return confirmAction(this.form, \'id_selection\', \'delete\', \'idHRef[]\', \''.$plxPlugin->getlang('L_HD_CONFIRM_RAZ').'\')" />&nbsp;&nbsp;&nbsp;';
	}
	?>
	<?php plxUtils::printInput('page',1,'hidden'); ?>
</div>
<div class="scrollable-table">
<table id="hrefdownload-table" class="full-width">
<thead>
	<tr>
		<th class="checkbox"><input type="checkbox" onclick="checkAll(this.form, 'idHRef[]')" /></th>
		<th class="nbnote"><?php $plxPlugin->lang('L_HD_LIST_ID') ?></th>		
		<th class="message"><?php $plxPlugin->lang('L_HD_LISTT_ARTICLE') ?></th>
		<th class="message"><?php $plxPlugin->lang('L_HD_APERCU') ?></th>		
		<th class="action"><?php $plxPlugin->lang('L_HD_LIST_HITS') ?></th>
	</tr>
</thead>
<tbody>
<?php
	if($hits) { # On a des articles
		foreach($hits as $k=>$v) { 
			if ($art = $plxPlugin->hrefdownload->getHrefArt($v)) {
			echo '<tr>';
			echo '<td><input type="checkbox" name="idHRef[]" value="'.$v.'" /></td>';
			echo '<td>'.$v.'</td>';
			echo '<td><a href="article.php?a='.$v.'" title="'.$art['title'].'">'.$art['title'].'</a></td>';
			echo '<td><a href="'.$art['url'].'" title="'.$art['title'].'" target="_blank">'.$plxPlugin->getlang('L_HD_SEE').'</a></td>';
			echo '<td>'.$art['hits'].'</td>';
			echo '</tr>';
			}
		}
		echo '</tr>';
	} else { # Pas d'article
			echo '<tr><td colspan="5" class="center">'.L_NO_ARTICLE.'</td></tr>';
	}	
?>		
	</tbody>
	</table>
</div>	
</form>
<p><strong><?php echo $plxPlugin->getlang('L_HD_TOTAL_HITS').'</strong> : '.$plxPlugin->hrefdownload->hitsTotal(); ?></p>
<p id="pagination">
	<?php
	# Affichage de la pagination
	if($hits) { # Si on a des articles (hors page)
		# Calcul des pages
		echo $nbArtPagination;
		$last_page = ceil($nbArtPagination/$bypage_admin_hits);
		$stop = $plxAdmin->page + 2;
		if($stop<5) $stop=5;
		if($stop>$last_page) $stop=$last_page;
		$start = $stop - 4;
		if($start<1) $start=1;
		# Génération des URLs
		$artTitle = (!empty($_GET['artTitle'])?'&amp;artTitle='.urlencode($_GET['artTitle']):'');
		$p_url = 'plugin.php?p=plxHrefDownload&page='.($plxAdmin->page-1).$artTitle;
		$n_url = 'plugin.php?p=plxHrefDownload&page='.($plxAdmin->page+1).$artTitle;
		$l_url = 'plugin.php?p=plxHrefDownload&page='.$last_page.$artTitle;
		$f_url = 'plugin.php?p=plxHrefDownload&page=1'.$artTitle;
		# Affichage des liens de pagination
		printf('<span class="p_page">'.L_PAGINATION.'</span>', '<input style="text-align:right;width:35px" onchange="window.location.href=\'plugin.php?p=plxHrefDownload&page=\'+this.value+\''.$artTitle.'\'" value="'.$plxAdmin->page.'" />', $last_page);
		$s = $plxAdmin->page>2 ? '<a href="'.$f_url.'" title="'.L_PAGINATION_FIRST_TITLE.'">&laquo;</a>' : '&laquo;';
		echo '<span class="p_first">'.$s.'</span>';
		$s = $plxAdmin->page>1 ? '<a href="'.$p_url.'" title="'.L_PAGINATION_PREVIOUS_TITLE.'">&lsaquo;</a>' : '&lsaquo;';
		echo '<span class="p_prev">'.$s.'</span>';
		for($i=$start;$i<=$stop;$i++) {
			$s = $i==$plxAdmin->page ? $i : '<a href="'.('plugin.php?p=plxHrefDownload&page='.$i.$artTitle).'" title="'.$i.'">'.$i.'</a>';
			echo '<span class="p_current">'.$s.'</span>';
		}
		$s = $plxAdmin->page<$last_page ? '<a href="'.$n_url.'" title="'.L_PAGINATION_NEXT_TITLE.'">&rsaquo;</a>' : '&rsaquo;';
		echo '<span class="p_next">'.$s.'</span>';
		$s = $plxAdmin->page<($last_page-1) ? '<a href="'.$l_url.'" title="'.L_PAGINATION_LAST_TITLE.'">&raquo;</a>' : '&raquo;';
		echo '<span class="p_last">'.$s.'</span>';
	}
	?>
</p>
