<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/
 
include(dirname(__FILE__).'/lib/class.plx.donneravis.php'); 
 
class plxDonnerAvis extends plxPlugin {

	/**
	 * Constructeur de la classe DonnerAvis
	 *
	 * @param	default_lang	langue par défaut utilisée par PluXml
	 * @return	null
	 **/
	public function __construct($default_lang) {

		# Appel du constructeur de la classe plxPlugin (obligatoire)
		parent::__construct($default_lang);
		
		# Autorisation d'acces à la configuration du plugin
		$this->setConfigProfil(PROFIL_ADMIN, PROFIL_MANAGER);

		# Autorisation d'accès à l'administration du plugin
		$this->setAdminProfil(PROFIL_ADMIN, PROFIL_MANAGER);

		$this->donneravis = new donneravis();		

		# Personnalisation du menu admin
		$this->setAdminMenu($this->getlang('L_DA_DEFAULT_MENU_NAME').$this->donneravis->notificationda(),'',$this->getlang('L_DA_DEFAULT_MENU_NAME'));
		#$this->setAdminMenu($this->getlang('L_DA_DEFAULT_MENU_NAME'),'',$this->getlang('L_DA_DEFAULT_MENU_NAME'));
		
		# déclaration des hooks
		$this->addHook('AdminTopBottom', 'AdminTopBottom');
		$email = explode(',', $this->getParam('email'));
		
		if(plxUtils::checkMail($email[0])) {
			$this->addHook('plxMotorPreChauffageBegin', 'plxMotorPreChauffageBegin');
			$this->addHook('plxShowConstruct', 'plxShowConstruct');
			$this->addHook('plxShowStaticListEnd', 'plxShowStaticListEnd');
			$this->addHook('plxShowPageTitle', 'plxShowPageTitle');
			$this->addHook('ThemeEndHead', 'ThemeEndHead');
			$this->addHook('AdminTopEndHead', 'AdminTopEndHead');
			$this->addHook('SitemapStatics', 'SitemapStatics');
			$this->addHook('plxShowTotalNbda', 'plxShowTotalNbda');
			$this->addHook('plxShowRating', 'plxShowRating');
			$this->addHook('plxShowAfficheReview', 'plxShowAfficheReview');
			$this->addHook('plxShoxAfficheNbAvis', 'plxShoxAfficheNbAvis');
		}
	}

	/**
	 * Méthode de traitement du hook plxShowConstruct
	 **/
	public function plxShowConstruct() {

		# infos sur la page statique
		$string  = "if(\$this->plxMotor->mode=='donneravis') {";
		$string .= "	\$array = array();";
		$string .= "	\$array[\$this->plxMotor->cible] = array(
			'name'		=> '".$this->getParam('mnuName')."',
			'menu'		=> '',
			'url'		=> 'donneravis',
			'readable'	=> 1,
			'active'	=> 1,
			'group'		=> ''
		);";
		$string .= "	\$this->plxMotor->aStats = array_merge(\$this->plxMotor->aStats, \$array);";
		$string .= "}";
		echo "<?php ".$string." ?>";
	}
	
	/**
	 * Méthode appelée à l'activation du plugin pour créer le répertoire davis
	 *
	 * @author	Stephane F
	 **/
	public function onActivate() {
		# Vérification de l'existence du dossier /plugins/davis
		if(!is_dir(PLX_ROOT.PLX_CONFIG_PATH.'plugins/davis')) {
			@mkdir(PLX_ROOT.PLX_CONFIG_PATH.'plugins/davis',0755,true);

			# Protection du répertoire davis
			plxUtils::write('', PLX_ROOT.PLX_CONFIG_PATH.'plugins/davis/index.html');
			if (!file_exists(PLX_ROOT.PLX_CONFIG_PATH.'plugins/davis/.htaccess')){
				file_put_contents(PLX_ROOT.PLX_CONFIG_PATH.'plugins/davis/.htaccess',"<Files *>
	Order allow,deny
	Deny from all
</Files>      
      ");
    }			
		}
	}	
	/**
	 * Méthode de traitement du hook plxMotorPreChauffageBegin
	 **/
	public function plxMotorPreChauffageBegin() {

		$template = $this->getParam('template')==''?'static.php':$this->getParam('template');

		$string = "
		if(\$this->get && preg_match('/^donneravis\/?/',\$this->get)) {
			\$this->mode = 'donneravis';
			\$this->cible = '../.".PLX_PLUGINS."plxDonnerAvis/form';
			\$this->template = '".$template."';
			return true;
		}
		";

		echo "<?php ".$string." ?>";
	}	

	/**
	 * Méthode de traitement du hook plxShowStaticListEnd
	**/
	public function plxShowStaticListEnd() {

		# ajout du menu pour accèder à la page de donneravis
		if($this->getParam('mnuDisplay')) {
			echo "<?php \$class = \$this->plxMotor->mode=='donneravis'?'active':'noactive'; ?>";
			echo "<?php array_splice(\$menus, ".($this->getParam('mnuPos')-1).", 0, '<li><a class=\"static '.\$class.'\" href=\"'.\$this->plxMotor->urlRewrite('?donneravis').'\" title=\"".$this->getParam('mnuName')."\">".$this->getParam('mnuName')."</a></li>'); ?>";
		}

	}
	
	/**
	 * Méthode qui ajoute le fichier css et js dans le fichier header.php du thème
	 **/
	public function ThemeEndHead() {
		echo "\n\t".'<link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.'plxDonnerAvis/css/donneravis.css" media="screen" />'."\n";
		echo "\n\t".'<link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.'plxDonnerAvis/css/stars.css" media="screen" />'."\n";
		echo "\n\t".'<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css">'."\n";
		echo "\n\t".'
		<script type="text/javascript">
		if (typeof jQuery == "undefined") {
			document.write(\'<script type="text\/javascript" src="'.PLX_PLUGINS.'plxDonnerAvis\/js\/jquery-2.2.4.min.js"><\/script>\');
		}
		</script>';
		echo "\n\t".'<script type="text/javascript" src="'.PLX_PLUGINS.'plxDonnerAvis/js/stars.js"></script>'."\n";
	}
	
	public function AdminTopEndHead() {
		echo "\n\t".'<link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.'plxDonnerAvis/css/stars.css" media="screen" />'."\n";
		echo "\n\t".'<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css">'."\n";
		echo "\n\t".'<script type="text/javascript" src="'.PLX_PLUGINS.'plxDonnerAvis/js/jscolor/jscolor.js"></script>';
	}		

	/**
	 * Méthode qui rensigne le titre de la page dans la balise html <title>
	 **/
	public function plxShowPageTitle() {
		echo '<?php
			if($this->plxMotor->mode == "donneravis") {
				echo plxUtils::strCheck("'.stripslashes($this->getLang('L_DA_TITLE')).' - ".$this->plxMotor->aConf["title"]);
				return true;
			}
		?>';
	}	

	/**
	 * Méthode qui référence la page de donneravis dans le sitemap
	 **/
	public function SitemapStatics() {
		echo '<?php
		echo "\n";
		echo "\t<url>\n";
		echo "\t\t<loc>".$plxMotor->urlRewrite("?donneravis")."</loc>\n";
		echo "\t\t<changefreq>monthly</changefreq>\n";
		echo "\t\t<priority>0.8</priority>\n";
		echo "\t</url>\n";
		?>';
	}

	/**
	 * Méthode qui affiche un message si l'adresse email du donneravis n'est pas renseignée
	 **/
	public function AdminTopBottom() {

		echo '<?php
		if($plxAdmin->plxPlugins->aPlugins["plxDonnerAvis"]->getParam("email")=="") {
			echo "<p class=\"warning\">Plugin DonnerAvis<br />'.$this->getLang("L_DA_ERR_EMAIL").'</p>";
			plxMsg::Display();
		}
		?>';
	}	
	
	public function plxShowRating($link) {
		$plxShow = plxShow::getInstance();
		$plxMotor = plxMotor::getInstance();
		$title = $this->donneravis->my_simple_crypt(plxUtils::strCheck($plxMotor->plxRecord_arts->f('title')), 'e');
		$total = 0;
		$idart = str_pad($plxShow->artId(), 4, "0", STR_PAD_LEFT);
		$davis = $this->donneravis->getDonnerAvis($this->getParam('tri_da'),'online',$start=0,$limite=false,$idart);
		if (!empty($this->donneravis->plxRecord_da)) {
			while($this->donneravis->plxRecord_da->loop()) {
				$total = $total + $this->donneravis->plxRecord_da->f('stars');
			}
		} else {
			$total = 0;
		}
		$nbDA=$this->donneravis->nbDonnerAvisByart('online',$idart);
		if ($total != 0) {
			$average = round($total / $nbDA,1);
		} else {
			$average = 0;
		}
		echo '<!-- Début plugin plxDonnerAvis -->'."\n";
		$_SESSION['QUERY_STRING'] = $_SERVER['QUERY_STRING'];
				?>
		<div class="rating">
			<div class="star"></div>
				<div class="rating_note">
					<div itemscope itemtype="http://schema.org/Product">
						<?php if ($link == 'link') { ?>
							<a href="<?php $plxShow->urlRewrite('?donneravis&idart='.str_pad($plxShow->artId(), 4, "0", STR_PAD_LEFT).'&title='.$title); ?>">
						<?php } ?>
						<div id="googleRichSnippets">
							<div itemprop="aggregateRating" itemscope itemtype="http://schema.org/AggregateRating">
								<span itemprop="ratingValue"><?php echo $average; ?></span>/<span itemprop="bestRating"><?php echo $this->getParam('nbStars'); ?></span>&nbsp;
								(<span itemprop="ratingCount"><?php echo $nbDA; ?></span> <?php $this->lang('L_DA_AVIS'); ?>)
								<?php if ($link == 'link') { ?>
									</a>
								<?php } ?>
								&nbsp;&nbsp;&nbsp;&nbsp;<a href="<?php $plxShow->urlRewrite('?donneravis&idnew=true&idart='.str_pad($plxShow->artId(), 4, "0", STR_PAD_LEFT).'&title='.$title); ?>"><?php $this->lang('L_DA_DEPOSIT'); ?></a>
								<span itemprop="name" class="transparent"><?php echo plxUtils::strCheck($plxMotor->plxRecord_arts->f('title')); ?></span>
							</div>
						</div> 
					<span itemprop="name" class="transparent"><?php echo plxUtils::strCheck($plxMotor->plxRecord_arts->f('title')); ?></span>	
					</div>
				</div>
		</div>	
		<div style="clear: both"></div>
    
        <script type="text/javascript">
            $(".star").stars({ 
			    stars: <?php echo $this->getParam('nbStars'); ?>,
				color: '#<?php echo $this->getParam('colorStar'); ?>',
				isDisabled: true,
				value: <?php echo $average; ?>
            });
         </script>
		<?php
		echo '<!-- Fin plugin plxDonnerAvis -->'."\n";
	}
	
	
    public function plxShoxAfficheNbAvis() {
		$plxShow = plxShow::getInstance();
		$plxMotor = plxMotor::getInstance();
		$idart = str_pad($plxShow->artId(), 4, "0", STR_PAD_LEFT);
		$nbav = $this->donneravis->nbDonnerAvisByart('online',$idart);
		if ($nbav < 1) { $nbav = $this->getLang('L_DA_NONE'); }
		$nbDA = $nbav.' '.$this->getLang('L_DA_AVIS');
		echo $nbDA;
	}
	
	public function plxShowAfficheReview() {
		$plxMotor = plxMotor::getInstance();
	
		if($this->donneravis->plxRecord_da): ?>
		<div id="donneravis">
		<?php while($this->donneravis->plxRecord_da->loop()): # On boucle sur les messages ?>
		<div class="review">
			<div class="content">
				<div class="title">
					<h4 class="color4">"<?php echo $this->donneravis->plxRecord_da->f('avis'); ?>"</h4>
				</div>
				<div class="rating-review">
					<?php $this->donneravis->rating(plxUtils::strCheck($plxMotor->plxRecord_arts->f('title')), $this->donneravis->plxRecord_da->f('stars'), $this->getParam('nbStars'), $this->getParam('colorStar')); ?>
				</div>
				<div class="description"><?php $this->donneravis->daContent(); ?></div>
				<div class="published"><?php $this->lang('L_DA_FORM_PUBLISHED') ?>&nbsp;<?php $this->donneravis->daDate('#num_day-#num_month-#num_year(4) #hour:#minute'); ?>&nbsp;<?php $this->lang('L_DA_FORM_BY') ?>&nbsp;<?php echo $this->donneravis->plxRecord_da->f('author'); ?></div>
			</div>
		</div> 

		<?php endwhile; # Fin de la boucle sur les messages ?>
		</div>
		<?php else: ?>
			<div id="donneravis">
				<p><?php $this->lang('L_DA_FORM_NO_POST') ?>.</p>
			</div>
		<?php endif;
	}
}
	
?>
