<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/
 
class donneravis {

	public $plxRecord_da = null; # Objet du livre d'or
	public $plxGlob_da = null; # Objet plxGlob du livre d'or
	
	public function __construct() {
	
		$this->pathname = PLX_ROOT.PLX_CONFIG_PATH.'plugins/davis/';
		 
	}

	public function getDonnerAvis($ordre='sort',$type='all',$start=0,$limite=false,$idart='all') {

		# On recupre les fichiers des Messages
		$this->plxGlob_da = $this->getDirectoryTree($this->pathname,'xml',$ordre,$type,$start,$limite,$idart);
		$aFiles = $this->plxGlob_da;
		if($aFiles) { # On a des fichiers
			foreach($aFiles as $k=>$v) # On parcourt tous les fichiers
				$array[ $k ] = $this->parseDonnerAvis($this->pathname.$v);
				# On stocke les enregistrements dans un objet plxRecord				
				$this->plxRecord_da = new plxRecord($array);
			return true;
		}
		else return false;
	}

	
	public function parseDonnerAvis($filename) {

		# Mise en place du parseur XML
		$data = implode('',file($filename));
		$parser = xml_parser_create(PLX_CHARSET);
		xml_parser_set_option($parser,XML_OPTION_CASE_FOLDING,0);
		xml_parser_set_option($parser,XML_OPTION_SKIP_WHITE,0);
		xml_parse_into_struct($parser,$data,$values,$iTags);
		xml_parser_free($parser);
		# Recuperation des valeurs de nos champs XML
		$da['author'] = plxUtils::getValue($values[ $iTags['author'][0]]['value']);
		$da['ip'] = plxUtils::getValue($values[$iTags['ip'][0]]['value']);
		$da['stars'] = plxUtils::getValue($values[$iTags['stars'][0]]['value']);
		$da['actmail'] = plxUtils::getValue($values[$iTags['actmail'][0]]['value']);		
		$da['avis'] = plxUtils::getValue($values[$iTags['avis'][0]]['value']);
		$da['content'] = trim($values[ $iTags['content'][0] ]['value']);
		# Informations obtenues en analysant le nom du fichier
		$tmp1 = substr((basename($filename)),-11,-7);
		$tmpart = substr((basename($filename)),-16,-12);
		if (substr((basename($filename)),0,1) == '_') {
		$tmp = substr((basename($filename)),1,12);
		$status = 'offline';
		} else {
		$tmp = substr((basename($filename)),0,12);
		$status = 'online';
		}
		$da['nbnote'] = $tmp1;
		$da['status'] = $status;
		$da['date'] = $tmp;
		$da['idart'] = $tmpart;
		# On retourne le tableau
		return $da;
	}
	
	public function addDonnerAvis($content) {
		# On genere le contenu de notre fichier XML
		$xml = "<?xml version='1.0' encoding='".PLX_CHARSET."'?>\n";
		$xml .= "<comment>\n";
		$xml .= "\t<author><![CDATA[".plxUtils::cdataCheck($content['author'])."]]></author>\n";
		$xml .= "\t<ip>".$content['ip']."</ip>\n";
		$xml .= "\t<stars><![CDATA[".plxUtils::cdataCheck($content['stars'])."]]></stars>\n";
		$xml .= "\t<actmail><![CDATA[".plxUtils::cdataCheck($content['actmail'])."]]></actmail>\n";		
		$xml .= "\t<avis><![CDATA[".plxUtils::cdataCheck($content['avis'])."]]></avis>\n";
		$xml .= "\t<content><![CDATA[".plxUtils::cdataCheck($content['content'])."]]></content>\n";
		$xml .= "</comment>\n";
		# On ecrit ce contenu dans notre fichier XML
		$filename = $content['id'].'_da.xml';
		return plxUtils::write($xml, $this->pathname.$filename);
	}

	public function modDonnerAvis(&$id, $mod) {

		# Gnration du nom du fichier
		$oldfilename = $this->pathname.$id.'_da.xml';
		if(!file_exists($oldfilename)) # message inexistante
			return plxMsg::Error(L_ERR_UNKNOWN_COMMENT);
		# Valider
		if ($mod == 'online')
			$id=substr($id,-23);
		    echo $id;
		# Modrer 
		if($mod=='offline')
		    if (substr($id,0,1)!='_')
			$id = '_'.$id;
		# Gnration du nouveau nom de fichier
		$newfilename = $this->pathname.$id.'_da.xml';
		# On renomme le fichier
		@rename($oldfilename,$newfilename);
		# Contrle
		if(is_readable($newfilename)) {
			if($type == 'online')
				return plxMsg::Info(L_COMMENT_VALIDATE_SUCCESSFUL);
			else
				return plxMsg::Info(L_COMMENT_MODERATE_SUCCESSFUL);
		} else {
			if($type == 'online')
				return plxMsg::Error(L_COMMENT_VALIDATE_ERR);
			else
				return plxMsg::Error(L_COMMENT_MODERATE_ERR);
		}
	}

	public function editDonnerAvis($content, &$id) {

		$comment=array();
		# Gnration du nom du fichier
		$comment['filename'] = $id.'_da.xml';
		if(!file_exists($this->pathname.$comment['filename'])) # Message inexistant
			return plxMsg::Error(L_ERR_UNKNOWN_COMMENT);
		# Controle des saisies
		if(trim($content['avis'])=='')
			return plxMsg::Error(L_ERR_INVALID_SITE);
		# On rcupre les infos du Message
		$com = $this->parseDonnerAvis($this->pathname.$comment['filename']);
		# Formatage des donnes
		$comment['author'] = plxUtils::strCheck(trim($content['author']));
		$comment['avis'] = plxUtils::strCheck(trim($content['avis']));
		$comment['ip'] = $com['ip'];
		$comment['stars'] = $content['stars'];
		 if (isset($content['actmail'])) { $comment['actmail'] = 'on'; } else { $comment['actmail'] = 'off'; }
		$comment['content'] = $content['content'];		
		# Gnration du nouveau nom du fichier
		#$time = explode(':', $content['time']);
		#if (substr($id, 0, 1) != '_') { $first = '_'; } else { $first = ''; }
		#$idnew = $first.$content['year'].$content['month'].$content['day'].$time[0].$time[1].substr($id, -5);
		$idnew = $id;
		# Suppression de l'ancien Message
		$this->delDonnerAvis($id);
		# Cration du nouveau Message
		$comment['id'] = $idnew;
		if($this->addDonnerAvis($comment)) { 
		    $_POST['idDA'] = $idnew;
			return plxMsg::Info(L_COMMENT_SAVE_SUCCESSFUL);
		} else {
			return plxMsg::Error(L_COMMENT_UPDATE_ERR);
		}	
	}

	
	public function daDate($format='#day #num_day #month #num_year(4) &agrave; #hour:#minute') {

		echo plxDate::formatDate($this->plxRecord_da->f('date'),$format);
	}	


	public function daContent() {

		echo nl2br($this->plxRecord_da->f('content'));
	}
	
	public function nbDonnerAvis($select='online') {

		$nb = 0;
		if($select == 'all')
			$motif = '/[^[:punct:]?][0-9]{4}.(.*).xml$/';
		elseif($select=='offline')
			$motif = '/^_[0-9]{4}.(.*).xml$/';
		elseif($select=='online')
			$motif = '/^[0-9]{4}.(.*).xml$/';
		else
			$motif = $select;

		if($coms = $this->getDirectoryTree($this->pathname,'xml','sort',$select))
			$nb = sizeof($coms);

		return $nb;
	}
	
	public function nbDonnerAvisByart($select='online', $idart) {

		$nb = 0;
		$idart = 'a'.$idart;
		$comsart = Array();
		if($select == 'all')
			$motif = '/[^[:punct:]?][0-9]{4}.(.*).xml$/';
		elseif($select=='offline')
			$motif = '/^_[0-9]{4}.(.*).xml$/';
		elseif($select=='online')
			$motif = '/^[0-9]{4}.(.*).xml$/';
		else
			$motif = $select;

		if($coms = $this->getDirectoryTree($this->pathname,'xml','sort',$select)) {
			foreach ($coms as $str) {
				if (strpos($str, $idart)) {
					$comsart[] = $str;
				}
			}
			if (!empty($comsart)) {
				$nb = sizeof($comsart);
			} else {
				$nb = 0;
			}
		}	

		return $nb;
	}	

	public function delDonnerAvis($id) {

		# Gnration du nom du fichier
		$filename = $this->pathname.$id.'_da.xml';
		# Suppression du Message
		if(file_exists($filename)) {
			unlink($filename);
		}
		
		if(!file_exists($filename))
			return plxMsg::Info(L_COMMENT_DELETE_SUCCESSFUL);
		else
			return plxMsg::Error(L_COMMENT_DELETE_ERR);
	}

	public function getPageda() {

		# Initialisation
		$pageName = basename($_SERVER['PHP_SELF']);
		$savePage = preg_match('/admin\/(index|plugin).php/', $_SERVER['PHP_SELF']);
		# On check pour avoir le numero de page
		if(!empty($_GET['page']) AND is_numeric($_GET['page']) AND $_GET['page'] > 0)
			$this->page = $_GET['page'];
		elseif($savePage) {
			if(!empty($_POST['sel_cat']))
				$this->page = 1;
			else
				$this->page = !empty($_SESSION['page'][$pageName])?intval($_SESSION['page'][$pageName]):1;
		}
		# On sauvegarde
		if($savePage) $_SESSION['page'][$pageName] = $this->page;
	}	
	
	public function getPagedafront() {

		# Initialisation
		$pageName = basename($_SERVER['PHP_SELF']);
		$savePage = preg_match('/\/(index|plugin).php/', $_SERVER['PHP_SELF']);
		# On check pour avoir le numero de page
		if(!empty($_GET['page']) AND is_numeric($_GET['page']) AND $_GET['page'] > 0)
			$this->page = $_GET['page'];
		elseif($savePage) {
			if(empty($_GET['page']))
				$this->page = 1;
			else
				$this->page = !empty($_SESSION['page'][$pageName])?intval($_SESSION['page'][$pageName]):1;
		}
		# On sauvegarde
		if($savePage) $_SESSION['page'][$pageName] = $this->page;
	}	
	
	public function notificationda() {
		$nb = '';
	    if(is_dir(PLX_ROOT.PLX_CONFIG_PATH.'plugins/davis')) {
			if ($this->nbDonnerAvis('offline') != 0) {
				$nb =' ['.$this->nbDonnerAvis('offline').']';
			}
		}
		return $nb;
	}
	
	public function getDirectoryTree($Dir,$ext,$ordre='sort',$type='all',$depart='0',$limite=false,$idart='all'){ 
		if ($ordre == 'sort') {
			$dirs = @array_diff(scandir($Dir), Array( ".", ".." )); 
		} else {
			$dirs = @array_diff(scandir($Dir,1), Array( ".", ".." )); 
		}
		$dir_array = Array(); 
		$comsart = Array();
		foreach($dirs as $d){ 
			if(is_dir($Dir.$d)){ 
				$dir_array[$d] = getDirectoryTree( $Dir."/".$d , $ext); 
			}else{ 
			if (($ext)?preg_match('/'.$ext.'/',$d):1)
			    if ($type == 'all') {
					$dir_array[] = $d; 
				} elseif ($type == 'online') {
					if (substr($d,0,1) != '_') {
						$dir_array[] = $d;
					}	
				} elseif ($type == 'offline') {
					if (substr($d,0,1) == '_') {
						$dir_array[] = $d;
					}
				} else { 
					if (substr($d,0,strlen($type)) == $type ) {
						$dir_array[] = $d;
					}
					}
				}		
            } 
		if ($idart != 'all') {
			$idart = 'a'.$idart;
			foreach ($dir_array as $str) {
				if (strpos($str, $idart)) {
					$comsart[] = $str;
				}
			}
			$dir_array = $comsart;
		}
		# On a une limite, on coupe le tableau
		if($limite)
			$dir_array = array_slice($dir_array,$depart,$limite);
		# On retourne le tableau
		return $dir_array; 
	}
	
	 public function nextIdDA() {
		$idDA = $this->getDirectoryTree($this->pathname,'xml','rsort','all');
			if($idDA) { # On a des fichiers
			foreach($idDA as $k=>$v) # On parcourt tous les fichiers
				$array[ $k ] = substr((basename($this->pathname.$v)),-11,-7);
				rsort($array);
			return str_pad($array['0']+1, 4, "0", STR_PAD_LEFT);
			#return $array['0']+1;
		}
		else return '0001';
	}	
	
	public function Pagination($nbDAPagination,$bypage) {
	
		$plxMotor = plxMotor::getInstance();
		$this->getPagedaFront();
	
		# Calcul des pages
		$last_page = ceil($nbDAPagination/$bypage);
		if($this->page > $last_page) $this->page = $last_page;
		$prev_page = $this->page - 1;
		$next_page = $this->page + 1;
		# Generation des URLs
		$f_url = $plxMotor->urlRewrite('index.php?donneravis&page=1'); # Premiere page
		$p_url = $plxMotor->urlRewrite('index.php?donneravis&page='.$prev_page); # Page precedente
		$n_url = $plxMotor->urlRewrite('index.php?donneravis&page='.$next_page); # Page suivante	
		$l_url = $plxMotor->urlRewrite('index.php?donneravis&page='.$last_page); # Derniere page	
		# On effectue l'affichage
		if($this->page > 2) # Si la page active > 2 on affiche un lien 1ere page
			echo '<span class="p_first"><a href="'.$f_url.'" title="'.ucfirst(L_PAGINATION_FIRST_TITLE).'">'.ucfirst(L_PAGINATION_FIRST).'</a>&nbsp;</span>';
		if($this->page > 1) # Si la page active > 1 on affiche un lien page precedente
			echo '<span class="p_prev"><a href="'.$p_url.'" title="'.ucfirst(L_PAGINATION_PREVIOUS_TITLE).'">'.ucfirst(L_PAGINATION_PREVIOUS).'</a>&nbsp;</span>';
		# Affichage de la page courante
		printf('<span class="p_page">'.ucfirst(L_PAGINATION).'</span>',$this->page,$last_page);
		if($this->page < $last_page) # Si la page active < derniere page on affiche un lien page suivante
			echo '<span class="p_next">&nbsp;<a href="'.$n_url.'" title="'.ucfirst(L_PAGINATION_NEXT_TITLE).'">'.ucfirst(L_PAGINATION_NEXT).'</a></span>';
		if(($this->page + 1) < $last_page) # Si la page active++ < derniere page on affiche un lien derniere page
			echo '<span class="p_last">&nbsp;<a href="'.$l_url.'" title="'.ucfirst(L_PAGINATION_LAST_TITLE).'">'.ucfirst(L_PAGINATION_LAST).'</a></span>';
	}

	public function RedirDA($url){
		$plxMotor = plxMotor::getInstance();
	    $r_url = $plxMotor->urlRewrite($url);
		echo "<script type=\"text/javascript\">setTimeout('window.location=\"$r_url\";',3000);</script>";
	}
	
	public function cutString($string, $start, $length, $endStr = '[&hellip]'){
		if( strlen( $string ) <= $length ) return $string;
			$str = mb_substr( $string, $start, $length - strlen( $endStr ) + 1, 'UTF-8');
		return substr( $str, 0, strrpos( $str,' ') ).$endStr;
	}

	public function rating($art, $nbstar, $totalnbStars=5, $colorStar='ffae00') {
	    if (empty($nbstar)) $nbstar = 0;
		echo '<div class="rating">';
		echo '<div class="star_small">';
		for ($i = 1; $i <= $nbstar; $i++) {
			echo '<i class="fa fa-star selected" style="color: #'.$colorStar.';"></i>';
		}
		for ($i = ($nbstar+1); $i <= $totalnbStars; $i++) {
			echo '<i class="fa fa-star-o" style="color: #'.$colorStar.';"></i>';
		}
		echo '</div>';
		echo '<div itemscope itemtype="http://schema.org/Product">';
		echo '<div itemprop="aggregateRating" itemscope itemtype="http://schema.org/AggregateRating">';
		echo '&nbsp;&nbsp;&nbsp;&nbsp;<span itemprop="ratingValue">'.$nbstar.'</span>/<span itemprop="bestRating">'.$totalnbStars.'</span>';
		echo '<span itemprop="ratingCount" class="transparent">'.$totalnbStars.'</span>';
		echo '<span itemprop="name" class="transparent">'.$art.'</span>';
		echo '</div>';
		echo '<span itemprop="name" class="transparent">'.$art.'</span>';
		echo '</div>';
		echo '<div style="clear: both"></div>';
		echo '</div>';
	}
	
	public function my_simple_crypt( $string, $action = 'e' ) {
		// you may change these values to your own
		$secret_key = 'h4ry5cjr79td';
		$secret_iv = '2r4fu3z8t2c5';
 
		$output = false;
		$encrypt_method = "AES-256-CBC";
		$key = hash( 'sha256', $secret_key );
		$iv = substr( hash( 'sha256', $secret_iv ), 0, 16 );
 
		if( $action == 'e' ) {
			$output = base64_encode( openssl_encrypt( $string, $encrypt_method, $key, 0, $iv ) );
		}
		else if( $action == 'd' ){
			$output = openssl_decrypt( base64_decode( $string ), $encrypt_method, $key, 0, $iv );
		}
 
		return $output;
	}	
	
	/**
	 * Verification des version des plugins
	 *
	 * @param	plugin				le nom du plugin
	 * @return	array()
	 * @author	DPFPIC
	 **/
	public function UpdatePlugin($plugin) {
	    $array = array();
		$url = 'http://dpfpic.com/plugins.rep';
		$filename = PLX_PLUGINS.$plugin.'/infos.xml';
		
		# Mise en place du parseur XML
		$data = implode('',file($filename));
		$parser = xml_parser_create('UTF-8');
		xml_parser_set_option($parser,XML_OPTION_CASE_FOLDING,0);
		xml_parser_set_option($parser,XML_OPTION_SKIP_WHITE,0);
		xml_parse_into_struct($parser,$data,$strings,$iTags);
		xml_parser_free($parser);
		# Rcupration des donnes xml
		$array['actualversion'] = plxUtils::getValue($strings[$iTags['version'][0]]['value']);
		$array['actualdate'] = plxUtils::getValue($strings[$iTags['date'][0]]['value']);


		if (ini_get('allow_url_fopen')) {
			$handleplugin = @file($url);
		}
		elseif ($curl = @curl_init()){
			$timeout = 5; // set to zero for no timeout
			curl_setopt ($curl, CURLOPT_URL, $url);
			curl_setopt ($curl, CURLOPT_CONNECTTIMEOUT, $timeout);
			curl_setopt ($curl, CURLOPT_RETURNTRANSFER, 1);
			$version_content = curl_exec($curl);
			curl_close($curl);
			if ($version_content != false) {
				$handleplugin = explode("\n", $version_content);
			}
		}	
		if ($handleplugin) {
			$nb = sizeof($handleplugin);
			for($i=0;$i<$nb;$i++) {
				$seach = strstr($handleplugin[$i], '||', true);
				if ($seach == $plugin) {
				    $value = explode('||', $handleplugin[$i]);
					$array['newplugin'] = $value[0];
					$array['newversion'] = $value[1];
					$array['newdate'] = $value[2];
					$array['newurl'] = $value[3];
					$array['active'] = $value[4];
				}
			}
		} else {
			$array ['status'] = 0;
			return $array;
		}
		
		$adate = explode("/", $array['actualdate']); 
		$ndate = explode("/", $array['newdate']);
		$actualdate = $adate[2].$adate[1].$adate[0];
		$newdate = $ndate[2].$ndate[1].$ndate[0];
		
		if (isset($array['actualversion']) AND ($array['actualversion'] == $array['newversion']  AND  $actualdate == $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 1;
			return $array;
		} elseif (isset($array['actualversion']) AND ($array['actualversion'] != $array['newversion'] OR  $actualdate != $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 2;
			return $array;
		} elseif (isset($array['active']) AND $array['active'] == 0) {
			$array ['status'] = 3;
			return $array;
		} else {
		    $array ['status'] = 0;
			return $array;
		}
	}		
}	