<?php if(!defined('PLX_ROOT')) exit; ?>
<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/

# Control du token du formulaire
plxToken::validateFormToken($_POST);

# Control de l'accès à la page en fonction du profil de l'utilisateur connecté
$plxAdmin->checkProfil(PROFIL_ADMIN, PROFIL_MANAGER, PROFIL_MODERATOR);

if (!isset($_GET['da'])) {
# Suppression des message selectionnes
if (isset($_POST['selection']) AND ((!empty($_POST['btn_ok1']) AND $_POST['selection'][0]=='delete') OR (!empty($_POST['btn_ok2']) AND $_POST['selection'][1]=='delete') AND isset($_POST['idDA']))) {
	foreach ($_POST['idDA'] as $k => $v) $plxPlugin->donneravis->delDonnerAvis($v);
	header('Location: plugin.php?p=plxDonnerAvis');
	exit;
}
# Validation des message selectionnes
elseif(isset($_POST['selection']) AND (!empty($_POST['btn_ok1']) AND ($_POST['selection'][0]=='online') OR (!empty($_POST['btn_ok2']) AND $_POST['selection'][1]=='online')) AND isset($_POST['idDA'])) {
	foreach ($_POST['idDA'] as $k => $v) $plxPlugin->donneravis->modDonnerAvis($v, 'online');
	header('Location: plugin.php?p=plxDonnerAvis');
	exit;
}
# Mise hors-ligne des message selectionnes
elseif (isset($_POST['selection']) AND ((!empty($_POST['btn_ok1']) AND $_POST['selection'][0]=='offline') OR (!empty($_POST['btn_ok2']) AND $_POST['selection'][1]=='offline')) AND isset($_POST['idDA'])) {
	foreach ($_POST['idDA'] as $k => $v) $plxPlugin->donneravis->modDonnerAvis($v, 'offline');
	header('Location: plugin.php?p=plxDonnerAvis');
	exit;
}
elseif (!empty($_POST['update']) AND isset($_POST['idDA'])) {
# Edition
	$plxPlugin->donneravis->editDonnerAvis($_POST,$_POST['idDA']);
	header('Location: plugin.php?p=plxDonnerAvis&da='.$_POST['idDA']);
	exit;
}
elseif (isset($_POST['online'])) {
# Commentaire en ligne
	$plxPlugin->donneravis->editDonnerAvis($_POST,$_POST['idDA']);
	$plxPlugin->donneravis->modDonnerAvis($_POST['idDA'],'online');
	header('Location: plugin.php?p=plxDonnerAvis&da='.$_POST['idDA']);
	exit;
}
elseif (isset($_POST['offline'])) { 
# Commentaire hors-ligne
	$plxPlugin->donneravis->editDonnerAvis($_POST,$_POST['idDA']);
	$plxPlugin->donneravis->modDonnerAvis($_POST['idDA'],'offline');
	header('Location: plugin.php?p=plxDonnerAvis&da='.$_POST['idDA']);
	exit;
}
elseif (!empty($_POST['btn_ok3']) AND $_POST['selection']=='delete') {
# Suppression des message selectionnes
	$plxPlugin->donneravis->delDonnerAvis($_POST['idDA']);
	header('Location: plugin.php?p=plxDonnerAvis');
	exit;
}

# Récuperation du type de commentaire à afficher
$_GET['sel'] = !empty($_GET['sel']) ? $_GET['sel'] : '';
if(in_array($_GET['sel'], array('online', 'offline', 'all')))
	$daSel = plxUtils::nullbyteRemove($_GET['sel']);
else
	$daSel = ((isset($_SESSION['selDA']) AND !empty($_SESSION['selDA'])) ? $_SESSION['selDA'] : 'all');

if($daSel=='online') {
	$daSelMotif = '/^[0-9]{4}.(.*).xml$/';
	$_SESSION['selDA'] = 'online';
	$nbComPagination=$plxPlugin->donneravis->nbDonnerAvis('online');
	echo '<h2>'.$plxPlugin->getlang('L_DA_ONLINE_LIST').'</h2>';
}
elseif($daSel=='offline') {
	$daSelMotif = '/^_[0-9]{4}.(.*).xml$/';
	$_SESSION['selDA'] = 'offline';
	$nbComPagination=$plxPlugin->donneravis->nbDonnerAvis('offline');
	echo '<h2>'.$plxPlugin->getlang('L_DA_OFFLINE_LIST').'</h2>';
}
elseif($daSel=='all') { // all
	$daSelMotif = '/^[[:punct:]]?[0-9]{4}.(.*).xml$/';
	$_SESSION['selDA'] = 'all';
	$nbComPagination=$plxPlugin->donneravis->nbDonnerAvis('all');
	echo '<h2>'.$plxPlugin->getlang('L_DA_ALL_LIST').'</h2>';
}


$breadcrumbs = array();
$breadcrumbs[] = '<a '.($_SESSION['selDA']=='all'?'class="selected" ':'').'href="plugin.php?p=plxDonnerAvis&sel=all&amp;page=1">'.$plxPlugin->getLang('L_DA_ALL').'</a>&nbsp;('.$plxPlugin->donneravis->nbDonnerAvis('all').')';
$breadcrumbs[] = '<a '.($_SESSION['selDA']=='online'?'class="selected" ':'').'href="plugin.php?p=plxDonnerAvis&sel=online&amp;page=1">'.$plxPlugin->getLang('L_DA_ONLINE').'</a>&nbsp;('.$plxPlugin->donneravis->nbDonnerAvis('online').')';
$breadcrumbs[] = '<a '.($_SESSION['selDA']=='offline'?'class="selected" ':'').'href="plugin.php?p=plxDonnerAvis&sel=offline&amp;page=1">'.$plxPlugin->getLang('L_DA_OFFLINE').'</a>&nbsp;('.$plxPlugin->donneravis->nbDonnerAvis('offline').')';

$offline = $plxPlugin->getlang('L_DA_SET_OFFLINE');
$online = $plxPlugin->getlang('L_DA_SET_ONLINE');
$delete = $plxPlugin->getlang('L_DA_DELETE');
$selection = $plxPlugin->getlang('L_DA_FOR_SELECTION');

function selector($daSel, $id) {
    global $offline, $online, $delete, $selection;
    ob_start();
	if($daSel=='online')
		plxUtils::printSelect('selection[]', array(''=> $selection, 'offline' => $offline, '-'=>'-----', 'delete' => $delete), '', false,'',$id);
	elseif($daSel=='offline')
		plxUtils::printSelect('selection[]', array(''=> $selection, 'online' => $online, '-'=>'-----', 'delete' => $delete), '', false,'',$id);
	elseif($daSel=='all')
		plxUtils::printSelect('selection[]', array(''=> $selection, 'online' => $online, 'offline' => $offline,  '-'=>'-----','delete' => $delete), '', false,'',$id);
	return ob_get_clean();
}

$selector1=selector($daSel, 'id_selection1');
$selector2=selector($daSel, 'id_selection2');
?>
<form action="plugin.php?p=plxDonnerAvis<?php echo !empty($_GET['a'])?'&a='.$_GET['a']:'' ?>" method="post" id="form_comments">

<div class="inline-form action-bar">
<h2><?php $plxPlugin->lang('L_PAGE_TITLE') ?></h2>
<p class="breadcrumbs">
	<?php echo implode('&nbsp;|&nbsp;', $breadcrumbs); ?>
</p>
<p>
	<?php echo plxToken::getTokenPostMethod() ?>
	<?php echo $selector1 ?><input type="submit" name="btn_ok1" value="<?php echo L_OK ?>" onclick="return confirmAction(this.form, 'id_selection1', 'delete', 'idDA[]', '<?php echo L_CONFIRM_DELETE ?>')" />
</p>
</div>
<div class="scrollable-table">
<table id="da-table" class="full-width">
<thead>
	<tr>
		<th class="checkbox"><input type="checkbox" onclick="checkAll(this.form, 'idDA[]')" /></th>
		<th class="nbnote"><?php $plxPlugin->lang('L_DA_LIST_ID') ?></th>		
		<th class="datetime"><?php $plxPlugin->lang('L_DA_LIST_DATE') ?></th>
		<th class="avis"><?php $plxPlugin->lang('L_DA_LIST_AVIS') ?></th>
		<th class="message"><?php $plxPlugin->lang('L_DA_LIST_MESSAGE') ?></th>
		<th class="author"><?php $plxPlugin->lang('L_DA_LIST_AUTHOR') ?></th>
		<th class="action"><?php $plxPlugin->lang('L_DA_LIST_ACTION') ?></th>
	</tr>
</thead>
<tbody>

<?php
# On va récupérer les messages
$plxPlugin->donneravis->getPageda();
$savePage = preg_match('/admin\/(index|plugin).php/', $_SERVER['PHP_SELF']);
$bypage_admin_da = 10;
$start = $bypage_admin_da*($plxPlugin->donneravis->page-1);
$guestb = $plxPlugin->donneravis->getDonnerAvis('rsort',$daSel,$start,$bypage_admin_da);

if($guestb) {
	$num=0;
	while($plxPlugin->donneravis->plxRecord_da->loop()) { # On boucle
		$artId = $plxPlugin->donneravis->plxRecord_da->f('idart');
		$status = $plxPlugin->donneravis->plxRecord_da->f('status');
		if ($status == 'online') { $first = ''; } else { $first = '_'; }
		$id = $first.$plxPlugin->donneravis->plxRecord_da->f('date').'_a'.$plxPlugin->donneravis->plxRecord_da->f('idart').'_'.$plxPlugin->donneravis->plxRecord_da->f('nbnote');
		$content = $plxPlugin->donneravis->cutString(nl2br($plxPlugin->donneravis->plxRecord_da->f('content')), 0, 50, ' ...');
		if($_SESSION['selDA']=='all') {
			$content = $content.' - <strong>'.($status=='online'?$plxPlugin->getlang('L_DA_ONLINE'):$plxPlugin->getlang('L_DA_OFFLINE')).'</strong>';
		}
		# On génère notre ligne
		echo '<tr class="line-'.(++$num%2).' top type-'.$plxPlugin->donneravis->plxRecord_da->f('type').'">';
		echo '<td><input type="checkbox" name="idDA[]" value="'.$id.'" /></td>';
		echo '<td class="nbnote">'.$plxPlugin->donneravis->plxRecord_da->f('nbnote').'&nbsp;</td>';		
		echo '<td class="datetime">'.plxDate::formatDate($plxPlugin->donneravis->plxRecord_da->f('date')).'&nbsp;</td>';
		echo '<td class="avis"><a href="plugin.php?p=plxDonnerAvis&da='.$id.'">'.$plxPlugin->donneravis->plxRecord_da->f('avis').'</a>&nbsp;</td>';	
		echo '<td>'.strip_tags($content).'&nbsp;</td>';
		echo '<td>'.plxUtils::strCut($plxPlugin->donneravis->plxRecord_da->f('author'),30).'&nbsp;</td>';
		echo '<td class="action">';
		echo '<a href="plugin.php?p=plxDonnerAvis&da='.$id.'" title="'.$plxPlugin->getlang('L_DA_EDIT_TITLE').'">'.$plxPlugin->getlang('L_DA_EDIT').'</a>&nbsp;&nbsp;';
		if ($artId !='0000') {
			echo '<a href="article.php?a='.$artId.'" title="'.L_COMMENT_ARTICLE_LINKED_TITLE.'">'.L_COMMENT_ARTICLE_LINKED.'</a>';
		}
		echo '</td></tr>';
	}
} else { # Pas de message
	echo '<tr><td colspan="7" class="center">'.$plxPlugin->getlang('L_DA_NO_MESSAGE').'</td></tr>';
}
?>
</tbody>
</table>
</div>
</form>

<div id="pagination">
<p>
<?php
# Affichage de la pagination
if($guestb) { # Si on a des message (hors page)
	# Calcul des pages
	$last_page = ceil($nbComPagination/$bypage_admin_da);
	if($plxPlugin->donneravis->page > $last_page) $plxPlugin->donneravis->page = $last_page;
	$prev_page = $plxPlugin->donneravis->page - 1;
	$next_page = $plxPlugin->donneravis->page + 1;
	# Generation des URLs
	$p_url = 'plugin.php?p=plxDonnerAvis&page='.$prev_page.'&amp;sel='.$_SESSION['selDA']; # Page precedente
	$n_url = 'plugin.php?p=plxDonnerAvis&page='.$next_page.'&amp;sel='.$_SESSION['selDA']; # Page suivante
	$l_url = 'plugin.php?p=plxDonnerAvis&page='.$last_page.'&amp;sel='.$_SESSION['selDA']; # Derniere page
	$f_url = 'plugin.php?p=plxDonnerAvis&page=1'.'&amp;sel='.$_SESSION['selDA']; # Premiere page
	# On effectue l'affichage
	if($plxPlugin->donneravis->page > 2) # Si la page active > 2 on affiche un lien 1ere page
		echo '<span class="p_first"><a href="'.$f_url.'" title="'.L_PAGINATION_FIRST_TITLE.'">'.L_PAGINATION_FIRST.'</a></span>';
	if($plxPlugin->donneravis->page > 1) # Si la page active > 1 on affiche un lien page precedente
		echo '<span class="p_prev"><a href="'.$p_url.'" title="'.L_PAGINATION_PREVIOUS_TITLE.'">'.L_PAGINATION_PREVIOUS.'</a></span>';
	# Affichage de la page courante
	printf('<span class="p_page">'.L_PAGINATION.'</span>',$plxPlugin->donneravis->page,$last_page);
	if($plxPlugin->donneravis->page < $last_page) # Si la page active < derniere page on affiche un lien page suivante
		echo '<span class="p_next"><a href="'.$n_url.'" title="'.L_PAGINATION_NEXT_TITLE.'">'.L_PAGINATION_NEXT.'</a></span>';
	if(($plxPlugin->donneravis->page + 1) < $last_page) # Si la page active++ < derniere page on affiche un lien derniere page
		echo '<span class="p_last"><a href="'.$l_url.'" title="'.L_PAGINATION_LAST_TITLE.'">'.L_PAGINATION_LAST.'</a></span>';
}
?>
</p>
</div>
<?php } else {

$guestb = $plxPlugin->donneravis->getDonnerAvis('rsort',$_GET['da']);

# Statut de le message
if ($plxPlugin->donneravis->plxRecord_da->f('status') == 'offline') {
	$statut = '<strong>'.$plxPlugin->getlang('L_DA_OFFLINE').'</strong>';
} else {
	$statut = '<strong>'.$plxPlugin->getlang('L_DA_ONLINE').'</strong>';
}	
# Date du commentaire
$date = plxDate::date2Array($plxPlugin->donneravis->plxRecord_da->f('date'));

# Email visible
$actmail = plxUtils::strCheck($plxPlugin->donneravis->plxRecord_da->f('actmail'));

# On inclut le header
#include(dirname(__FILE__).'/top.php');
?>
<link rel="stylesheet" href="<?php echo PLX_PLUGINS; ?>plxDonnerAvis/css/config.css" type="text/css" media="screen" />
<form action="plugin.php?p=plxDonnerAvis" method="post" id="form_comment">
	<div class="inline-form action-bar">
	    <h2><?php $plxPlugin->lang('L_DA_EDITING') ?></h2>	
		<p class="back"><a href="plugin.php?p=plxDonnerAvis"><?php $plxPlugin->lang('L_DA_BACK_TO_MESSAGES') ?></a></p>
		<?php echo plxToken::getTokenPostMethod() ?>
		<input class="red" type="submit" name="btn_ok3" value="<?php $plxPlugin->lang('L_DA_DELETE') ?>" onclick="Check=confirm('<?php $plxPlugin->lang('L_DA_DELETE_CONFIRM') ?>');if(Check==false) return false;"/>
		&nbsp;&nbsp;&nbsp;&nbsp;
		<?php if(substr($_GET['da'],0,1) == '_') : ?>
		<input type="submit" name="online" value="<?php $plxPlugin->lang('L_DA_PUBLISH_BUTTON') ?>" />
		<?php else : ?>
		<input type="submit" name="offline" value="<?php $plxPlugin->lang('L_DA_OFFLINE_BUTTON') ?>" />
		<?php endif; ?>
		&nbsp;&nbsp;&nbsp;&nbsp;
		<input type="submit" name="update" value="<?php $plxPlugin->lang('L_DA_UPDATE_BUTTON') ?>" />
	</div>

	<ul>
		<li><?php $plxPlugin->lang('L_DA_ID') ?> : <?php echo $plxPlugin->donneravis->plxRecord_da->f('nbnote'); ?></li> 
		<li><?php $plxPlugin->lang('L_DA_IP_FIELD') ?> : <?php echo $plxPlugin->donneravis->plxRecord_da->f('ip'); ?></li>
		<li><?php $plxPlugin->lang('L_DA_STATUS_FIELD') ?> : <?php echo $statut; ?></li>
		<?php if($plxPlugin->donneravis->plxRecord_da->f('idart') != '000') { ?>
		<li><?php $plxPlugin->lang('L_DA_ID_ARTICLE') ?> : <a href="article.php?a=<?php echo $plxPlugin->donneravis->plxRecord_da->f('idart'); ?>"><?php echo $plxPlugin->donneravis->plxRecord_da->f('idart'); ?></a></li>
		<?php } ?>
		<li><div class="rating-review">
		<?php $plxPlugin->donneravis->rating($plxPlugin->donneravis->plxRecord_da->f('idart'), $plxPlugin->donneravis->plxRecord_da->f('stars'), $plxPlugin->getParam('nbStars'), $plxPlugin->getParam('colorStar')); ?>
		</div></li>
	</ul>
	
	<fieldset>
		<?php plxUtils::printInput('stars',$plxPlugin->donneravis->plxRecord_da->f('stars'),'hidden'); ?>
		<?php plxUtils::printInput('idDA',$_GET['da'],'hidden'); ?>
        <?php plxUtils::printInput('selection','delete','hidden'); ?>
		<?php plxUtils::printInput('day', $date['day'],'hidden'); ?>
		<?php plxUtils::printInput('month',$date['month'],'hidden'); ?>
		<?php plxUtils::printInput('year',$date['year'],'hidden'); ?>
		<?php plxUtils::printInput('time',$date['time'],'hidden'); ?>
		<p>
		<?php echo $plxPlugin->getLang('L_DA_DATE_FIELD').' '.$date['day'].'/'.$date['month'].'/'.$date['year'].' '.$plxPlugin->getLang('L_DA_TIME_FIELD').' '.$date['time']; ?>
		<p><label for="id_author"><?php $plxPlugin->lang('L_DA_AUTHOR_FIELD') ?> :</label>
		<?php plxUtils::printInput('author',plxUtils::strCheck($plxPlugin->donneravis->plxRecord_da->f('author')),'text','40-255') ?></p>
		<?php $avis = plxUtils::strCheck($plxPlugin->donneravis->plxRecord_da->f('avis')); ?>
		<p><label for="id_avis"><?php $plxPlugin->lang('L_DA_AVIS_FIELD') ?> :</label>
		<?php
			plxUtils::printInput('avis',$avis,'text','40-255');
		?></p>
		<p id="p_content"><label for="id_content"><?php $plxPlugin->lang('L_DA_MESSAGE_FIELD') ?> :</label></p>
		<?php plxUtils::printArea('content',$plxPlugin->donneravis->plxRecord_da->f('content'), 60, 7); ?>
	</fieldset>
</form>
<?php } ?>
