<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/
include(dirname(__FILE__).'/lib/class.plx.bannersquotes.php');
 
class plxBannersQuotes extends plxPlugin {

	/**
	 * Constructeur de la classe
	 *
	 * @param	default_lang	langue par défaut utilisée par PluXml
	 * @return	null
	 * @author	Stephane F
	 **/
	public function __construct($default_lang) {

		# Appel du constructeur de la classe plxPlugin (obligatoire)
		parent::__construct($default_lang);

		# droits pour accéder à la page config.php et admin.php du plugin
		$this->setConfigProfil(PROFIL_ADMIN);
		$this->setAdminProfil(PROFIL_ADMIN);
		
		# Personnalisation du menu admin
		$this->setAdminMenu($this->getlang('L_BQ_NEW_BANNERQUOTE'),'',$this->getlang('L_BQ_NEW_BANNERQUOTE'));
		
		$this->bannersquotes = new bannersquotes();
		$this->bannersquotes->getBannersQuotes();		
		
		# ajout du hook
		$this->addHook('AdminTopEndHead', 'AdminTopEndHead');		
		$this->addHook('ThemeEndHead', 'ThemeEndHead');	
		$this->addHook('plxShowBannersQuotes', 'plxShowBannersQuotes');		

	}

	public function AdminTopEndHead() {
		echo "\n\t".'<script type="text/javascript" src="'.PLX_PLUGINS.'plxBannersQuotes/js/filemanager.js"></script>';
		echo "\n\t".'
		<script type="text/javascript">
		if (typeof jQuery == "undefined") {
			document.write(\'<script type="text\/javascript" src="'.PLX_PLUGINS.'plxBannersQuotes\/js\/jquery-1.11.0.min.js"><\/script>\');
		}
		</script>';
	}
	
	public function ThemeEndHead() {
		echo "\t".'<link rel="stylesheet" href="'.PLX_PLUGINS.'plxBannersQuotes/css/plxBannersQuotes.css" type="text/css" media="screen" />'."\n";
	}

	public function plxShowBannersQuotes($group) {
	
		$this->bannersquotes->getBannersQuotes($list='ENABLE', $group); # récuperation des bannières actives et du groupe
		$this->bannersquotes->aBannersQuotes = array_values($this->bannersquotes->aBannersQuotes); # réindexation du tableau array
		
		mt_srand($this->bannersquotes->make_seed());
		$id = mt_rand(0,count($this->bannersquotes->aBannersQuotes)-1); # générer un id aléatoire
		
		if ($this->bannersquotes->aBannersQuotes[$id]['type'] == 'b') {
			echo '<div id="banner">';
			echo '<a href="'.$this->bannersquotes->aBannersQuotes[$id]['url'].'" title="'.$this->bannersquotes->aBannersQuotes[$id]['title'].'"><img src="'.$this->bannersquotes->aBannersQuotes[$id]['url_img'].'" alt="'.$this->bannersquotes->aBannersQuotes[$id]['title'].'" /></a>';
		} else {
			echo '<div id="quote">';
			if (plxPlugin::getParam('bqActTxt') == 1) {
				echo '<span class="beforequote">'.plxPlugin::getParam('bqBefQuote').'</span><span> : '.$this->bannersquotes->aBannersQuotes[$id]['title'].'</span>';
			} else {
				echo '<span>'.$this->bannersquotes->aBannersQuotes[$id]['title'].'</span>';
			}
		}
		echo '</div>';
	}

	/**
	 * Verification des version des plugins
	 *
	 * @param	plugin				le nom du plugin
	 * @return	array()
	 * @author	DPFPIC
	 **/
	public function UpdatePlugin($plugin) {
	    $array = array();
		$url = 'http://dpfpic.com/plugins.rep';
		$filename = PLX_PLUGINS.$plugin.'/infos.xml';
		
		# Mise en place du parseur XML
		$data = implode('',file($filename));
		$parser = xml_parser_create('UTF-8');
		xml_parser_set_option($parser,XML_OPTION_CASE_FOLDING,0);
		xml_parser_set_option($parser,XML_OPTION_SKIP_WHITE,0);
		xml_parse_into_struct($parser,$data,$strings,$iTags);
		xml_parser_free($parser);
		# Récupération des données xml
		$array['actualversion'] = plxUtils::getValue($strings[$iTags['version'][0]]['value']);
		$array['actualdate'] = plxUtils::getValue($strings[$iTags['date'][0]]['value']);


		if (ini_get('allow_url_fopen')) {
			$handleplugin = @file($url);
		}
		elseif ($curl = @curl_init()){
			$timeout = 5; // set to zero for no timeout
			curl_setopt ($curl, CURLOPT_URL, $url);
			curl_setopt ($curl, CURLOPT_CONNECTTIMEOUT, $timeout);
			curl_setopt ($curl, CURLOPT_RETURNTRANSFER, 1);
			$version_content = curl_exec($curl);
			curl_close($curl);
			if ($version_content != false) {
				$handleplugin = explode("\n", $version_content);
			}
		}	
		if ($handleplugin) {
			$nb = sizeof($handleplugin);
			for($i=0;$i<$nb;$i++) {
				$seach = strstr($handleplugin[$i], '||', true);
				if ($seach == $plugin) {
				    $value = explode('||', $handleplugin[$i]);
					$array['newplugin'] = $value[0];
					$array['newversion'] = $value[1];
					$array['newdate'] = $value[2];
					$array['newurl'] = $value[3];
					$array['active'] = $value[4];
				}
			}
		} else {
			$array ['status'] = 0;
			return $array;
		}
		
		$adate = explode("/", $array['actualdate']); 
		$ndate = explode("/", $array['newdate']);
		$actualdate = $adate[2].$adate[1].$adate[0];
		$newdate = $ndate[2].$ndate[1].$ndate[0];
		
		if (isset($array['actualversion']) AND ($array['actualversion'] == $array['newversion']  AND  $actualdate == $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 1;
			return $array;
		} elseif (isset($array['actualversion']) AND ($array['actualversion'] != $array['newversion'] OR  $actualdate != $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 2;
			return $array;
		} elseif (isset($array['active']) AND $array['active'] == 0) {
			$array ['status'] = 3;
			return $array;
		} else {
		    $array ['status'] = 0;
			return $array;
		}
	}			
}
?>