<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/
class bannersquotes {

	public $aBannersQuotes = array(); # Tableau de toutes les bannières/citation
	public $aGroups = array(); # Tableau de toutes les groupes	
	
	public function __construct() {
		
		# Vérification de l'existence du dossier /plugins/bannersquotes
		if(!is_dir(PLX_ROOT.PLX_CONFIG_PATH.'plugins/bannersquotes')) {
			@mkdir(PLX_ROOT.PLX_CONFIG_PATH.'plugins/bannersquotes',0755,true);

			# Protection du répertoire bannersquotes
			plxUtils::write('', PLX_ROOT.PLX_CONFIG_PATH.'plugins/bannersquotes/index.html');
			if (!file_exists(PLX_ROOT.PLX_CONFIG_PATH.'plugins/bannersquotes/.htaccess')){
				file_put_contents(PLX_ROOT.PLX_CONFIG_PATH.'plugins/bannersquotes/.htaccess',"<Files *>
	Order allow,deny
	Deny from all
</Files>      
      ");
    }			
		}

		$this->pathname = PLX_ROOT.PLX_CONFIG_PATH.'plugins/bannersquotes/bannersquotes.xml'; # emplacement du fichier des bannières
		$this->pathgroups = PLX_ROOT.PLX_CONFIG_PATH.'plugins/bannersquotes/grpbannersquotes.xml'; # emplacement du fichier des groupes
	}

	public function getBannersQuotes($list='ALL', $group='') {
	
	    $this->aBannersQuotes = array(); # Tableau de toutes les bannières/citations

		if(!is_file($this->pathname)) return;

		# Mise en place du parseur XML
		$data = implode('',file($this->pathname));
		$parser = xml_parser_create(PLX_CHARSET);
		xml_parser_set_option($parser,XML_OPTION_CASE_FOLDING,0);
		xml_parser_set_option($parser,XML_OPTION_SKIP_WHITE,0);
		xml_parse_into_struct($parser,$data,$values,$iTags);
		xml_parser_free($parser);
		if(isset($iTags['bannersquotes']) AND isset($iTags['title'])) {
			$nb = sizeof($iTags['title']);
			$size = ceil(sizeof($iTags['bannersquotes'])/$nb);
			$t = 0;
			for($i=0;$i<$nb;$i++) {
				$attributes = $values[$iTags['bannersquotes'][$i*$size]]['attributes'];				
				if (plxUtils::getValue($values[$iTags['group'][$i]]['value']) == $group OR $group == '') {
				#if (!$active) {$id = $attributes['id']; } else { $id = $t; }
				$id = $attributes['id'];
				if ($list == 'ALL' OR ($list == 'ENABLE' AND $attributes['active'] == 1)) {
				# Recuperation du type bannière ou citation
				$this->aBannersQuotes[$id]['type']=plxUtils::getValue($values[$iTags['type'][$i]]['value']);				
				# Recuperation du titre de la bannière ou de la citation
				$this->aBannersQuotes[$id]['title']=plxUtils::getValue($values[$iTags['title'][$i]]['value']);
				# Recuperation de l'url de la bannière
				$this->aBannersQuotes[$id]['url']=plxUtils::getValue($values[$iTags['url'][$i]]['value']);
				# Recuperation de l'url image de la bannière
				$this->aBannersQuotes[$id]['url_img']=plxUtils::getValue($values[$iTags['url_img'][$i]]['value']);
				# Recuperation du group
				$this->aBannersQuotes[$id]['group']=plxUtils::getValue($values[$iTags['group'][$i]]['value']);				
				# Recuperation de l'etat de la bannière/citation
				$this->aBannersQuotes[$id]['active']=intval($attributes['active']);
				$t++;
				}
				}
			}
		}
	}

	public function editBannersQuotes($content, $action=false) {

		$save = $this->aBannersQuotes;
				
		# suppression
		if(!empty($content['selection']) AND $content['selection']=='delete' AND isset($content['id_bannersquotes'])) {
			foreach($content['id_bannersquotes'] as $BannersQuotes_id) {
				unset($this->aBannersQuotes[$BannersQuotes_id]);
				$action = true;
			}
		}
		# mise à jour de la liste des bannières
		elseif(!empty($content['update'])) {
			foreach($content['bannersquotesNum'] as $BannersQuotes_id) {
				$bannersquotes_title = $content[$BannersQuotes_id.'_title'];
				if($bannersquotes_title!='' OR $content[$BannersQuotes_id.'_type'] == 'q') {
					$this->aBannersQuotes[$BannersQuotes_id]['type'] = $content[$BannersQuotes_id.'_type'];					
					$this->aBannersQuotes[$BannersQuotes_id]['title'] = $content[$BannersQuotes_id.'_title'];
					$this->aBannersQuotes[$BannersQuotes_id]['url'] = $content[$BannersQuotes_id.'_url'];					
					$this->aBannersQuotes[$BannersQuotes_id]['url_img'] = $content[$BannersQuotes_id.'_url_img'];
					$this->aBannersQuotes[$BannersQuotes_id]['group'] = $content[$BannersQuotes_id.'_group'];					
					$this->aBannersQuotes[$BannersQuotes_id]['active'] = $content[$BannersQuotes_id.'_active'];
					$action = true;
				}
			}
		}
		# sauvegarde
		if($action AND $content['quote'] != 'quote') {
			$bannersquotes_title = array();
			# On génére le fichier XML
			$xml = "<?xml version=\"1.0\" encoding=\"".PLX_CHARSET."\"?>\n";
			$xml .= "<document>\n";
			foreach($this->aBannersQuotes as $BannersQuotes_id => $BannersQuotes) {

				$xml .= "\t<bannersquotes id=\"".$BannersQuotes_id."\" active=\"".$BannersQuotes['active']."\">";
				$xml .= "<type><![CDATA[".plxUtils::cdataCheck($BannersQuotes['type'])."]]></type>";				
				$xml .= "<title><![CDATA[".plxUtils::cdataCheck($BannersQuotes['title'])."]]></title>";
				$xml .= "<url><![CDATA[".plxUtils::cdataCheck($BannersQuotes['url'])."]]></url>";				
				$xml .= "<url_img><![CDATA[".plxUtils::cdataCheck($BannersQuotes['url_img'])."]]></url_img>";
				$xml .= "<group><![CDATA[".plxUtils::cdataCheck($BannersQuotes['group'])."]]></group>";				
				$xml .=	"</bannersquotes>\n";
			}
			$xml .= "</document>";
			# On écrit le fichier si une action valide a été faite
			if(plxUtils::write($xml,$this->pathname)) {
				$_POST['tp'] =  $content[$_POST['lastid'].'_type'];
				return plxMsg::Info(L_SAVE_SUCCESSFUL);
			} else {
				$this->aBannersQuotes = $save;
				return plxMsg::Error(L_SAVE_ERR.' '.$this->pathname);
			}
		} else { 
			$_POST['tp'] =  $content[$_POST['lastid'].'_type'];	
		}

	}	

	public function getGroups() {
	
	    $this->aGroups = array(); # Tableau de toutes les bannières

		if(!is_file($this->pathgroups)) return $this->aGroups;

		# Mise en place du parseur XML
		$data = implode('',file($this->pathgroups));
		$parser = xml_parser_create(PLX_CHARSET);
		xml_parser_set_option($parser,XML_OPTION_CASE_FOLDING,0);
		xml_parser_set_option($parser,XML_OPTION_SKIP_WHITE,0);
		xml_parse_into_struct($parser,$data,$values,$iTags);
		xml_parser_free($parser);
		if(isset($iTags['grp_bannersquotes']) AND isset($iTags['group'])) {
			$nb = sizeof($iTags['group']);
			for($i=0;$i<$nb;$i++) {
				# Recuperation des groupes
				$this->aGroups[$i]=plxUtils::getValue($values[$iTags['group'][$i]]['value']);				
			}
		}
		return $this->aGroups;
	}
	
	public function editGroups($content, $action=false) {

		$save = $this->getGroups();
		$t = 0;
		
		# suppression
		if(!empty($content['del_group']) AND $content['submit']=='Ok') {
			foreach($save as $v) {
				if ($content['del_group'] == $v) {
				unset($save[$t]);
				}
			$t++;	
			}
		$action = true;	
		}
		# mise à jour de la liste des groupes
		elseif(!empty($content['newgroup'])) {
			$save[] = $content['newgroup'];
			$action = true;
		}
	
		# sauvegarde
		if($action) {
			# On génére le fichier XML
			$xml = "<?xml version=\"1.0\" encoding=\"".PLX_CHARSET."\"?>\n";
			$xml .= "<document>\n";
			foreach($save as $groups) {

				$xml .= "\t<grp_bannersquotes>";
				$xml .= "<group><![CDATA[".plxUtils::cdataCheck($groups)."]]></group>";				
				$xml .=	"</grp_bannersquotes>\n";
			}
			$xml .= "</document>";
			# On écrit le fichier si une action valide a été faite
			if(plxUtils::write($xml,$this->pathgroups)) {
				return plxMsg::Info(L_SAVE_SUCCESSFUL);
			} else {
				$this->aGroups = $save;
				return plxMsg::Error(L_SAVE_ERR.' '.$this->pathgroups);
			}
		}
	}	
	
	public function buildSelectGroup ($default) {
		
		$getGroups = $this->getGroups();
		
		if(!empty($getGroups)) {
		foreach($this->getGroups() as $v) {
			if(!empty($v)) {
				$selectGroup[$v] = $v;
			}
		}
		}
		$selectGroup[''] = $default;
		natsort($selectGroup);
		return $selectGroup;
	}
	
	 public function nextid_BannersQuotes($id) {
		if(is_array($this->aBannersQuotes)) {
			return str_pad($id+1, 3, "0", STR_PAD_LEFT);
		} else {
			return '001';
		}
	}	
	
	public function make_seed() {
		list($usec, $sec) = explode(' ', microtime());
		return (float) $sec + ((float) $usec * 100000);
	}

	public function printSelectType($name, $array, $selected='', $readonly=false, $class='', $id=true) {

		if(!is_array($array)) $array=array();

		if(is_bool($id))
			$id = ($id ? ' id="id_'.$name.'"' : '');
		else
			$id = ($id!='' ? ' id="'.$id.'"' : '');

		if($readonly)
			echo '<select'.$id.' name="'.$name.'" disabled="disabled" class="readonly">'."\n";
		else
			echo '<select'.$id.' name="'.$name.'"'.($class!=''?' class="'.$class.'"':'').' onchange="OnSelectionChange ()" >'."\n";
		foreach($array as $a => $b) {
			if(is_array($b)) {
				echo '<optgroup label="'.$a.'">'."\n";
				foreach($b as $c=>$d) {
					if($c == $selected)
						echo "\t".'<option value="'.$c.'" selected="selected">'.$d.'</option>'."\n";
					else
						echo "\t".'<option value="'.$c.'">'.$d.'</option>'."\n";
				}
				echo '</optgroup>'."\n";
			} else {
				if($a == $selected)
					echo "\t".'<option value="'.$a.'" selected="selected">'.$b.'</option>'."\n";
				else
					echo "\t".'<option value="'.$a.'">'.$b.'</option>'."\n";
			}
		}
		echo '</select>'."\n";
	}
	
	/**
	 * Verification des version des plugins
	 *
	 * @param	plugin				le nom du plugin
	 * @return	array()
	 * @author	DPFPIC
	 **/
	public function UpdatePlugin($plugin) {
	    $array = array();
		$url = 'http://dpfpic.com/plugins.rep';
		$filename = PLX_PLUGINS.$plugin.'/infos.xml';
		
		# Mise en place du parseur XML
		$data = implode('',file($filename));
		$parser = xml_parser_create('UTF-8');
		xml_parser_set_option($parser,XML_OPTION_CASE_FOLDING,0);
		xml_parser_set_option($parser,XML_OPTION_SKIP_WHITE,0);
		xml_parse_into_struct($parser,$data,$strings,$iTags);
		xml_parser_free($parser);
		# Récupération des données xml
		$array['actualversion'] = plxUtils::getValue($strings[$iTags['version'][0]]['value']);
		$array['actualdate'] = plxUtils::getValue($strings[$iTags['date'][0]]['value']);


		if (ini_get('allow_url_fopen')) {
			$handleplugin = @file($url);
		}
		elseif ($curl = @curl_init()){
			$timeout = 5; // set to zero for no timeout
			curl_setopt ($curl, CURLOPT_URL, $url);
			curl_setopt ($curl, CURLOPT_CONNECTTIMEOUT, $timeout);
			curl_setopt ($curl, CURLOPT_RETURNTRANSFER, 1);
			$version_content = curl_exec($curl);
			curl_close($curl);
			if ($version_content != false) {
				$handleplugin = explode("\n", $version_content);
			}
		}	
		if ($handleplugin) {
			$nb = sizeof($handleplugin);
			for($i=0;$i<$nb;$i++) {
				$seach = strstr($handleplugin[$i], '||', true);
				if ($seach == $plugin) {
				    $value = explode('||', $handleplugin[$i]);
					$array['newplugin'] = $value[0];
					$array['newversion'] = $value[1];
					$array['newdate'] = $value[2];
					$array['newurl'] = $value[3];
					$array['active'] = $value[4];
				}
			}
		} else {
			$array ['status'] = 0;
			return $array;
		}
		
		$adate = explode("/", $array['actualdate']); 
		$ndate = explode("/", $array['newdate']);
		$actualdate = $adate[2].$adate[1].$adate[0];
		$newdate = $ndate[2].$ndate[1].$ndate[0];
		
		if (isset($array['actualversion']) AND ($array['actualversion'] == $array['newversion']  AND  $actualdate == $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 1;
			return $array;
		} elseif (isset($array['actualversion']) AND ($array['actualversion'] != $array['newversion'] OR  $actualdate != $newdate) AND $array['active'] == 1 AND $array['newplugin'] == $plugin) {
			$array ['status'] = 2;
			return $array;
		} elseif (isset($array['active']) AND $array['active'] == 0) {
			$array ['status'] = 3;
			return $array;
		} else {
		    $array ['status'] = 0;
			return $array;
		}
	}			
}
?>