<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 **/
include(dirname(__FILE__).'/lib/class.plx.arttooold.php'); 
 
class plxArtTooOld extends plxPlugin {

	/**
	 * Constructeur de la classe
	 *
	 * @param	default_lang	langue par défaut utilisée par PluXml
	 * @return	null
	 * @author	Stephane F
	 **/
	public function __construct($default_lang) {

		# Appel du constructeur de la classe plxPlugin (obligatoire)
		parent::__construct($default_lang);

		# droits pour accéder à la page config.php et admin.php du plugin
		$this->setConfigProfil(PROFIL_ADMIN);
		$this->setAdminProfil(PROFIL_ADMIN);
		
		# Vérification des version du plugin
		$this->arttooold = new arttooold();
		
		# ajout du hook
		$this->addHook('ThemeEndHead', 'ThemeEndHead');
		$this->addHook('plxShowArtTooOld', 'plxShowArtTooOld');		

	}
	
	/**
	 * Méthode qui charge le code css nécessaire pour l'affichage admin
	 *
	 * @return	stdio
	 * @author	Stephane F
	 **/	
	public function AdminTopEndHead() {
		echo "\n\t".'<script type="text/javascript" src="'.PLX_PLUGINS.'plxArtTooOld/js/jscolor/jscolor.js"></script>';
	}	
	
	/**
	 * Méthode qui charge le code css nécessaire pour l'affichage site
	 *
	 * @return	stdio
	 * @author	Stephane F
	 **/
	public function ThemeEndHead() {
		echo "\n\t".'<link rel="stylesheet" href="'.PLX_PLUGINS.'plxArtTooOld/css/plxArtTooOld.css" type="text/css" media="screen" />'."\n";	
		echo "\t".'<style type="text/css">'."\n";
		echo "\t".'.ikaz {'."\n";
		echo "\t".'color: #'.plxUtils::strCheck(plxPlugin::getParam('textColor')).';'."\n";
		echo "\t".'background: #'.plxUtils::strCheck(plxPlugin::getParam('backgrColor')).' url('.plxUtils::getRacine().PLX_PLUGINS.'plxArtTooOld/img/ikaz.png) 2.2em center no-repeat;'."\n";
		echo "\t".'border-color: #'.plxUtils::strCheck(plxPlugin::getParam('borderColor')).';'."\n";
		echo "\t".'}'."\n";	
		echo "\t".'.ikaz a {'."\n";
		echo "\t".'color: #'.plxUtils::strCheck(plxPlugin::getParam('linkColor'))."\n";
		echo "\t".'}'."\n";
		echo "\t".'</style>'."\n";
	}

	/**
	 * Méthode qui affiche le bandeau de notification
	 *
	 * @return	null
	 * @author	DPFPIC
	 **/
	public function plxShowArtTooOld() {
		$plxShow = plxShow::getInstance();
		$startdate = plxDate::formatDate($plxShow->plxMotor->plxRecord_arts->f('date'),'#num_day/#num_month/#num_year(4)');
		$updatedate = plxDate::formatDate($plxShow->plxMotor->plxRecord_arts->f('date_update'),'#num_day/#num_month/#num_year(4)');
		$datetime = plxPlugin::getParam('refDate')=='startdate' ? $this->arttooold->NbJour($startdate) :$this->arttooold->NbJour($updatedate);
		$cat = true;
		ob_start();
		$plxShow->artCat();
		$idCat = ob_get_contents();
		ob_end_clean();
		$old_date = '';
		$array = explode(',', strtolower(plxPlugin::getParam('excluCat')));
		if (in_array(strtolower(strip_tags($idCat)), $array)) {
		  $cat = false;
		}
		
		$refdate = plxPlugin::getParam('refDate')=='startdate' ? $plxShow->plxMotor->plxRecord_arts->f('date') : $plxShow->plxMotor->plxRecord_arts->f('date_update');
		if(floor((strtotime(date('YmdHi')) - strtotime($refdate)) / (60*60*24)) > plxPlugin::getParam('miniDays') AND $cat) {  
		    ($datetime['jours'] == 0 ) ? $separator_m = $this->getLang('L_ATO_AND') : $separator_m = ',';
			($datetime['mois'] == 0 ) ? $separator_j = '' : $separator_j = $this->getLang('L_ATO_AND');
			if ($datetime['ans'] == 0) $separator_m = '';
			if ($datetime['ans'] != 0) $old_date .= $datetime['ans'].' '.$this->getLang('L_ATO_YEAR').' ';
			if ($datetime['mois'] != 0) $old_date .= $separator_m.' '.$datetime['mois'].' '.$this->getLang('L_ATO_MONTH').' ';
			if ($datetime['jours'] != 0) $old_date .= $separator_j.' '.$datetime['jours'].' '.($datetime['jours'] > 1 ? $this->getLang('L_ATO_DAYS') : $this->getLang('L_ATO_DAY'));
			$content = str_replace('%old_date%', '<strong>'.$old_date.'</strong>', plxPlugin::getParam('warningMsg'));
			echo '<!-- plxArtTooOld -->'."\n";
			echo '<div class="ikaz">'."\n";
			echo '<a href="javascript:void(null)" onclick="javascript:this.parentNode.style.display=\'none\';" class="kapat">'."\n";
			echo '<img src="'.PLX_PLUGINS.'plxArtTooOld/img/cross_grey_small.png" title="Close this notification" alt="close"></a>'."\n";
			echo $content."\n";
			echo '</div>'."\n";
			echo '<!-- End plxArTooOld -->'."\n";
		}
	}
}
?>